/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.function.filesleuth.data;

import tim.prune.data.DataPoint;
import tim.prune.data.Distance;
import tim.prune.data.Unit;
import tim.prune.data.UnitSetLibrary;

public class LocationFilter {
    private final DataPoint _point;
    private final String _pointDescription;
    private final int _distanceValue;
    private final Unit _distanceUnit;
    private final double _distanceInMetres;
    private final double _distanceInRadians;

    public LocationFilter(DataPoint dataPoint, String string, int n, Unit unit) {
        this._point = dataPoint;
        this._pointDescription = string;
        this._distanceValue = n;
        this._distanceUnit = unit;
        this._distanceInMetres = Distance.convertBetweenUnits(n, unit, UnitSetLibrary.UNITS_METRES);
        this._distanceInRadians = Distance.convertDistanceToRadians(n, unit);
    }

    public DataPoint getPoint() {
        return this._point;
    }

    public String getPointDescription() {
        return this._pointDescription;
    }

    public int getDistanceValue() {
        return this._distanceValue;
    }

    public Unit getDistanceUnit() {
        return this._distanceUnit;
    }

    public double getDistanceInMetres() {
        return this._distanceInMetres;
    }

    public double getDistanceInRadians() {
        return this._distanceInRadians;
    }

    public boolean doesLocationMatch(double d, double d2) {
        double d3;
        double d4 = this._point.getLatitude().getDouble();
        double d5 = Distance.calculateRadiansBetween(d4, d3 = this._point.getLongitude().getDouble(), d, d2);
        return d5 <= this._distanceInRadians;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        LocationFilter locationFilter = (LocationFilter)object;
        return this._point == locationFilter._point && this._distanceUnit == locationFilter._distanceUnit && this._distanceValue == locationFilter._distanceValue;
    }
}

