/*
 * Decompiled with CFR 0.152.
 */
package ghidra.file.formats.android.bootimg;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.ByteProvider;
import ghidra.file.formats.android.bootimg.BootImageUtil;
import ghidra.file.formats.android.bootimg.VendorBootImageHeader;
import ghidra.file.formats.android.bootimg.VendorBootImageHeaderV3;
import ghidra.file.formats.android.bootimg.VendorBootImageHeaderV4;
import java.io.IOException;

public final class VendorBootImageHeaderFactory {
    public static final VendorBootImageHeader getVendorBootImageHeader(ByteProvider provider, boolean littleEndian) throws IOException {
        return VendorBootImageHeaderFactory.getVendorBootImageHeader(new BinaryReader(provider, littleEndian));
    }

    public static final VendorBootImageHeader getVendorBootImageHeader(BinaryReader reader) throws IOException {
        if (!BootImageUtil.isVendorBootImage(reader)) {
            throw new IOException("VendorBootImageHeader magic not found.");
        }
        int version = reader.readInt(8L);
        switch (version) {
            case 3: {
                return new VendorBootImageHeaderV3(reader);
            }
            case 4: {
                return new VendorBootImageHeaderV4(reader);
            }
        }
        throw new IOException("VendorBootImageHeader unsupported version found: " + version);
    }
}

