/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.analysis;

import ghidra.app.plugin.core.analysis.AutoAnalysisManager;
import ghidra.app.plugin.core.analysis.ConstantPropagationAnalyzer;
import ghidra.app.plugin.core.analysis.ConstantPropagationContextEvaluator;
import ghidra.framework.options.Options;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.lang.Processor;
import ghidra.program.model.lang.Register;
import ghidra.program.model.listing.FlowOverride;
import ghidra.program.model.listing.Instruction;
import ghidra.program.model.listing.Program;
import ghidra.program.model.pcode.Varnode;
import ghidra.program.model.symbol.Reference;
import ghidra.program.model.symbol.ReferenceIterator;
import ghidra.program.model.symbol.ReferenceManager;
import ghidra.program.util.ContextEvaluator;
import ghidra.program.util.SymbolicPropogator;
import ghidra.program.util.VarnodeContext;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;

public class LoongsonAnalyzer
extends ConstantPropagationAnalyzer {
    private Register linkRegister;
    private static final String PROCESSOR_NAME = "Loongarch";

    public LoongsonAnalyzer() {
        super(PROCESSOR_NAME);
    }

    public boolean canAnalyze(Program program) {
        boolean canAnalyze = program.getLanguage().getProcessor().equals((Object)Processor.findOrPossiblyCreateProcessor((String)PROCESSOR_NAME));
        if (!canAnalyze) {
            return false;
        }
        this.linkRegister = program.getProgramContext().getRegister("ra");
        return true;
    }

    public AddressSet flowConstants(final Program program, final Address flowStart, AddressSetView flowSet, SymbolicPropogator symEval, TaskMonitor monitor) throws CancelledException {
        ConstantPropagationContextEvaluator eval = new ConstantPropagationContextEvaluator(monitor, this.trustWriteMemOption){

            private boolean hasDataReferenceTo(Program program2, Address addr) {
                ReferenceManager refMgr = program2.getReferenceManager();
                if (!refMgr.hasReferencesTo(addr)) {
                    return false;
                }
                ReferenceIterator referencesTo = refMgr.getReferencesTo(addr);
                while (referencesTo.hasNext()) {
                    Reference reference = referencesTo.next();
                    if (!reference.getReferenceType().isData()) continue;
                    return true;
                }
                return false;
            }

            private boolean isLinkRegister(VarnodeContext context, Varnode pcVal) {
                return pcVal.isRegister() && pcVal.getAddress().equals((Object)LoongsonAnalyzer.this.linkRegister.getAddress()) || context.isSymbol(pcVal) && pcVal.getAddress().getAddressSpace().getName().equals(LoongsonAnalyzer.this.linkRegister.getName()) && pcVal.getOffset() == 0L;
            }

            public boolean evaluateDestination(VarnodeContext context, Instruction instruction) {
                return super.evaluateDestination(context, instruction);
            }

            public boolean evaluateReturn(Varnode retVN, VarnodeContext context, Instruction instruction) {
                long offset;
                if (instruction.getFlowOverride() != FlowOverride.NONE) {
                    return false;
                }
                if (retVN != null && context.isConstant(retVN) && (offset = retVN.getOffset()) > 3L && offset != -1L) {
                    FlowOverride flowOverride = FlowOverride.CALL_RETURN;
                    instruction.setFlowOverride(flowOverride);
                    AutoAnalysisManager aMgr = AutoAnalysisManager.getAnalysisManager((Program)program);
                    aMgr.codeDefined(flowStart);
                }
                return false;
            }
        };
        eval.setTrustWritableMemory(this.trustWriteMemOption).setMinSpeculativeOffset(this.minSpeculativeRefAddress).setMaxSpeculativeOffset(this.maxSpeculativeRefAddress).setMinStoreLoadOffset(this.minStoreLoadRefAddress).setCreateComplexDataFromPointers(this.createComplexDataFromPointers);
        AddressSet resultSet = symEval.flowConstants(flowStart, flowSet, (ContextEvaluator)eval, true, monitor);
        return resultSet;
    }

    public void optionsChanged(Options options, Program program) {
        super.optionsChanged(options, program);
    }
}

