/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.listing;

import ghidra.program.model.listing.Variable;
import java.util.Comparator;

public class StackVariableComparator
implements Comparator<Object> {
    private static StackVariableComparator acomp = null;

    @Override
    public int compare(Object obj1, Object obj2) {
        Integer offset1 = this.getStackOffset(obj1, "obj1");
        Integer offset2 = this.getStackOffset(obj2, "obj2");
        if (offset1 == null) {
            if (offset2 == null) {
                return 0;
            }
            return 1;
        }
        if (offset2 == null) {
            return -1;
        }
        if (offset1 < offset2) {
            return -1;
        }
        if (offset2 < offset1) {
            return 1;
        }
        return 0;
    }

    private Integer getStackOffset(Object obj, String name) {
        if (obj instanceof Variable) {
            Variable var = (Variable)obj;
            if (var.hasStackStorage()) {
                return (int)var.getLastStorageVarnode().getAddress().getOffset();
            }
            return null;
        }
        if (obj instanceof Integer) {
            return (Integer)obj;
        }
        throw new IllegalArgumentException(name + " is unsupported type: " + obj.getClass().getSimpleName());
    }

    public static StackVariableComparator get() {
        if (acomp == null) {
            acomp = new StackVariableComparator();
        }
        return acomp;
    }
}

