/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf.external;

import ghidra.app.util.bin.format.dwarf.external.BuildIdSearchLocation;
import ghidra.app.util.bin.format.dwarf.external.LocalDirectorySearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SameDirSearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SearchLocation;
import ghidra.app.util.bin.format.dwarf.external.SearchLocationCreatorContext;
import ghidra.program.model.listing.Program;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;

public class SearchLocationRegistry {
    private static final SearchLocationRegistry instance = new SearchLocationRegistry(true);
    private List<SearchLocationCreationInfo> searchLocCreators = new ArrayList<SearchLocationCreationInfo>();

    public static SearchLocationRegistry getInstance() {
        return instance;
    }

    public SearchLocationRegistry(boolean registerDefault) {
        if (registerDefault) {
            this.register(LocalDirectorySearchLocation::isLocalDirSearchLoc, LocalDirectorySearchLocation::create);
            this.register(BuildIdSearchLocation::isBuildIdSearchLocation, BuildIdSearchLocation::create);
            this.register(SameDirSearchLocation::isSameDirSearchLocation, SameDirSearchLocation::create);
        }
    }

    public void register(Predicate<String> testFunc, SearchLocationCreator createFunc) {
        this.searchLocCreators.add(new SearchLocationCreationInfo(testFunc, createFunc));
    }

    public SearchLocationCreatorContext newContext(Program program) {
        return new SearchLocationCreatorContext(this, program);
    }

    public SearchLocation createSearchLocation(String locString, SearchLocationCreatorContext context) {
        for (SearchLocationCreationInfo slci : this.searchLocCreators) {
            if (!slci.testFunc.test(locString)) continue;
            return slci.createFunc.create(locString, context);
        }
        return null;
    }

    public static interface SearchLocationCreator {
        public SearchLocation create(String var1, SearchLocationCreatorContext var2);
    }

    private static class SearchLocationCreationInfo {
        Predicate<String> testFunc;
        SearchLocationCreator createFunc;

        SearchLocationCreationInfo(Predicate<String> testFunc, SearchLocationCreator createFunc) {
            this.testFunc = testFunc;
            this.createFunc = createFunc;
        }
    }
}

