/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.progmgr;

import docking.action.MenuData;
import ghidra.app.plugin.core.progmgr.AbstractProgramNameSwitchingAction;
import ghidra.app.plugin.core.progmgr.ProgramManagerPlugin;
import ghidra.program.model.listing.Program;

public class ProgramOptionsAction
extends AbstractProgramNameSwitchingAction {
    public ProgramOptionsAction(ProgramManagerPlugin plugin) {
        super(plugin, "Program Options");
        MenuData menuData = new MenuData(new String[]{"&Edit", "Program Options"});
        menuData.setMenuGroup("AOptions");
        menuData.setMenuSubGroup("AOptionsb");
        this.setMenuBarData(menuData);
    }

    @Override
    protected void programChanged(Program program) {
        if (program == null) {
            this.getMenuBarData().setMenuItemName("Program Options");
        } else {
            String menuString = "Options for '%s'".formatted(program.getDomainFile().getName());
            this.getMenuBarData().setMenuItemNamePlain(menuString);
        }
    }

    @Override
    public void actionPerformed(Program program) {
        this.plugin.showProgramOptions(program);
    }
}

