/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.navigation;

import generic.theme.GIcon;
import ghidra.app.plugin.core.navigation.AbstractNextPreviousAction;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.CodeUnitIterator;
import ghidra.program.model.listing.Data;
import ghidra.program.model.listing.Program;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import javax.swing.Icon;
import javax.swing.KeyStroke;

public class NextPreviousUndefinedAction
extends AbstractNextPreviousAction {
    private static final Icon ICON = new GIcon("icon.plugin.navigation.undefined");

    public NextPreviousUndefinedAction(PluginTool tool, String owner, String subGroup) {
        super(tool, "Next Undefined", owner, subGroup);
    }

    @Override
    protected Icon getIcon() {
        return ICON;
    }

    @Override
    protected KeyStroke getKeyStroke() {
        return KeyStroke.getKeyStroke(85, 640);
    }

    @Override
    protected String getNavigationTypeName() {
        return "Undefined";
    }

    @Override
    protected Address getNextAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInverted) {
            return this.getNextNonUndefined(monitor, program, address);
        }
        if (this.isUndefinedAt(program, address)) {
            address = this.getAddressOfNextDefined(program, address);
        }
        return this.getAddressOfNextPreviousUndefined(monitor, program, address, true);
    }

    @Override
    protected Address getPreviousAddress(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (this.isInverted) {
            return this.getPreviousNonUndefined(monitor, program, address);
        }
        if (this.isUndefinedAt(program, address)) {
            address = this.getAddressOfPreviousDefined(program, address);
        }
        return this.getAddressOfNextPreviousUndefined(monitor, program, address, false);
    }

    private Address getNextNonUndefined(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (!this.isUndefinedAt(program, address)) {
            address = this.getAddressOfNextPreviousUndefined(monitor, program, address, true);
        }
        return this.getAddressOfNextDefined(program, address);
    }

    private Address getPreviousNonUndefined(TaskMonitor monitor, Program program, Address address) throws CancelledException {
        if (!this.isUndefinedAt(program, address)) {
            address = this.getAddressOfNextPreviousUndefined(monitor, program, address, false);
        }
        return this.getAddressOfPreviousDefined(program, address);
    }

    private boolean isUndefinedAt(Program program, Address address) {
        if (address == null) {
            return false;
        }
        Data data = program.getListing().getDataAt(address);
        if (data == null) {
            return false;
        }
        return !data.isDefined();
    }

    private Address getAddressOfNextDefined(Program program, Address address) {
        CodeUnit cu = program.getListing().getDefinedCodeUnitAfter(address);
        if (cu == null) {
            return null;
        }
        return cu.getMinAddress();
    }

    private Address getAddressOfPreviousDefined(Program program, Address address) {
        CodeUnit cu = program.getListing().getDefinedCodeUnitBefore(address);
        if (cu == null) {
            return null;
        }
        return cu.getMinAddress();
    }

    private Address getAddressOfNextPreviousUndefined(TaskMonitor monitor, Program program, Address address, boolean forward) throws CancelledException {
        if (address == null) {
            return null;
        }
        CodeUnitIterator codeUnits = program.getListing().getCodeUnits(address, forward);
        while (codeUnits.hasNext()) {
            monitor.checkCancelled();
            CodeUnit codeUnit = codeUnits.next();
            if (!(codeUnit instanceof Data) || ((Data)codeUnit).isDefined()) continue;
            return codeUnit.getAddress();
        }
        return null;
    }
}

