/*
 * Decompiled with CFR 0.152.
 */
package io.cucumber.cucumberexpressions;

import io.cucumber.cucumberexpressions.Ast;
import io.cucumber.cucumberexpressions.CucumberExpressionException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.PrimitiveIterator;

final class CucumberExpressionTokenizer {
    CucumberExpressionTokenizer() {
    }

    List<Ast.Token> tokenize(String expression) {
        ArrayList<Ast.Token> tokens = new ArrayList<Ast.Token>();
        this.tokenizeImpl(expression).forEach(tokens::add);
        return tokens;
    }

    private Iterable<Ast.Token> tokenizeImpl(String expression) {
        return () -> new TokenIterator(expression);
    }

    private static class TokenIterator
    implements Iterator<Ast.Token> {
        private final String expression;
        private final PrimitiveIterator.OfInt codePoints;
        private StringBuilder buffer = new StringBuilder();
        private Ast.Token.Type previousTokenType = null;
        private Ast.Token.Type currentTokenType = Ast.Token.Type.START_OF_LINE;
        private boolean treatAsText;
        private int bufferStartIndex;
        private int escaped;

        TokenIterator(String expression) {
            this.expression = expression;
            this.codePoints = expression.codePoints().iterator();
        }

        private Ast.Token convertBufferToToken(Ast.Token.Type tokenType) {
            int escapeTokens = 0;
            if (tokenType == Ast.Token.Type.TEXT) {
                escapeTokens = this.escaped;
                this.escaped = 0;
            }
            int consumedIndex = this.bufferStartIndex + this.buffer.codePointCount(0, this.buffer.length()) + escapeTokens;
            Ast.Token t = new Ast.Token(this.buffer.toString(), tokenType, this.bufferStartIndex, consumedIndex);
            this.buffer = new StringBuilder();
            this.bufferStartIndex = consumedIndex;
            return t;
        }

        private void advanceTokenTypes() {
            this.previousTokenType = this.currentTokenType;
            this.currentTokenType = null;
        }

        private Ast.Token.Type tokenTypeOf(Integer token, boolean treatAsText) {
            if (!treatAsText) {
                return Ast.Token.typeOf(token);
            }
            if (Ast.Token.canEscape(token)) {
                return Ast.Token.Type.TEXT;
            }
            throw CucumberExpressionException.createCantEscape(this.expression, this.bufferStartIndex + this.buffer.codePointCount(0, this.buffer.length()) + this.escaped);
        }

        private boolean shouldContinueTokenType(Ast.Token.Type previousTokenType, Ast.Token.Type currentTokenType) {
            return currentTokenType == previousTokenType && (currentTokenType == Ast.Token.Type.WHITE_SPACE || currentTokenType == Ast.Token.Type.TEXT);
        }

        @Override
        public boolean hasNext() {
            return this.previousTokenType != Ast.Token.Type.END_OF_LINE;
        }

        @Override
        public Ast.Token next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            if (this.currentTokenType == Ast.Token.Type.START_OF_LINE) {
                Ast.Token token = this.convertBufferToToken(this.currentTokenType);
                this.advanceTokenTypes();
                return token;
            }
            while (this.codePoints.hasNext()) {
                int codePoint = this.codePoints.nextInt();
                if (!this.treatAsText && Ast.Token.isEscapeCharacter(codePoint)) {
                    ++this.escaped;
                    this.treatAsText = true;
                    continue;
                }
                this.currentTokenType = this.tokenTypeOf(codePoint, this.treatAsText);
                this.treatAsText = false;
                if (this.previousTokenType == Ast.Token.Type.START_OF_LINE || this.shouldContinueTokenType(this.previousTokenType, this.currentTokenType)) {
                    this.advanceTokenTypes();
                    this.buffer.appendCodePoint(codePoint);
                    continue;
                }
                Ast.Token t = this.convertBufferToToken(this.previousTokenType);
                this.advanceTokenTypes();
                this.buffer.appendCodePoint(codePoint);
                return t;
            }
            if (this.buffer.length() > 0) {
                Ast.Token token = this.convertBufferToToken(this.previousTokenType);
                this.advanceTokenTypes();
                return token;
            }
            this.currentTokenType = Ast.Token.Type.END_OF_LINE;
            if (this.treatAsText) {
                throw CucumberExpressionException.createTheEndOfLineCanNotBeEscaped(this.expression);
            }
            Ast.Token token = this.convertBufferToToken(this.currentTokenType);
            this.advanceTokenTypes();
            return token;
        }
    }
}

