/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.impl.preferences;

import java.util.HashMap;
import java.util.Map;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.model.impl.preferences.AbstractPreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceListener;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.utils.CommonUtils;

public abstract class SimplePreferenceStore
extends AbstractPreferenceStore {
    private DBPPreferenceStore parentStore;
    private Map<String, String> properties;
    private Map<String, String> defaultProperties = new HashMap<String, String>();
    private boolean dirty = false;

    public SimplePreferenceStore() {
        this.properties = new HashMap<String, String>();
    }

    protected SimplePreferenceStore(DBPPreferenceStore parentStore) {
        this();
        this.parentStore = parentStore;
        if (parentStore != null) {
            // empty if block
        }
    }

    public DBPPreferenceStore getParentStore() {
        return this.parentStore;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new HashMap<String, String>(properties);
    }

    public Map<String, String> getDefaultProperties() {
        return this.defaultProperties;
    }

    public void setDefaultProperties(Map<String, String> defaultProperties) {
        this.defaultProperties = new HashMap<String, String>(defaultProperties);
    }

    public void clear() {
        this.properties.clear();
    }

    @Override
    public void addPropertyChangeListener(@NotNull DBPPreferenceListener listener) {
        this.addListenerObject(listener);
    }

    @Override
    public void removePropertyChangeListener(@NotNull DBPPreferenceListener listener) {
        this.removeListenerObject(listener);
    }

    @Override
    public boolean contains(@NotNull String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public boolean getBoolean(@NotNull String name) {
        return this.toBoolean(this.getString(name));
    }

    @Override
    public boolean getDefaultBoolean(@NotNull String name) {
        return this.toBoolean(this.getDefaultString(name));
    }

    @Override
    public double getDouble(@NotNull String name) {
        return this.toDouble(this.getString(name));
    }

    @Override
    public double getDefaultDouble(@NotNull String name) {
        return this.toDouble(this.getDefaultString(name));
    }

    @Override
    public float getFloat(@NotNull String name) {
        return this.toFloat(this.getString(name));
    }

    @Override
    public float getDefaultFloat(@NotNull String name) {
        return this.toFloat(this.getDefaultString(name));
    }

    @Override
    public int getInt(@NotNull String name) {
        return this.toInt(this.getString(name));
    }

    @Override
    public int getDefaultInt(@NotNull String name) {
        return this.toInt(this.getDefaultString(name));
    }

    @Override
    public long getLong(@NotNull String name) {
        return this.toLong(this.getString(name));
    }

    @Override
    public long getDefaultLong(@NotNull String name) {
        return this.toLong(this.getDefaultString(name));
    }

    @Override
    public String getString(@NotNull String name) {
        String value = this.properties.get(name);
        if (value == null && this.parentStore != null) {
            if (this.parentStore.isDefault(name)) {
                value = this.defaultProperties.get(name);
            }
            if (value == null) {
                value = this.parentStore.getString(name);
            }
        }
        return value;
    }

    @Override
    public String getDefaultString(@NotNull String name) {
        String value = this.defaultProperties.get(name);
        if (value == null && this.parentStore != null) {
            if (this.parentStore.isDefault(name)) {
                return this.parentStore.getDefaultString(name);
            }
            return "";
        }
        return value;
    }

    @Override
    public boolean isDefault(@NotNull String name) {
        return !this.properties.containsKey(name) && (this.defaultProperties.containsKey(name) || this.parentStore != null && this.parentStore.isDefault(name));
    }

    public boolean isSet(String name) {
        return this.properties.containsKey(name);
    }

    @Override
    public boolean needsSaving() {
        return this.dirty;
    }

    public String[] preferenceNames() {
        return this.properties.keySet().toArray(new String[0]);
    }

    @Override
    public void setDefault(@NotNull String name, double value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, float value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, int value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, long value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, @Nullable String value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setDefault(@NotNull String name, boolean value) {
        this.defaultProperties.put(name, String.valueOf(value));
    }

    @Override
    public void setToDefault(@NotNull String name) {
        String oldValue = this.properties.get(name);
        this.properties.remove(name);
        this.dirty = true;
        String newValue = null;
        if (this.defaultProperties != null) {
            newValue = this.defaultProperties.get(name);
        }
        this.firePropertyChangeEvent(name, oldValue, newValue);
    }

    @Override
    public void setValue(@NotNull String name, double value) {
        double oldValue = this.getDouble(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    @Override
    public void setValue(@NotNull String name, float value) {
        float oldValue = this.getFloat(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, Float.valueOf(oldValue), Float.valueOf(value));
        }
    }

    @Override
    public void setValue(@NotNull String name, int value) {
        int oldValue = this.getInt(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    @Override
    public void setValue(@NotNull String name, long value) {
        long oldValue = this.getLong(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    @Override
    public void setValue(@NotNull String name, @Nullable String value) {
        String oldValue = this.getString(name);
        if (oldValue == null || !oldValue.equals(value) || !this.isSet(name)) {
            this.properties.put(name, value);
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue, value);
        }
    }

    @Override
    public void setValue(@NotNull String name, boolean value) {
        boolean oldValue = this.getBoolean(name);
        if (oldValue != value || !this.isSet(name)) {
            this.properties.put(name, String.valueOf(value));
            this.dirty = true;
            this.firePropertyChangeEvent(name, oldValue ? Boolean.TRUE : Boolean.FALSE, value ? Boolean.TRUE : Boolean.FALSE);
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SimplePreferenceStore)) {
            return false;
        }
        SimplePreferenceStore copy = (SimplePreferenceStore)obj;
        return CommonUtils.equalObjects((Object)this.parentStore, (Object)copy.parentStore) && CommonUtils.equalObjects(this.properties, copy.properties) && CommonUtils.equalObjects(this.defaultProperties, copy.defaultProperties);
    }
}

