/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.core;

import java.io.PrintStream;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.jkiss.awt.injector.ProxyInjector;
import org.jkiss.dbeaver.ModelPreferences;
import org.jkiss.dbeaver.core.CoreFeatures;
import org.jkiss.dbeaver.core.DesktopPlatform;
import org.jkiss.dbeaver.core.DesktopUI;
import org.jkiss.dbeaver.model.impl.preferences.BundlePreferenceStore;
import org.jkiss.dbeaver.model.preferences.DBPPreferenceStore;
import org.jkiss.dbeaver.model.runtime.features.DBRFeatureRegistry;
import org.jkiss.dbeaver.ui.AWTUtils;
import org.jkiss.dbeaver.ui.ConnectionFeatures;
import org.jkiss.dbeaver.ui.browser.BrowsePeerMethods;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class DBeaverActivator
extends AbstractUIPlugin {
    private static DBeaverActivator instance;
    private ResourceBundle pluginResourceBundle;
    private ResourceBundle coreResourceBundle;
    private PrintStream debugWriter;
    private DBPPreferenceStore preferences;

    public static DBeaverActivator getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        instance = this;
        Bundle bundle = this.getBundle();
        ModelPreferences.setMainBundle((Bundle)bundle);
        this.preferences = new BundlePreferenceStore(bundle);
        DBRFeatureRegistry.getInstance().registerFeatures(CoreFeatures.class);
        DBRFeatureRegistry.getInstance().registerFeatures(ConnectionFeatures.class);
        try {
            this.coreResourceBundle = ResourceBundle.getBundle("org.jkiss.dbeaver.core.CoreResources");
            this.pluginResourceBundle = Platform.getResourceBundle((Bundle)bundle);
        }
        catch (MissingResourceException x) {
            this.coreResourceBundle = null;
        }
        if (this.getPreferenceStore().getBoolean("ui.use.redirect.auth")) {
            try {
                if (AWTUtils.isDesktopSupported()) {
                    this.injectProxyPeer();
                } else {
                    this.getLog().warn("Desktop interface not available");
                    this.getPreferenceStore().setValue("ui.use.redirect.auth", false);
                }
            }
            catch (Throwable e) {
                this.getLog().warn(e.getMessage());
                this.getPreferenceStore().setValue("ui.use.redirect.auth", false);
            }
        }
    }

    private void injectProxyPeer() throws NoSuchFieldException, IllegalAccessException {
        ProxyInjector proxyInjector = new ProxyInjector();
        proxyInjector.injectBrowseInteraction(BrowsePeerMethods::canBrowseInSWTBrowser, BrowsePeerMethods::browseInSWTBrowser);
    }

    public void stop(BundleContext context) throws Exception {
        this.shutdownUI();
        this.shutdownCore();
        if (this.debugWriter != null) {
            this.debugWriter.close();
            this.debugWriter = null;
        }
        instance = null;
        super.stop(context);
    }

    private void shutdownUI() {
        DesktopUI.disposeUI();
    }

    public static ResourceBundle getCoreResourceBundle() {
        return DBeaverActivator.getInstance().coreResourceBundle;
    }

    public static ResourceBundle getPluginResourceBundle() {
        return DBeaverActivator.getInstance().pluginResourceBundle;
    }

    public DBPPreferenceStore getPreferences() {
        return this.preferences;
    }

    private void shutdownCore() {
        try {
            if (DesktopPlatform.instance != null) {
                DesktopPlatform.instance.dispose();
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.err.println("Internal error after shutdown process:" + e.getMessage());
        }
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return DBeaverActivator.imageDescriptorFromPlugin((String)"org.jkiss.dbeaver.core", (String)path);
    }
}

