/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.part;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.Bendpoint;
import org.eclipse.draw2d.Connection;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionLocator;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.Ellipse;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.PolygonDecoration;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.RelativeBendpoint;
import org.eclipse.draw2d.RotatableDecoration;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PointList;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.AccessibleEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.ConnectionEndpointEditPolicy;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.DBIcon;
import org.jkiss.dbeaver.model.DBPImage;
import org.jkiss.dbeaver.model.erd.ERDAssociation;
import org.jkiss.dbeaver.model.erd.ERDEntityAttribute;
import org.jkiss.dbeaver.model.erd.ERDObject;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntityAssociation;
import org.jkiss.dbeaver.ui.DBeaverIcons;
import org.jkiss.dbeaver.ui.UIStyles;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.editors.erd.ERDUIUtils;
import org.jkiss.dbeaver.ui.editors.erd.connector.ERDConnection;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDGraphicalViewer;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDHighlightingHandle;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDHighlightingManager;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDThemeSettings;
import org.jkiss.dbeaver.ui.editors.erd.editor.ERDViewStyle;
import org.jkiss.dbeaver.ui.editors.erd.internal.ERDUIMessages;
import org.jkiss.dbeaver.ui.editors.erd.notations.ERDNotation;
import org.jkiss.dbeaver.ui.editors.erd.notations.ERDNotationDescriptor;
import org.jkiss.dbeaver.ui.editors.erd.part.PropertyAwareConnectionPart;
import org.jkiss.dbeaver.ui.editors.erd.policy.AssociationBendEditPolicy;
import org.jkiss.dbeaver.ui.editors.erd.policy.AssociationEditPolicy;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouter;
import org.jkiss.dbeaver.ui.editors.erd.router.ERDConnectionRouterDescriptor;
import org.jkiss.dbeaver.ui.editors.erd.router.shortpath.ShortPathRouting;
import org.jkiss.dbeaver.utils.ListNode;
import org.jkiss.utils.CommonUtils;

public class AssociationPart
extends PropertyAwareConnectionPart {
    private static final Log log = Log.getLog(AssociationPart.class);
    private Integer oldLineWidth;
    private ERDHighlightingHandle associatedAttributesHighlighing = null;
    protected AbstractGraphicalEditPart.AccessibleGraphicalEditPart accPart;
    private final Color labelForegroundColor;

    public AssociationPart() {
        Color foreground = ERDThemeSettings.instance.attrForeground;
        Color contrastColor = UIStyles.getContrastColor((Color)foreground);
        RGB labelForeground = UIUtils.blend((RGB)foreground.getRGB(), (RGB)contrastColor.getRGB(), (int)60);
        this.labelForegroundColor = UIUtils.getSharedColor((RGB)labelForeground);
    }

    public ERDAssociation getAssociation() {
        return (ERDAssociation)this.getModel();
    }

    @Override
    public void activate() {
        super.activate();
    }

    @Override
    public void deactivate() {
        super.deactivate();
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Connection Endpoint Policy", (EditPolicy)new ConnectionEndpointEditPolicy());
        this.installEditPolicy("Connection Bendpoint Policy", (EditPolicy)new AssociationBendEditPolicy());
        if (!this.getDiagramPart().getEditor().isReadOnly()) {
            if (this.isEditEnabled()) {
                this.installEditPolicy("ComponentEditPolicy", (EditPolicy)new AssociationEditPolicy());
            }
            this.getDiagramPart().getDiagram().getModelAdapter().installPartEditPolicies((EditPart)this);
        }
    }

    protected IFigure createFigure() {
        DBRProgressMonitor monitor = this.getDiagramPart().getDiagram().getMonitor();
        PolylineConnection conn = this.createConnectionFigure(monitor);
        UIUtils.syncExec(() -> {
            this.setConnectionStyles(monitor, conn);
            this.setConnectionRouting(monitor, conn);
            this.setConnectionToolTip(monitor, conn);
        });
        return conn;
    }

    private PolylineConnection createConnectionFigure(@NotNull DBRProgressMonitor monitor) {
        ERDAssociation association;
        ERDConnectionRouter router = this.getDiagramPart().getActiveRouter();
        Object conn = router != null ? router.getConnectionInstance() : new ERDConnection();
        conn.setForegroundColor(ERDThemeSettings.instance.linesForeground);
        if (monitor.isCanceled()) {
            return conn;
        }
        boolean showComments = this.getDiagramPart().getDiagram().hasAttributeStyle(ERDViewStyle.COMMENTS);
        if (showComments && (association = this.getAssociation()) != null && association.getObject() != null && !CommonUtils.isEmpty((String)((DBSEntityAssociation)association.getObject()).getDescription())) {
            ConnectionLocator descLabelLocator = new ConnectionLocator((Connection)conn, 4);
            Label descLabel = new Label(((DBSEntityAssociation)association.getObject()).getDescription());
            descLabel.setForegroundColor(ERDThemeSettings.instance.attrForeground);
            conn.add((IFigure)descLabel, (Object)descLabelLocator);
        }
        return conn;
    }

    protected void setConnectionRouting(@NotNull DBRProgressMonitor monitor, @NotNull PolylineConnection conn) {
        ConnectionRouter entityFigure;
        if (monitor.isCanceled()) {
            return;
        }
        if (this.getViewer() == null) {
            return;
        }
        ERDAssociation association = this.getAssociation();
        ConnectionLayer cLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        ERDConnectionRouterDescriptor router = this.getDiagramPart().getEditor().getDiagramRouter();
        conn.setConnectionRouter(cLayer.getConnectionRouter());
        if (!CommonUtils.isEmpty((Collection)association.getInitBends())) {
            ArrayList<AbsoluteBendpoint> connBends = new ArrayList<AbsoluteBendpoint>();
            for (int[] bend : association.getInitBends()) {
                connBends.add(new AbsoluteBendpoint(bend[0], bend[1]));
            }
            conn.setRoutingConstraint(connBends);
        } else if (association.getTargetEntity() != null && association.getTargetEntity() == association.getSourceEntity()) {
            EditPart entityPart = this.getSource();
            if (entityPart == null) {
                entityPart = this.getTarget();
            }
            if (entityPart instanceof GraphicalEditPart && !router.supportedAttributeAssociation()) {
                entityFigure = ((GraphicalEditPart)entityPart).getFigure();
                Dimension figureSize = entityFigure.getMinimumSize();
                int entityWidth = figureSize.width;
                int entityHeight = figureSize.height;
                ArrayList<RelativeBendpoint> bends = new ArrayList<RelativeBendpoint>();
                int w2 = entityWidth / 2;
                int h2 = entityHeight / 2;
                RelativeBendpoint bp1 = new RelativeBendpoint((Connection)conn);
                bp1.setRelativeDimensions(new Dimension(entityWidth, h2), new Dimension(entityWidth / 2, -h2 + w2));
                bends.add(bp1);
                RelativeBendpoint bp2 = new RelativeBendpoint((Connection)conn);
                bp2.setRelativeDimensions(new Dimension(entityWidth, h2), new Dimension(entityWidth, -h2 + w2 / 2));
                bends.add(bp2);
                RelativeBendpoint bp3 = new RelativeBendpoint((Connection)conn);
                bp3.setRelativeDimensions(new Dimension(entityWidth, h2), new Dimension(entityWidth, -h2 - w2 / 2));
                bends.add(bp3);
                RelativeBendpoint bp4 = new RelativeBendpoint((Connection)conn);
                bp4.setRelativeDimensions(new Dimension(entityWidth, h2), new Dimension(entityWidth / 2, -h2 - w2));
                bends.add(bp4);
                conn.setRoutingConstraint(bends);
            }
        }
        entityFigure = cLayer.getConnectionRouter();
        if (entityFigure instanceof ShortPathRouting) {
            ShortPathRouting shortPathRouting = (ShortPathRouting)entityFigure;
            ERDNotationDescriptor diagramNotationDescriptor = this.getDiagramPart().getEditor().getDiagramNotation();
            shortPathRouting.setIndentation(diagramNotationDescriptor.getNotation().getIndentation());
        }
    }

    protected void setConnectionStyles(@NotNull DBRProgressMonitor monitor, @NotNull PolylineConnection conn) {
        if (monitor.isCanceled()) {
            return;
        }
        ERDNotationDescriptor diagramNotationDescriptor = this.getDiagramPart().getEditor().getDiagramNotation();
        if (diagramNotationDescriptor == null) {
            log.error((Object)"ERD notation descriptor is not defined");
            return;
        }
        Color background = this.getParent().getViewer().getControl().getBackground();
        ERDNotation notation = diagramNotationDescriptor.getNotation();
        if (notation != null) {
            notation.applyNotationForArrows(monitor, conn, this.getAssociation(), background, this.labelForegroundColor);
        } else {
            log.error((Object)("ERD notation instance not created for id: " + diagramNotationDescriptor.getId()));
        }
    }

    protected void setConnectionToolTip(@NotNull DBRProgressMonitor monitor, @NotNull PolylineConnection conn) {
        if (monitor.isCanceled()) {
            return;
        }
        Label toolTip = new Label(((DBSEntityAssociation)this.getAssociation().getObject()).getName() + " [" + ((DBSEntityAssociation)this.getAssociation().getObject()).getConstraintType().getName() + "]");
        toolTip.setIcon(DBeaverIcons.getImage((DBPImage)DBIcon.TREE_FOREIGN_KEY));
        conn.setToolTip((IFigure)toolTip);
    }

    public void setSelected(int value) {
        if (this.getSelected() == value) {
            return;
        }
        super.setSelected(value);
        if (this.oldLineWidth == null) {
            this.oldLineWidth = ((PolylineConnection)this.getFigure()).getLineWidth();
        }
        if (value != 0) {
            ((PolylineConnection)this.getFigure()).setLineWidth(this.oldLineWidth + 3);
        } else {
            ((PolylineConnection)this.getFigure()).setLineWidth(this.oldLineWidth.intValue());
        }
        if (this.getSource() == null || this.getTarget() == null) {
            return;
        }
        if (value != 0) {
            EditPartViewer editPartViewer = this.getViewer();
            if (editPartViewer instanceof ERDGraphicalViewer) {
                ERDGraphicalViewer erdViewer = (ERDGraphicalViewer)editPartViewer;
                if (this.associatedAttributesHighlighing == null) {
                    Color attributeColor = ERDThemeSettings.instance.fkHighlightColor;
                    Color associationColor = ERDThemeSettings.instance.fkHighlightColor;
                    ERDHighlightingManager highlightingManager = erdViewer.getEditor().getHighlightingManager();
                    ListNode<ERDHighlightingHandle> nodes = highlightingManager.highlightRelatedAttributes(this, attributeColor);
                    nodes = highlightingManager.highlightAssociation(nodes, this, associationColor);
                    this.associatedAttributesHighlighing = highlightingManager.makeHighlightingGroupHandle(nodes);
                }
            }
        } else if (this.associatedAttributesHighlighing != null) {
            this.associatedAttributesHighlighing.release();
            this.associatedAttributesHighlighing = null;
        }
    }

    public void performRequest(Request request) {
        if (request.getType() == "open") {
            ERDUIUtils.openObjectEditor(this.getDiagramPart().getDiagram(), (ERDObject)this.getAssociation());
        }
    }

    public void addBendpoint(int bendpointIndex, Point location) {
        AbsoluteBendpoint bendpoint = new AbsoluteBendpoint(location);
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        bendpoints.add(bendpointIndex, (Bendpoint)bendpoint);
        this.updateBendpoints(bendpoints);
    }

    public void removeBendpoint(int bendpointIndex) {
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        if (bendpointIndex < bendpoints.size()) {
            bendpoints.remove(bendpointIndex);
            this.updateBendpoints(bendpoints);
        }
    }

    public void moveBendpoint(int bendpointIndex, Point location) {
        AbsoluteBendpoint bendpoint = new AbsoluteBendpoint(location);
        List<Bendpoint> bendpoints = this.getBendpointsCopy();
        if (bendpointIndex < bendpoints.size()) {
            bendpoints.set(bendpointIndex, (Bendpoint)bendpoint);
            this.updateBendpoints(bendpoints);
        }
    }

    public List<Bendpoint> getBendpoints() {
        Object constraint = this.getConnectionFigure().getRoutingConstraint();
        if (constraint instanceof List) {
            return (List)constraint;
        }
        return Collections.emptyList();
    }

    private List<Bendpoint> getBendpointsCopy() {
        Object constraint = this.getConnectionFigure().getRoutingConstraint();
        if (constraint instanceof List) {
            List curList = (List)constraint;
            return new ArrayList<Bendpoint>(curList);
        }
        return new ArrayList<Bendpoint>();
    }

    private void updateBendpoints(List<Bendpoint> bendpoints) {
        this.getConnectionFigure().setRoutingConstraint(bendpoints);
    }

    public String toString() {
        return ((DBSEntityAssociation)this.getAssociation().getObject()).getConstraintType().getName() + " " + ((DBSEntityAssociation)this.getAssociation().getObject()).getName();
    }

    protected AccessibleEditPart getAccessibleEditPart() {
        if (this.accPart == null) {
            this.accPart = new AbstractGraphicalEditPart.AccessibleGraphicalEditPart(){

                public void getName(AccessibleEvent e) {
                    ERDAssociation association = AssociationPart.this.getAssociation();
                    Object result = "";
                    if (association.isLogical()) {
                        result = (String)result + ERDUIMessages.erd_accessibility_association_part_logical;
                    }
                    StringBuilder sourceString = new StringBuilder();
                    for (ERDEntityAttribute sourceAttribute : association.getSourceAttributes()) {
                        sourceString.append(NLS.bind((String)ERDUIMessages.erd_accessibility_association_part_attribute, (Object)sourceAttribute.getName()));
                    }
                    StringBuilder targetString = new StringBuilder();
                    for (ERDEntityAttribute targetAttribute : association.getTargetAttributes()) {
                        targetString.append(NLS.bind((String)ERDUIMessages.erd_accessibility_association_part_attribute, (Object)targetAttribute.getName()));
                    }
                    e.result = result = (String)result + NLS.bind((String)ERDUIMessages.erd_accessibility_association_part, (Object[])new Object[]{association.getName(), association.getSourceEntity().getName(), sourceString.toString(), association.getTargetEntity().getName(), targetString.toString()});
                }
            };
        }
        return this.accPart;
    }

    public static class RhombusDecoration
    extends PolygonDecoration {
        private static PointList GEOMETRY = new PointList();

        public RhombusDecoration() {
            this.setTemplate(GEOMETRY);
            this.setFill(true);
            this.setScale(5.0, 5.0);
        }

        static {
            GEOMETRY.addPoint(0, 0);
            GEOMETRY.addPoint(-1, 1);
            GEOMETRY.addPoint(-2, 0);
            GEOMETRY.addPoint(-1, -1);
        }
    }

    public static class CircleDecoration
    extends Ellipse
    implements RotatableDecoration {
        private int radius = 4;
        private Point location = new Point();

        public void setRadius(int radius) {
            this.radius = radius;
        }

        public void setLocation(Point p) {
            this.location = p;
            Rectangle bounds = new Rectangle(this.location.x - this.radius, this.location.y - this.radius, this.radius * 2, this.radius * 2);
            this.setBounds(bounds);
        }

        public void setReferencePoint(Point p) {
            double d = Math.sqrt(Math.pow(this.location.x - p.x, 2.0) + Math.pow(this.location.y - p.y, 2.0));
            if (d < (double)this.radius) {
                return;
            }
            double k = (d - (double)this.radius) / d;
            double longx = Math.abs(p.x - this.location.x);
            double longy = Math.abs(p.y - this.location.y);
            double shortx = k * longx;
            double shorty = k * longy;
            int rx = this.location.x < p.x ? p.x - (int)shortx : p.x + (int)shortx;
            int ry = this.location.y > p.y ? p.y + (int)shorty : p.y - (int)shorty;
            this.setBounds(new Rectangle(rx - this.radius, ry - this.radius, (int)((double)this.radius * 2.5), (int)((double)this.radius * 2.5)));
        }
    }
}

