/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.p2.repository.tools.comparator;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.equinox.internal.p2.artifact.processors.checksum.ChecksumUtilities;
import org.eclipse.equinox.internal.p2.artifact.repository.Messages;
import org.eclipse.equinox.p2.internal.repository.comparator.ArtifactChecksumComparator;
import org.eclipse.equinox.p2.repository.tools.comparator.IArtifactComparator;
import org.eclipse.osgi.util.NLS;

public class ArtifactComparatorFactory {
    private static final String COMPARATOR_POINT = "org.eclipse.equinox.p2.artifact.repository.artifactComparators";
    private static final String ATTR_ID = "id";
    private static final String ATTR_CLASS = "class";
    private static final String CHECKSUM_ID = "id";
    private static final String CHECKSUM_ALGORITHM = "algorithm";

    public static IArtifactComparator getArtifactComparator(String comparatorID) {
        Optional<ArtifactChecksumComparator> checksumComparator;
        List<IConfigurationElement> extensions = Stream.of(RegistryFactory.getRegistry().getConfigurationElementsFor(COMPARATOR_POINT)).collect(Collectors.toList());
        extensions.removeIf(extension -> extension.getAttribute("id").equals("org.eclipse.equinox.artifact.comparator.checksum"));
        Optional<IArtifactComparator> artifactComparator = ArtifactComparatorFactory.findComparatorConfiguration(comparatorID, extensions).map(ArtifactComparatorFactory::createArtifactComparator);
        if (artifactComparator.isPresent()) {
            return artifactComparator.get();
        }
        if (comparatorID != null && comparatorID.startsWith("org.eclipse.equinox.artifact.comparator.checksum") && (checksumComparator = ArtifactComparatorFactory.getChecksumComparator(comparatorID)).isPresent()) {
            return checksumComparator.get();
        }
        if (comparatorID != null) {
            Stream<String> checksumComparators = Stream.of(ChecksumUtilities.getChecksumComparatorConfigurations()).map(element -> element.getAttribute("id")).map(checksumId -> "org.eclipse.equinox.artifact.comparator.checksum".concat(".").concat((String)checksumId));
            Stream<String> comparators = extensions.stream().map(extension -> extension.getAttribute("id"));
            String availableComparators = Stream.concat(comparators, checksumComparators).collect(Collectors.joining(", "));
            throw new IllegalArgumentException(NLS.bind((String)Messages.exception_comparatorNotFound, (Object)comparatorID, (Object)availableComparators));
        }
        throw new IllegalArgumentException(Messages.exception_noComparators);
    }

    private static Optional<IConfigurationElement> findComparatorConfiguration(String comparatorID, List<IConfigurationElement> extensions) {
        if (comparatorID == null && extensions.size() > 0) {
            return Optional.ofNullable(extensions.get(0));
        }
        return extensions.stream().filter(extension -> extension.getAttribute("id").equals(comparatorID)).findAny();
    }

    private static IArtifactComparator createArtifactComparator(IConfigurationElement element) {
        try {
            Object execExt = element.createExecutableExtension(ATTR_CLASS);
            if (execExt instanceof IArtifactComparator) {
                return (IArtifactComparator)execExt;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static Optional<ArtifactChecksumComparator> getChecksumComparator(String comparatorId) {
        boolean hasNoChecksumId;
        boolean bl = hasNoChecksumId = !comparatorId.startsWith("org.eclipse.equinox.artifact.comparator.checksum".concat("."));
        if (hasNoChecksumId) {
            return Optional.empty();
        }
        String comparatorChecksum = Optional.ofNullable(comparatorId.substring("org.eclipse.equinox.artifact.comparator.checksum".length() + 1)).orElse("");
        if (comparatorChecksum.isEmpty()) {
            return Optional.empty();
        }
        IConfigurationElement[] comparatorConfigurations = ChecksumUtilities.getChecksumComparatorConfigurations();
        Optional<IConfigurationElement> comparator = Stream.of(comparatorConfigurations).filter(config -> config.getAttribute("id").equals(comparatorChecksum)).findAny();
        return comparator.map(c -> {
            String checksumName = c.getAttribute(CHECKSUM_ALGORITHM);
            String checksumId = c.getAttribute("id");
            return Optional.of(new ArtifactChecksumComparator(checksumId, checksumName));
        }).orElse(Optional.empty());
    }
}

