/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.forms;

import java.util.Objects;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.value.ComputedValue;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.ui.forms.UIObservable;
import org.jkiss.dbeaver.ui.forms.UIObservableImpl;

public final class UIObservables {
    private UIObservables() {
    }

    @NotNull
    public static UIObservable<Boolean> and(final @Nullable UIObservable<Boolean> first, final @Nullable UIObservable<Boolean> second) {
        if (first == null && second == null) {
            throw new IllegalArgumentException("Either first or second must not be null");
        }
        if (first == null) {
            return second;
        }
        if (second == null) {
            return first;
        }
        ComputedValue<Boolean> computed = new ComputedValue<Boolean>(){

            @NotNull
            protected Boolean calculate() {
                return (Boolean)first.get() != false && (Boolean)second.get() != false;
            }
        };
        return new UIObservableImpl<Boolean>((Boolean)computed, Boolean.class);
    }

    @NotNull
    public static <T> UIObservable<Boolean> equals(final @NotNull UIObservable<T> observable, final @NotNull T value) {
        ComputedValue<Boolean> computed = new ComputedValue<Boolean>(){

            @NotNull
            protected Boolean calculate() {
                return Objects.equals(observable.get(), value);
            }

            protected void doSetValue(@NotNull Boolean newValue) {
                if (Objects.equals(observable.get(), newValue)) {
                    return;
                }
                if (newValue.booleanValue()) {
                    observable.set(value);
                    this.fireValueChange(Diffs.createValueDiff((Object)false, (Object)true));
                }
            }
        };
        return new UIObservableImpl<Boolean>((Boolean)computed, Boolean.class);
    }
}

