/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation;

import proguard.evaluation.Stack;
import proguard.evaluation.value.Value;

public class TracedStack
extends Stack {
    private Value producerValue;
    private Stack producerStack;
    private Stack actualProducerStack;

    public TracedStack(int maxSize) {
        super(maxSize);
        this.producerStack = new Stack(maxSize);
        this.actualProducerStack = new Stack(maxSize);
    }

    public TracedStack(TracedStack tracedStack) {
        super(tracedStack);
        this.producerStack = new Stack(tracedStack.producerStack);
        this.actualProducerStack = new Stack(tracedStack.actualProducerStack);
    }

    public void setProducerValue(Value producerValue) {
        this.producerValue = producerValue;
    }

    public Value getBottomProducerValue(int index) {
        return this.producerStack.getBottom(index);
    }

    public Value getBottomActualProducerValue(int index) {
        return this.actualProducerStack.getBottom(index);
    }

    public Value getTopProducerValue(int index) {
        return this.producerStack.getTop(index);
    }

    public Value getTopActualProducerValue(int index) {
        return this.actualProducerStack.getTop(index);
    }

    @Override
    public void reset(int size) {
        super.reset(size);
        this.producerStack.reset(size);
        this.actualProducerStack.reset(size);
    }

    public void copy(TracedStack other) {
        super.copy(other);
        this.producerStack.copy(other.producerStack);
        this.actualProducerStack.copy(other.actualProducerStack);
    }

    public boolean generalize(TracedStack other) {
        return super.generalize(other) | this.producerStack.generalize(other.producerStack) | this.actualProducerStack.generalize(other.actualProducerStack);
    }

    @Override
    public void clear() {
        super.clear();
        this.producerStack.clear();
        this.actualProducerStack.clear();
    }

    @Override
    public void removeTop(int index) {
        super.removeTop(index);
        this.producerStack.removeTop(index);
        this.actualProducerStack.removeTop(index);
    }

    @Override
    public void push(Value value) {
        super.push(value);
        this.producerPush();
        if (value.isCategory2()) {
            this.producerPush();
        }
    }

    @Override
    public Value pop() {
        Value value = super.pop();
        this.producerPop();
        if (value.isCategory2()) {
            this.producerPop();
        }
        return value;
    }

    @Override
    public void pop1() {
        super.pop1();
        this.producerPop();
    }

    @Override
    public void pop2() {
        super.pop2();
        this.producerPop();
        this.producerPop();
    }

    @Override
    public void dup() {
        super.dup();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup();
    }

    @Override
    public void dup_x1() {
        super.dup_x1();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup_x1();
    }

    @Override
    public void dup_x2() {
        super.dup_x2();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup_x2();
    }

    @Override
    public void dup2() {
        super.dup2();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup2();
    }

    @Override
    public void dup2_x1() {
        super.dup2_x1();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup2_x1();
    }

    @Override
    public void dup2_x2() {
        super.dup2_x2();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.dup2_x2();
    }

    @Override
    public void swap() {
        super.swap();
        this.producerStack.pop();
        this.producerStack.pop();
        this.producerStack.push(this.producerValue);
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.swap();
    }

    @Override
    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        TracedStack other = (TracedStack)object;
        return super.equals(object) && this.producerStack.equals(other.producerStack) && this.actualProducerStack.equals(other.actualProducerStack);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.producerStack.hashCode() ^ this.actualProducerStack.hashCode();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        for (int index = 0; index < this.size(); ++index) {
            Value value = this.values[index];
            Value producerValue = this.producerStack.getBottom(index);
            Value actualProducerValue = this.actualProducerStack.getBottom(index);
            buffer = buffer.append('[').append(producerValue == null ? "empty:" : (producerValue.equals(actualProducerValue) ? producerValue.toString() : producerValue.toString() + actualProducerValue.toString())).append(value == null ? "empty" : value.toString()).append(']');
        }
        return buffer.toString();
    }

    private void producerPush() {
        this.producerStack.push(this.producerValue);
        this.actualProducerStack.push(this.producerValue);
    }

    private void producerPop() {
        this.producerStack.pop();
        this.actualProducerStack.pop();
    }
}

