﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/redshift-serverless/RedshiftServerless_EXPORTS.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace RedshiftServerless {
namespace Model {

/**
 * <p>Describes the members of a VPC security group.</p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/redshift-serverless-2021-04-21/VpcSecurityGroupMembership">AWS
 * API Reference</a></p>
 */
class VpcSecurityGroupMembership {
 public:
  AWS_REDSHIFTSERVERLESS_API VpcSecurityGroupMembership() = default;
  AWS_REDSHIFTSERVERLESS_API VpcSecurityGroupMembership(Aws::Utils::Json::JsonView jsonValue);
  AWS_REDSHIFTSERVERLESS_API VpcSecurityGroupMembership& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_REDSHIFTSERVERLESS_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The status of the VPC security group.</p>
   */
  inline const Aws::String& GetStatus() const { return m_status; }
  inline bool StatusHasBeenSet() const { return m_statusHasBeenSet; }
  template <typename StatusT = Aws::String>
  void SetStatus(StatusT&& value) {
    m_statusHasBeenSet = true;
    m_status = std::forward<StatusT>(value);
  }
  template <typename StatusT = Aws::String>
  VpcSecurityGroupMembership& WithStatus(StatusT&& value) {
    SetStatus(std::forward<StatusT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The unique identifier of the VPC security group.</p>
   */
  inline const Aws::String& GetVpcSecurityGroupId() const { return m_vpcSecurityGroupId; }
  inline bool VpcSecurityGroupIdHasBeenSet() const { return m_vpcSecurityGroupIdHasBeenSet; }
  template <typename VpcSecurityGroupIdT = Aws::String>
  void SetVpcSecurityGroupId(VpcSecurityGroupIdT&& value) {
    m_vpcSecurityGroupIdHasBeenSet = true;
    m_vpcSecurityGroupId = std::forward<VpcSecurityGroupIdT>(value);
  }
  template <typename VpcSecurityGroupIdT = Aws::String>
  VpcSecurityGroupMembership& WithVpcSecurityGroupId(VpcSecurityGroupIdT&& value) {
    SetVpcSecurityGroupId(std::forward<VpcSecurityGroupIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_status;

  Aws::String m_vpcSecurityGroupId;
  bool m_statusHasBeenSet = false;
  bool m_vpcSecurityGroupIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace RedshiftServerless
}  // namespace Aws
