﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/glue/Glue_EXPORTS.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace Glue {
namespace Model {
class ListJobsResult {
 public:
  AWS_GLUE_API ListJobsResult() = default;
  AWS_GLUE_API ListJobsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_GLUE_API ListJobsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>The names of all jobs in the account, or the jobs with the specified
   * tags.</p>
   */
  inline const Aws::Vector<Aws::String>& GetJobNames() const { return m_jobNames; }
  template <typename JobNamesT = Aws::Vector<Aws::String>>
  void SetJobNames(JobNamesT&& value) {
    m_jobNamesHasBeenSet = true;
    m_jobNames = std::forward<JobNamesT>(value);
  }
  template <typename JobNamesT = Aws::Vector<Aws::String>>
  ListJobsResult& WithJobNames(JobNamesT&& value) {
    SetJobNames(std::forward<JobNamesT>(value));
    return *this;
  }
  template <typename JobNamesT = Aws::String>
  ListJobsResult& AddJobNames(JobNamesT&& value) {
    m_jobNamesHasBeenSet = true;
    m_jobNames.emplace_back(std::forward<JobNamesT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A continuation token, if the returned list does not contain the last metric
   * available.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListJobsResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListJobsResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::Vector<Aws::String> m_jobNames;

  Aws::String m_nextToken;

  Aws::String m_requestId;
  bool m_jobNamesHasBeenSet = false;
  bool m_nextTokenHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace Glue
}  // namespace Aws
