﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/chime-sdk-identity/ChimeSDKIdentityRequest.h>
#include <aws/chime-sdk-identity/ChimeSDKIdentity_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSString.h>

#include <utility>

namespace Aws {
namespace ChimeSDKIdentity {
namespace Model {

/**
 */
class UpdateAppInstanceUserRequest : public ChimeSDKIdentityRequest {
 public:
  AWS_CHIMESDKIDENTITY_API UpdateAppInstanceUserRequest() = default;

  // Service request name is the Operation name which will send this request out,
  // each operation should has unique request name, so that we can get operation's name from this request.
  // Note: this is not true for response, multiple operations may have the same response name,
  // so we can not get operation's name from response.
  inline virtual const char* GetServiceRequestName() const override { return "UpdateAppInstanceUser"; }

  AWS_CHIMESDKIDENTITY_API Aws::String SerializePayload() const override;

  ///@{
  /**
   * <p>The ARN of the <code>AppInstanceUser</code>.</p>
   */
  inline const Aws::String& GetAppInstanceUserArn() const { return m_appInstanceUserArn; }
  inline bool AppInstanceUserArnHasBeenSet() const { return m_appInstanceUserArnHasBeenSet; }
  template <typename AppInstanceUserArnT = Aws::String>
  void SetAppInstanceUserArn(AppInstanceUserArnT&& value) {
    m_appInstanceUserArnHasBeenSet = true;
    m_appInstanceUserArn = std::forward<AppInstanceUserArnT>(value);
  }
  template <typename AppInstanceUserArnT = Aws::String>
  UpdateAppInstanceUserRequest& WithAppInstanceUserArn(AppInstanceUserArnT&& value) {
    SetAppInstanceUserArn(std::forward<AppInstanceUserArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The name of the <code>AppInstanceUser</code>.</p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  UpdateAppInstanceUserRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The metadata of the <code>AppInstanceUser</code>.</p>
   */
  inline const Aws::String& GetMetadata() const { return m_metadata; }
  inline bool MetadataHasBeenSet() const { return m_metadataHasBeenSet; }
  template <typename MetadataT = Aws::String>
  void SetMetadata(MetadataT&& value) {
    m_metadataHasBeenSet = true;
    m_metadata = std::forward<MetadataT>(value);
  }
  template <typename MetadataT = Aws::String>
  UpdateAppInstanceUserRequest& WithMetadata(MetadataT&& value) {
    SetMetadata(std::forward<MetadataT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_appInstanceUserArn;

  Aws::String m_name;

  Aws::String m_metadata;
  bool m_appInstanceUserArnHasBeenSet = false;
  bool m_nameHasBeenSet = false;
  bool m_metadataHasBeenSet = false;
};

}  // namespace Model
}  // namespace ChimeSDKIdentity
}  // namespace Aws
