/*
 * Decompiled with CFR 0.152.
 */
package tr.extract;

import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import tr.extract.Param;
import tr.model.Data;
import tr.model.DataLookup;
import tr.model.project.Project;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParamProject
extends Param {
    private final boolean includeDone;
    private final String allText;

    public ParamProject(String id, String text, String allText, boolean includeDone) {
        super(Param.Type.COMBOBOX, id, text);
        this.includeDone = includeDone;
        this.allText = allText;
    }

    @Override
    public List<Param.Item> getItems() {
        if (this.items == null) {
            this.initItems();
        }
        return this.items;
    }

    private void initItems() {
        this.items = new Vector();
        this.items.add(new Param.Item(this.allText, "all"));
        Data data = (Data)DataLookup.instance().lookup(Data.class);
        if (data == null) {
            return;
        }
        Iterator i = data.getRootProjects().iterator(Project.class);
        while (i.hasNext()) {
            this.initItems((Project)i.next(), "");
        }
    }

    private void initItems(Project project, String indent) {
        if (!this.includeDone && project.isDone()) {
            return;
        }
        StringBuffer display = new StringBuffer();
        display.append("<HTML>");
        if (project.isDone()) {
            display.append("<STRIKE>");
        }
        display.append(indent + project.getDescription());
        if (project.isDone()) {
            display.append("</STRIKE>");
        }
        display.append("</HTML>");
        this.items.add(new Param.Item(display.toString(), "P" + project.getID()));
        Iterator i = project.iterator(Project.class);
        while (i.hasNext()) {
            this.initItems((Project)i.next(), indent + "&nbsp;&nbsp;");
        }
    }
}

