/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.widget;

import java.awt.AlphaComposite;
import java.awt.Composite;
import java.awt.Graphics2D;
import java.awt.Point;
import org.netbeans.api.visual.widget.Scene;
import org.netbeans.api.visual.widget.Widget;

public class LevelOfDetailsWidget
extends Widget {
    private double hardMinimalZoom;
    private double softMinimalZoom;
    private double softMaximalZoom;
    private double hardMaximalZoom;

    public LevelOfDetailsWidget(Scene scene, double d, double d2, double d3, double d4) {
        super(scene);
        this.hardMinimalZoom = d;
        this.softMinimalZoom = d2;
        this.softMaximalZoom = d3;
        this.hardMaximalZoom = d4;
    }

    public void paintChildren() {
        double d;
        double d2 = this.getScene().getZoomFactor();
        if (d2 <= this.hardMinimalZoom || d2 >= this.hardMaximalZoom) {
            return;
        }
        Graphics2D graphics2D = this.getGraphics();
        Composite composite = null;
        if (this.hardMinimalZoom < d2 && d2 < this.softMinimalZoom) {
            double d3 = this.softMinimalZoom - this.hardMinimalZoom;
            if (d3 > 0.0) {
                d3 = (d2 - this.hardMinimalZoom) / d3;
                composite = graphics2D.getComposite();
                graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d3));
            }
        } else if (this.softMaximalZoom < d2 && d2 < this.hardMaximalZoom && (d = this.hardMaximalZoom - this.softMaximalZoom) > 0.0) {
            d = (this.hardMaximalZoom - d2) / d;
            composite = graphics2D.getComposite();
            graphics2D.setComposite(AlphaComposite.getInstance(3, (float)d));
        }
        super.paintChildren();
        if (composite != null) {
            graphics2D.setComposite(composite);
        }
    }

    public boolean isHitAt(Point point) {
        double d = this.getScene().getZoomFactor();
        if (d < this.hardMinimalZoom || d > this.hardMaximalZoom) {
            return false;
        }
        return super.isHitAt(point);
    }
}

