/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.ui.ribbon.appmenu;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.geom.RoundRectangle2D;
import javax.swing.ButtonModel;
import javax.swing.CellRendererPane;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import org.pushingpixels.flamingo.internal.ui.common.BasicCommandButtonUI;
import org.pushingpixels.flamingo.internal.ui.ribbon.appmenu.JRibbonApplicationMenuButton;
import org.pushingpixels.flamingo.internal.utils.FlamingoUtilities;

public class BasicRibbonApplicationMenuButtonUI
extends BasicCommandButtonUI {
    protected JRibbonApplicationMenuButton applicationMenuButton;

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicRibbonApplicationMenuButtonUI();
    }

    @Override
    public void installUI(JComponent jComponent) {
        this.applicationMenuButton = (JRibbonApplicationMenuButton)jComponent;
        super.installUI(jComponent);
    }

    @Override
    protected void installDefaults() {
        super.installDefaults();
        Border border = this.commandButton.getBorder();
        if (border == null || border instanceof UIResource) {
            Border border2 = UIManager.getBorder("RibbonApplicationMenuButton.border");
            if (border2 == null) {
                border2 = new BorderUIResource.EmptyBorderUIResource(4, 4, 4, 4);
            }
            this.commandButton.setBorder(border2);
        }
        this.commandButton.setOpaque(false);
    }

    @Override
    protected void configureRenderer() {
        this.buttonRendererPane = new CellRendererPane();
        this.commandButton.add(this.buttonRendererPane);
        this.rendererButton = new JButton("");
    }

    @Override
    protected void unconfigureRenderer() {
        this.commandButton.remove(this.buttonRendererPane);
        this.buttonRendererPane = null;
        this.rendererButton = null;
    }

    @Override
    protected void installComponents() {
        super.installComponents();
        JRibbonApplicationMenuButton jRibbonApplicationMenuButton = (JRibbonApplicationMenuButton)this.commandButton;
    }

    @Override
    public void paint(Graphics graphics, JComponent jComponent) {
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        Insets insets = jComponent.getInsets();
        this.paintButtonBackground(graphics2D, new Rectangle(insets.left, insets.top, jComponent.getWidth() - insets.left - insets.right, jComponent.getHeight() - insets.top - insets.bottom));
        this.layoutInfo = this.layoutManager.getLayoutInfo(this.commandButton, graphics);
        this.commandButton.putClientProperty("icon.bounds", this.layoutInfo.iconRect);
        this.paintButtonIcon(graphics2D, this.layoutInfo.iconRect);
        graphics2D.dispose();
    }

    @Override
    protected void paintButtonBackground(Graphics graphics, Rectangle rectangle) {
        this.buttonRendererPane.setBounds(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        ButtonModel buttonModel = this.rendererButton.getModel();
        buttonModel.setEnabled(true);
        buttonModel.setSelected(this.applicationMenuButton.getPopupModel().isSelected());
        buttonModel.setRollover(this.applicationMenuButton.getPopupModel().isRollover());
        buttonModel.setPressed(this.applicationMenuButton.getPopupModel().isPressed() || this.applicationMenuButton.getPopupModel().isPopupShowing());
        buttonModel.setArmed(this.applicationMenuButton.getActionModel().isArmed());
        Graphics2D graphics2D = (Graphics2D)graphics.create();
        graphics2D.translate(rectangle.x, rectangle.y);
        Shape shape = graphics2D.getClip();
        double d = rectangle.height;
        double d2 = rectangle.height;
        graphics2D.clip(new RoundRectangle2D.Double(0.0, 0.0, rectangle.width, rectangle.height, d, d2));
        this.rendererButton.setBorderPainted(false);
        this.buttonRendererPane.paintComponent(graphics2D, this.rendererButton, this.applicationMenuButton, -rectangle.width / 2, -rectangle.height / 2, 2 * rectangle.width, 2 * rectangle.height, true);
        graphics2D.setColor(Color.WHITE);
        graphics2D.setClip(shape);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        graphics2D.fill(new RoundRectangle2D.Double(0.0, 0.0, rectangle.width, rectangle.height, d, d2));
        graphics2D.setColor(FlamingoUtilities.getBorderColor().darker());
        graphics2D.draw(new RoundRectangle2D.Double(0.0, 0.0, rectangle.width, rectangle.height, d, d2));
        graphics2D.dispose();
    }
}

