/*
 * Copyright (C) 2004, 2005 Jean-Yves Lefort
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 3. Neither the name of Jean-Yves Lefort nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
 * CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
 * MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS
 * BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED
 * TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef _TRANSLATE_SERVICE_H
#define _TRANSLATE_SERVICE_H

#include <glib-object.h>
#include <translate-common.h>

G_BEGIN_DECLS

#define TRANSLATE_TYPE_SERVICE			(translate_service_get_type())
#define TRANSLATE_SERVICE(obj)			(G_TYPE_CHECK_INSTANCE_CAST((obj), TRANSLATE_TYPE_SERVICE, TranslateService))
#define TRANSLATE_SERVICE_CLASS(klass)		(G_TYPE_CHECK_CLASS_CAST((klass), TRANSLATE_TYPE_SERVICE, TranslateServiceClass))
#define TRANSLATE_IS_SERVICE(obj)		(G_TYPE_CHECK_INSTANCE_TYPE((obj), TRANSLATE_TYPE_SERVICE))
#define TRANSLATE_IS_SERVICE_CLASS(klass)	(G_TYPE_CHECK_CLASS_TYPE((klass), TRANSLATE_TYPE_SERVICE))
#define TRANSLATE_SERVICE_GET_CLASS(obj)	(G_TYPE_INSTANCE_GET_CLASS((obj), TRANSLATE_TYPE_SERVICE, TranslateServiceClass))

typedef struct _TranslateService		TranslateService;
typedef struct _TranslateServiceClass		TranslateServiceClass;
typedef struct _TranslateServicePrivate		TranslateServicePrivate;

struct _TranslateService
{
  GObject			parent;

  TranslateServicePrivate	*priv;
};

struct _TranslateServiceClass
{
  GObjectClass		parent;

  /*< public >*/

  gboolean	 (*get_pairs)		(TranslateService	 *service,
					 GSList			**pairs,
					 TranslateProgressFunc	  progress_func,
					 gpointer		  user_data,
					 GError			**err);
  char		*(*translate_text)	(TranslateService	 *service,
					 const char		 *text,
					 const char		 *from,
					 const char		 *to,
					 TranslateProgressFunc	  progress_func,
					 gpointer		  user_data,
					 GError			**err);
  char		*(*translate_web_page)	(TranslateService	 *service,
					 const char		 *url,
					 const char		 *from,
					 const char		 *to,
					 TranslateProgressFunc	  progress_func,
					 gpointer		  user_data,
					 GError			**err);

  /*< private >*/

  void (*reserved1) (void);
  void (*reserved2) (void);
  void (*reserved3) (void);
  void (*reserved4) (void);
  void (*reserved5) (void);
  void (*reserved6) (void);
  void (*reserved7) (void);
  void (*reserved8) (void);
};

GType		 translate_service_get_type	     (void);

const char	*translate_service_get_name	     (TranslateService *service);
const char	*translate_service_get_nick	     (TranslateService *service);
unsigned int	 translate_service_get_max_chunk_len (TranslateService *service);
const GSList	*translate_service_get_pairs	     (TranslateService *service);

G_END_DECLS

#endif /* _TRANSLATE_SERVICE_H */
