/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image.analyser;

import java.io.IOException;
import java.io.InputStream;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.image.FopImage;
import org.apache.fop.image.analyser.ImageReader;

public class JPEGReader
implements ImageReader {
    private static final int MARK = 255;
    private static final int NULL = 0;
    private static final int SOF1 = 192;
    private static final int SOF2 = 193;
    private static final int SOF3 = 194;
    private static final int SOFA = 202;
    private static final int APP0 = 224;
    private static final int APPF = 239;
    private static final int SOS = 218;
    private static final int SOI = 216;
    private static final int JPG_SIG_LENGTH = 2;

    public FopImage.ImageInfo verifySignature(String uri, InputStream fis, FOUserAgent ua) throws IOException {
        boolean supported;
        byte[] header = this.getDefaultHeader(fis);
        boolean bl = supported = header[0] == -1 && header[1] == -40;
        if (supported) {
            FopImage.ImageInfo info = this.getDimension(fis);
            info.originalURI = uri;
            info.mimeType = this.getMimeType();
            info.inputStream = fis;
            return info;
        }
        return null;
    }

    public String getMimeType() {
        return "image/jpeg";
    }

    private byte[] getDefaultHeader(InputStream imageStream) throws IOException {
        byte[] header = new byte[2];
        try {
            imageStream.mark(3);
            imageStream.read(header);
            imageStream.reset();
        }
        catch (IOException ex) {
            try {
                imageStream.reset();
            }
            catch (IOException exbis) {
                // empty catch block
            }
            throw ex;
        }
        return header;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private FopImage.ImageInfo getDimension(InputStream imageStream) throws IOException {
        FopImage.ImageInfo info = new FopImage.ImageInfo();
        try {
            int pos = 0;
            int avail = imageStream.available();
            imageStream.mark(avail);
            int marker = 0;
            block10: while (true) {
                if (avail == 0) {
                    imageStream.reset();
                    avail = 2 * pos;
                    imageStream.mark(avail);
                    pos = (int)this.skip(imageStream, pos);
                    avail -= pos;
                }
                marker = imageStream.read();
                ++pos;
                --avail;
                if (marker != 255) continue;
                do {
                    if (avail == 0) {
                        imageStream.reset();
                        avail = 2 * pos;
                        imageStream.mark(avail);
                        pos = (int)this.skip(imageStream, pos);
                        avail -= pos;
                    }
                    marker = imageStream.read();
                    ++pos;
                    --avail;
                } while (marker == 255);
                switch (marker) {
                    case 216: {
                        continue block10;
                    }
                    case 0: {
                        continue block10;
                    }
                    case 224: {
                        if (avail < 14) {
                            imageStream.reset();
                            avail = 2 * pos;
                            imageStream.mark(avail);
                            pos = (int)this.skip(imageStream, pos);
                            avail -= pos;
                        }
                        int reclen = this.read2bytes(imageStream);
                        pos += 2;
                        avail -= 2;
                        this.skip(imageStream, 7L);
                        pos += 7;
                        avail -= 7;
                        int densityUnits = imageStream.read();
                        ++pos;
                        --avail;
                        int xdensity = this.read2bytes(imageStream);
                        pos += 2;
                        avail -= 2;
                        int ydensity = this.read2bytes(imageStream);
                        pos += 2;
                        avail -= 2;
                        if (densityUnits == 2) {
                            info.dpiHorizontal = (double)xdensity * 28.3464567 / 72.0;
                            info.dpiVertical = (double)ydensity * 28.3464567 / 72.0;
                        } else if (densityUnits == 1) {
                            info.dpiHorizontal = xdensity;
                            info.dpiVertical = ydensity;
                        }
                        int restlen = reclen - 12;
                        if (avail < restlen) {
                            imageStream.reset();
                            avail = 2 * pos;
                            if (avail < pos + restlen + 10) {
                                avail = pos + restlen + 10;
                            }
                            imageStream.mark(avail);
                            pos = (int)this.skip(imageStream, pos);
                            avail -= pos;
                        }
                        long skipped = this.skip(imageStream, restlen - 2);
                        pos = (int)((long)pos + skipped);
                        avail = (int)((long)avail - skipped);
                        if (skipped == (long)(restlen - 2)) continue block10;
                        throw new IOException("Skipping Error");
                    }
                    case 192: 
                    case 193: 
                    case 194: 
                    case 202: {
                        while (avail < 7) {
                            imageStream.reset();
                            avail = 2 * pos;
                            imageStream.mark(avail);
                            pos = (int)this.skip(imageStream, pos);
                            avail -= pos;
                        }
                        this.skip(imageStream, 3L);
                        pos += 3;
                        avail -= 3;
                        info.height = this.read2bytes(imageStream);
                        pos += 2;
                        avail -= 2;
                        info.width = this.read2bytes(imageStream);
                        pos += 2;
                        avail -= 2;
                        break block10;
                    }
                    default: {
                        while (avail < 2) {
                            imageStream.reset();
                            avail = 2 * pos;
                            imageStream.mark(avail);
                            pos = (int)this.skip(imageStream, pos);
                            avail -= pos;
                        }
                        long length = this.read2bytes(imageStream);
                        pos += 2;
                        if ((long)(avail -= 2) < length) {
                            imageStream.reset();
                            avail = 2 * pos;
                            if ((long)avail < (long)pos + length + 10L) {
                                avail = (int)((long)pos + length + 10L);
                            }
                            imageStream.mark(avail);
                            pos = (int)this.skip(imageStream, pos);
                            avail -= pos;
                        }
                        long skipped = this.skip(imageStream, length - 2L);
                        pos = (int)((long)pos + skipped);
                        avail = (int)((long)avail - skipped);
                        if (skipped != length - 2L) throw new IOException("Skipping Error");
                        continue block10;
                    }
                }
                break;
            }
            imageStream.reset();
            return info;
        }
        catch (IOException ioe) {
            try {
                imageStream.reset();
                throw ioe;
            }
            catch (IOException exbis) {
                // empty catch block
            }
            throw ioe;
        }
    }

    private int read2bytes(InputStream imageStream) throws IOException {
        int byte1 = imageStream.read();
        int byte2 = imageStream.read();
        return byte1 << 8 | byte2;
    }

    private long skip(InputStream imageStream, long n) throws IOException {
        long discarded;
        for (discarded = 0L; discarded != n; ++discarded) {
            imageStream.read();
        }
        return discarded;
    }
}

