/*
 * Decompiled with CFR 0.152.
 */
package javax.media.opengl;

import com.sun.opengl.impl.Debug;
import com.sun.opengl.impl.GLWorkerThread;
import com.sun.opengl.impl.Java2D;
import java.awt.EventQueue;
import java.lang.reflect.InvocationTargetException;
import java.security.AccessController;
import java.security.PrivilegedAction;
import javax.media.opengl.GLException;

public class Threading {
    private static boolean singleThreaded = true;
    private static final int AWT = 1;
    private static final int WORKER = 2;
    private static int mode;
    private static boolean isX11;

    private Threading() {
    }

    public static void disableSingleThreading() {
        singleThreaded = false;
        if (Debug.verbose()) {
            System.err.println("Application forced disabling of single-threading of javax.media.opengl implementation");
        }
    }

    public static boolean isSingleThreaded() {
        return singleThreaded;
    }

    public static boolean isOpenGLThread() throws GLException {
        if (!Threading.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        switch (mode) {
            case 1: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || isX11 && EventQueue.isDispatchThread();
                }
                return EventQueue.isDispatchThread();
            }
            case 2: {
                if (Java2D.isOGLPipelineActive()) {
                    return Java2D.isQueueFlusherThread() || isX11 && GLWorkerThread.isWorkerThread();
                }
                return GLWorkerThread.isWorkerThread();
            }
        }
        throw new InternalError("Illegal single-threading mode " + mode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void invokeOnOpenGLThread(Runnable runnable) throws GLException {
        if (!Threading.isSingleThreaded()) {
            throw new GLException("Should only call this in single-threaded mode");
        }
        if (Threading.isOpenGLThread()) {
            throw new GLException("Should only call this from other threads than the OpenGL thread");
        }
        switch (mode) {
            case 1: {
                if (Java2D.isOGLPipelineActive() && !isX11) {
                    Java2D.invokeWithOGLContextCurrent(null, runnable);
                    break;
                }
                try {
                    EventQueue.invokeAndWait(runnable);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            case 2: {
                if (!GLWorkerThread.isStarted()) {
                    Class clazz = GLWorkerThread.class;
                    synchronized (clazz) {
                        if (!GLWorkerThread.isStarted()) {
                            GLWorkerThread.start();
                        }
                    }
                }
                try {
                    GLWorkerThread.invokeAndWait(runnable);
                    break;
                }
                catch (InvocationTargetException invocationTargetException) {
                    throw new GLException(invocationTargetException.getTargetException());
                }
                catch (InterruptedException interruptedException) {
                    throw new GLException(interruptedException);
                }
            }
            default: {
                throw new InternalError("Illegal single-threading mode " + mode);
            }
        }
    }

    static boolean isAWTMode() {
        return mode == 1;
    }

    private static void printWorkaroundNotice() {
        if (singleThreaded && Debug.verbose()) {
            System.err.println("Using " + (mode == 1 ? "AWT" : "OpenGL worker") + " thread for performing OpenGL work in javax.media.opengl implementation");
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("opengl.1thread");
                String string2 = System.getProperty("os.name");
                boolean bl = string2.startsWith("Windows");
                isX11 = !bl && !string2.startsWith("Mac OS");
                int n = 1;
                mode = n;
                if (string != null && !(string = string.toLowerCase()).equals("true") && !string.equals("auto")) {
                    if (string.equals("worker")) {
                        singleThreaded = true;
                        mode = 2;
                    } else if (string.equals("awt")) {
                        singleThreaded = true;
                        mode = 1;
                    } else {
                        singleThreaded = false;
                    }
                }
                Threading.printWorkaroundNotice();
                return null;
            }
        });
    }
}

