/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.module.script;

import java.util.Dictionary;
import java.util.Hashtable;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.script.ScriptEngine;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.openhab.core.automation.module.script.ScriptEngineFactory;
import org.openhab.core.automation.module.script.ScriptTransformationService;
import org.openhab.core.automation.module.script.internal.ScriptEngineFactoryHelper;
import org.osgi.service.component.ComponentFactory;
import org.osgi.service.component.ComponentInstance;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(immediate=true, service={ScriptTransformationServiceFactory.class})
@NonNullByDefault
public class ScriptTransformationServiceFactory {
    private final ComponentFactory<ScriptTransformationService> scriptTransformationFactory;
    private final Map<ScriptEngineFactory, ComponentInstance<ScriptTransformationService>> scriptTransformations = new ConcurrentHashMap<ScriptEngineFactory, ComponentInstance<ScriptTransformationService>>();

    @Activate
    public ScriptTransformationServiceFactory(@Reference(target="(component.factory=org.openhab.core.automation.module.script.transformation.factory)") ComponentFactory<ScriptTransformationService> factory) {
        this.scriptTransformationFactory = factory;
    }

    @Deactivate
    public void deactivate() {
        this.scriptTransformations.values().forEach(this::unregisterService);
        this.scriptTransformations.clear();
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    public void setScriptEngineFactory(ScriptEngineFactory engineFactory) {
        Optional<String> scriptType = ScriptEngineFactoryHelper.getPreferredExtension(engineFactory);
        if (scriptType.isEmpty()) {
            return;
        }
        this.scriptTransformations.computeIfAbsent(engineFactory, factory -> {
            ScriptEngine scriptEngine = engineFactory.createScriptEngine((String)scriptType.get());
            if (scriptEngine == null) {
                return null;
            }
            String languageName = ScriptEngineFactoryHelper.getLanguageName(scriptEngine.getFactory());
            Hashtable<String, Object> properties = new Hashtable<String, Object>();
            ((Dictionary)properties).put("openhab.transform", ((String)scriptType.get()).toUpperCase());
            ((Dictionary)properties).put("openhab.transform.label", "SCRIPT " + languageName);
            ((Dictionary)properties).put("openhab.transform.script.scriptType", scriptType.get());
            return this.scriptTransformationFactory.newInstance(properties);
        });
    }

    public void unsetScriptEngineFactory(ScriptEngineFactory engineFactory) {
        ComponentInstance<ScriptTransformationService> toBeUnregistered = this.scriptTransformations.remove(engineFactory);
        if (toBeUnregistered != null) {
            this.unregisterService(toBeUnregistered);
        }
    }

    private void unregisterService(ComponentInstance<ScriptTransformationService> instance) {
        ((ScriptTransformationService)instance.getInstance()).deactivate();
        instance.dispose();
    }
}

