/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.hcl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Set;
import java.util.prefs.Preferences;
import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.indent.spi.CodeStylePreferences;
import org.netbeans.modules.editor.indent.spi.Context;
import org.netbeans.modules.editor.indent.spi.ExtraLock;
import org.netbeans.modules.editor.indent.spi.IndentTask;
import org.netbeans.modules.editor.indent.spi.support.AutomatedIndenting;
import org.netbeans.modules.languages.hcl.HCLTokenId;
import org.netbeans.spi.editor.typinghooks.TypedTextInterceptor;

public class HCLIndenter
implements IndentTask {
    private static final MimePath MIME_HCL = MimePath.get((String)"text/x-hcl");
    private static final Set<HCLTokenId> SKIP_INDENT_WS = EnumSet.of(HCLTokenId.WS, HCLTokenId.NL, HCLTokenId.BLOCK_COMMENT, HCLTokenId.HEREDOC_END, HCLTokenId.HEREDOC);
    private static final Set<HCLTokenId> DONT_INDENT = EnumSet.of(HCLTokenId.BLOCK_COMMENT, HCLTokenId.HEREDOC, HCLTokenId.HEREDOC_START);
    private final Context context;
    private final int indentSize;
    private TokenSequence<HCLTokenId> ts;

    public HCLIndenter(Context context) {
        this.context = context;
        Preferences prefs = CodeStylePreferences.get((Document)context.document()).getPreferences();
        this.indentSize = prefs.getInt("indent-shift-width", 2);
    }

    public void reindent() throws BadLocationException {
        TokenSequence tseq = TokenHierarchy.get((Document)this.context.document()).tokenSequence();
        if (MimePath.parse((String)this.context.mimePath()).getIncludedPaths().contains(MIME_HCL)) {
            this.ts = tseq;
        }
        ArrayList regions = new ArrayList(this.context.indentRegions());
        Collections.reverse(regions);
        if (this.ts != null) {
            for (Context.Region region : regions) {
                int rstart = region.getStartOffset();
                this.ts.move(rstart);
                int prevLineIndent = this.previousIndent(rstart);
                LinkedList<Integer> startOffsets = this.getStartOffsets(region);
                HashMap<Integer, Integer> newIndents = new HashMap<Integer, Integer>();
                for (Integer startOffset : startOffsets) {
                    int delta = this.depthScan(startOffset);
                    int newIndent = prevLineIndent + delta * this.indentSize;
                    newIndent = Math.max(newIndent, 0);
                    Token token = this.ts.token();
                    if (token != null && DONT_INDENT.contains(token.id())) continue;
                    if (this.emptyLine() && startOffset.intValue() != this.context.caretOffset()) {
                        newIndents.put(startOffset, 0);
                        continue;
                    }
                    newIndents.put(startOffset, newIndent);
                    prevLineIndent = newIndent;
                }
                while (!startOffsets.isEmpty()) {
                    Integer startOffset = startOffsets.removeLast();
                    Integer newIndent = (Integer)newIndents.get(startOffset);
                    if (newIndent == null) continue;
                    this.context.modifyIndent(startOffset.intValue(), newIndent.intValue());
                }
            }
        }
    }

    private boolean emptyLine() {
        if (this.ts.token() == null || this.ts.token().id() == HCLTokenId.NL || this.ts.token().id() == HCLTokenId.WS) {
            if (this.ts.moveNext()) {
                if (this.ts.token().id() == HCLTokenId.NL) {
                    return true;
                }
                if (this.ts.token().id() == HCLTokenId.WS) {
                    if (this.ts.moveNext()) {
                        HCLTokenId next = (HCLTokenId)this.ts.token().id();
                        this.ts.movePrevious();
                        return next == HCLTokenId.NL;
                    }
                    return true;
                }
            } else {
                return true;
            }
        }
        return false;
    }

    private int previousIndent(int offset) throws BadLocationException {
        boolean hasPrevious;
        this.ts.move(offset);
        while ((hasPrevious = this.ts.movePrevious()) && SKIP_INDENT_WS.contains(this.ts.token().id())) {
        }
        if (!hasPrevious) {
            return 0;
        }
        int lineStart = this.context.lineStartOffset(this.ts.offset());
        while (this.ts.offset() > lineStart && this.ts.movePrevious()) {
        }
        return this.context.lineIndent(lineStart);
    }

    private int depthScan(int offset) {
        if (offset == 0) {
            return 0;
        }
        int ret = 0;
        Token token = this.ts.token();
        while ((token == null || this.ts.offset() + token.length() < offset) && this.ts.moveNext()) {
            token = this.ts.token();
            if (HCLTokenId.isGroupOpen((HCLTokenId)token.id())) {
                ++ret;
            }
            if (!HCLTokenId.isGroupClose((HCLTokenId)token.id())) continue;
            --ret;
        }
        while (this.ts.moveNext() && (this.ts.token().id() == HCLTokenId.WS || HCLTokenId.isGroupClose((HCLTokenId)this.ts.token().id()))) {
            if (!HCLTokenId.isGroupClose((HCLTokenId)this.ts.token().id())) continue;
            --ret;
        }
        while (this.ts.offset() >= offset) {
            this.ts.movePrevious();
        }
        return ret;
    }

    public ExtraLock indentLock() {
        return null;
    }

    private LinkedList<Integer> getStartOffsets(Context.Region region) throws BadLocationException {
        int lso;
        LinkedList<Integer> offsets = new LinkedList<Integer>();
        int offset = region.getEndOffset();
        while (offset > 0 && (lso = this.context.lineStartOffset(offset)) >= region.getStartOffset()) {
            offsets.addFirst(lso);
            offset = lso - 1;
        }
        return offsets;
    }

    public static class AutoIndentFactory
    implements TypedTextInterceptor.Factory {
        private static final TypedTextInterceptor AUTO_INDENT = AutomatedIndenting.createHotCharsIndenter((Pattern[])new Pattern[]{Pattern.compile("\\s*\\}"), Pattern.compile("\\s*\\]"), Pattern.compile("\\s*\\)")});

        public TypedTextInterceptor createTypedTextInterceptor(MimePath mimePath) {
            return AUTO_INDENT;
        }
    }

    public static class Factory
    implements IndentTask.Factory {
        public IndentTask createTask(Context context) {
            return new HCLIndenter(context);
        }
    }
}

