/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.api;

import java.awt.Image;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.netbeans.modules.hudson.Installer;
import org.netbeans.modules.hudson.api.ConnectionBuilder;
import org.netbeans.modules.hudson.api.HudsonInstance;
import org.netbeans.modules.hudson.api.HudsonJob;
import org.netbeans.modules.hudson.api.HudsonJobBuild;
import org.netbeans.modules.hudson.api.HudsonVersion;
import org.netbeans.modules.hudson.impl.HudsonInstanceImpl;
import org.netbeans.modules.hudson.spi.UIExtension;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.w3c.dom.Element;

public class Utilities {
    private static final XPath xpath = XPathFactory.newInstance().newXPath();

    private Utilities() {
    }

    public static boolean isSupportedVersion(HudsonVersion version) {
        if (null == version) {
            return false;
        }
        return version.compareTo(HudsonVersion.SUPPORTED_VERSION) >= 0;
    }

    public static String uriEncode(String path) {
        Parameters.notNull((CharSequence)"segment", (Object)path);
        try {
            return new URI(null, path, null).toASCIIString();
        }
        catch (URISyntaxException x) {
            throw new IllegalArgumentException(x);
        }
    }

    public static String uriDecode(String string) {
        String d = URI.create(string).getPath();
        if (d.contains("/")) {
            throw new IllegalArgumentException(d);
        }
        return d;
    }

    public static synchronized String xpath(String expr, Element xml) {
        try {
            return xpath.evaluate(expr, xml);
        }
        catch (XPathExpressionException x) {
            Logger.getLogger(Utilities.class.getName()).log(Level.FINE, "cannot evaluate '" + expr + "'", x);
            return null;
        }
    }

    public static boolean isHudsonSupportActive() {
        return Installer.active();
    }

    public static void persistInstance(HudsonInstance instance) {
        if (instance instanceof HudsonInstanceImpl) {
            ((HudsonInstanceImpl)instance).makePersistent();
        }
    }

    public static HudsonJob.Color getColorForBuild(HudsonJobBuild build) {
        switch (build.getResult()) {
            case SUCCESS: {
                return HudsonJob.Color.blue;
            }
            case UNSTABLE: {
                return HudsonJob.Color.yellow;
            }
            case FAILURE: {
                return HudsonJob.Color.red;
            }
        }
        return HudsonJob.Color.grey;
    }

    public static Icon getIcon(HudsonJob job) {
        return Utilities.makeIcon(job.getColor().iconBase());
    }

    public static Icon getIcon(HudsonJobBuild build) {
        return Utilities.makeIcon(Utilities.getColorForBuild(build).iconBase());
    }

    private static Icon makeIcon(String iconBase) {
        return ImageUtilities.image2Icon((Image)ImageUtilities.loadImageIcon((String)iconBase, (boolean)false).getImage());
    }

    public static void showInUI(HudsonJobBuild build) {
        UIExtension ext = Utilities.findUIExtension();
        if (ext != null) {
            ext.showInUI(build);
        }
    }

    public static void showInUI(HudsonJob job) {
        UIExtension ext = Utilities.findUIExtension();
        if (ext != null) {
            ext.showInUI(job);
        }
    }

    private static UIExtension findUIExtension() {
        return (UIExtension)Lookup.getDefault().lookup(UIExtension.class);
    }

    public static HudsonURLCheckResult checkHudsonURL(String url) {
        try {
            URL u = new URL(url);
            HttpURLConnection connection = new ConnectionBuilder().homeURL(u).url(new URL(u, "?checking=redirects")).httpConnection();
            String sVersion = connection.getHeaderField("X-Hudson");
            connection.disconnect();
            if (sVersion == null) {
                return HudsonURLCheckResult.WRONG_VERSION;
            }
            HudsonVersion version = new HudsonVersion(sVersion);
            if (!Utilities.isSupportedVersion(version)) {
                return HudsonURLCheckResult.WRONG_VERSION;
            }
            if (!"checking=redirects".equals(connection.getURL().getQuery())) {
                return HudsonURLCheckResult.INCORRECT_REDIRECTS;
            }
            return HudsonURLCheckResult.OK;
        }
        catch (IOException x) {
            Logger.getLogger(Utilities.class.getName()).log(Level.INFO, null, x);
            return HudsonURLCheckResult.OTHER_ERROR;
        }
    }

    public static enum HudsonURLCheckResult {
        OK,
        WRONG_VERSION,
        INCORRECT_REDIRECTS,
        OTHER_ERROR;


        public boolean isOK() {
            return this == OK;
        }
    }
}

