/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.ui.history;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.CharConversionException;
import java.lang.reflect.InvocationTargetException;
import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.text.AttributeSet;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.api.editor.settings.FontColorSettings;
import org.netbeans.modules.git.options.AnnotationColorProvider;
import org.netbeans.modules.git.ui.history.RepositoryRevision;
import org.netbeans.modules.git.ui.history.RevisionNodeChildren;
import org.netbeans.modules.git.ui.history.SearchHistoryPanel;
import org.netbeans.modules.git.utils.GitUtils;
import org.netbeans.modules.versioning.history.AbstractSummaryView;
import org.openide.ErrorManager;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.ImageUtilities;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

class RevisionNode
extends AbstractNode {
    private static final Image COMMIT_ICON = ImageUtilities.loadImage((String)"/org/netbeans/modules/git/resources/icons/commit.png", (boolean)false);
    private static final Image NO_ICON = ImageUtilities.icon2Image((Icon)new NoIcon());
    static final String COLUMN_NAME_NAME = "name";
    static final String COLUMN_NAME_DATE = "date";
    static final String COLUMN_NAME_USERNAME = "username";
    static final String COLUMN_NAME_MESSAGE = "message";
    static final String COLUMN_NAME_PATH = "path";
    private final RepositoryRevision.Event event;
    private RepositoryRevision container;
    private final String path;
    private String bgColor;
    private String fgColor;

    public RevisionNode(RepositoryRevision container, SearchHistoryPanel master) {
        super((Children)new RevisionNodeChildren(container, master), Lookups.fixed((Object[])new Object[]{master, container}));
        this.container = container;
        this.event = null;
        this.path = null;
        String rev = container.getLog().getRevision();
        String name = rev.length() > 7 ? rev.substring(0, 7) : rev;
        this.setName(name);
        this.setShortDescription(rev);
        this.initProperties();
    }

    public RevisionNode(RepositoryRevision.Event revision, SearchHistoryPanel master) {
        super(Children.LEAF, Lookups.fixed((Object[])new Object[]{master, revision}));
        this.path = revision.getPath();
        this.event = revision;
        this.setName(revision.getName());
        this.setShortDescription(this.path);
        this.initProperties();
    }

    RepositoryRevision.Event getEvent() {
        return this.event;
    }

    public String getHtmlDisplayName() {
        String name = RevisionNode.escape(this.getName());
        if (this.isCommitNode()) {
            return "<b>" + name + "</b>";
        }
        String c = RevisionNode.annotationColorForAction(this.event.getAction());
        return c != null ? "<font color=" + c + ">" + name + "</font>" : name;
    }

    private static String annotationColorForAction(char action) {
        AnnotationColorProvider acp = AnnotationColorProvider.getInstance();
        switch (action) {
            case 'A': {
                return GitUtils.getColorString(acp.ADDED_FILE.getActualColor());
            }
            case 'C': {
                return GitUtils.getColorString(acp.ADDED_FILE.getActualColor());
            }
            case 'M': {
                return GitUtils.getColorString(acp.MODIFIED_FILE.getActualColor());
            }
            case 'R': {
                return null;
            }
            case 'D': {
                return GitUtils.getColorString(acp.REMOVED_FILE.getActualColor());
            }
        }
        return null;
    }

    public Image getIcon(int type) {
        return this.isCommitNode() ? COMMIT_ICON : NO_ICON;
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        if (context) {
            return null;
        }
        if (this.isCommitNode()) {
            return this.container.getActions();
        }
        return this.event.getActions(true);
    }

    private void initProperties() {
        AttributeSet searchHighlightAttrs = ((FontColorSettings)MimeLookup.getLookup((MimePath)MimePath.get((String)"text/x-java")).lookup(FontColorSettings.class)).getFontColors("highlight-search");
        Color c = (Color)searchHighlightAttrs.getAttribute(StyleConstants.Background);
        if (c != null) {
            this.bgColor = GitUtils.getColorString(c);
        }
        if ((c = (Color)searchHighlightAttrs.getAttribute(StyleConstants.Foreground)) != null) {
            this.fgColor = GitUtils.getColorString(c);
        }
        Sheet sheet = Sheet.createDefault();
        Sheet.Set ps = Sheet.createPropertiesSet();
        ps.put((Node.Property)new PathProperty());
        ps.put((Node.Property)new DateProperty());
        ps.put((Node.Property)new UsernameProperty());
        ps.put((Node.Property)new MessageProperty());
        sheet.put(ps);
        this.setSheet(sheet);
    }

    public boolean isCommitNode() {
        return this.event == null;
    }

    private static String escape(String text) {
        try {
            return XMLUtil.toElementContent((String)text);
        }
        catch (CharConversionException ex) {
            Logger.getLogger(RevisionNode.class.getName()).log(Level.INFO, "Can not HTML escape: " + text);
            return "";
        }
    }

    private static String highlight(String text, String needle, String bgColor, String fgColor) {
        int idx;
        if (fgColor != null && bgColor != null && (idx = text.toLowerCase(Locale.ROOT).indexOf(needle)) != -1) {
            return new StringBuilder(256).append("<html><body><nobr>").append(RevisionNode.escape(text.substring(0, idx))).append("<span style=\"background-color: ").append(bgColor).append("; color: ").append(fgColor).append(";\">").append(RevisionNode.escape(text.substring(idx, idx + needle.length()))).append("</span>").append(RevisionNode.escape(text.substring(idx + needle.length()))).append("</nobr></body></html>").toString();
        }
        return text;
    }

    private class PathProperty
    extends CommitNodeProperty {
        public PathProperty() {
            super(RevisionNode.COLUMN_NAME_PATH, String.class, RevisionNode.COLUMN_NAME_PATH, RevisionNode.COLUMN_NAME_PATH);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.isCommitNode()) {
                return "";
            }
            return RevisionNode.this.event.getPath();
        }
    }

    private class DateProperty
    extends CommitNodeProperty {
        public DateProperty() {
            super(RevisionNode.COLUMN_NAME_DATE, String.class, RevisionNode.COLUMN_NAME_DATE, RevisionNode.COLUMN_NAME_DATE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.isCommitNode()) {
                return new Date(RevisionNode.this.container.getLog().getCommitTime());
            }
            return "";
        }

        public Class getValueType() {
            return Date.class;
        }
    }

    private class UsernameProperty
    extends CommitNodeProperty {
        public UsernameProperty() {
            super(RevisionNode.COLUMN_NAME_USERNAME, String.class, RevisionNode.COLUMN_NAME_USERNAME, RevisionNode.COLUMN_NAME_USERNAME);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.isCommitNode()) {
                for (AbstractSummaryView.SummaryViewMaster.SearchHighlight h : ((SearchHistoryPanel)RevisionNode.this.getLookup().lookup(SearchHistoryPanel.class)).getSearchHighlights()) {
                    if (h.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.AUTHOR) continue;
                    return RevisionNode.highlight(RevisionNode.this.container.getLog().getAuthor().toString(), h.getSearchText(), RevisionNode.this.bgColor, RevisionNode.this.fgColor);
                }
                return RevisionNode.this.container.getLog().getAuthor();
            }
            return "";
        }
    }

    private class MessageProperty
    extends CommitNodeProperty {
        public MessageProperty() {
            super(RevisionNode.COLUMN_NAME_MESSAGE, String.class, RevisionNode.COLUMN_NAME_MESSAGE, RevisionNode.COLUMN_NAME_MESSAGE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            if (RevisionNode.this.isCommitNode()) {
                for (AbstractSummaryView.SummaryViewMaster.SearchHighlight h : ((SearchHistoryPanel)RevisionNode.this.getLookup().lookup(SearchHistoryPanel.class)).getSearchHighlights()) {
                    if (h.getKind() != AbstractSummaryView.SummaryViewMaster.SearchHighlight.Kind.MESSAGE) continue;
                    return RevisionNode.highlight(RevisionNode.this.container.getLog().getFullMessage(), h.getSearchText(), RevisionNode.this.bgColor, RevisionNode.this.fgColor);
                }
                return RevisionNode.this.container.getLog().getFullMessage();
            }
            return "";
        }
    }

    private static final class NoIcon
    implements Icon {
        private NoIcon() {
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
        }

        @Override
        public int getIconWidth() {
            return 0;
        }

        @Override
        public int getIconHeight() {
            return 0;
        }
    }

    private static class RevisionPropertyEditor
    extends PropertyEditorSupport {
        private static final JLabel renderer = new JLabel();

        public RevisionPropertyEditor(Object value) {
            this.setValue(value);
        }

        @Override
        public void paintValue(Graphics gfx, Rectangle box) {
            renderer.setForeground(gfx.getColor());
            Object val = this.getValue();
            if (val instanceof Date) {
                val = DateFormat.getDateTimeInstance().format((Date)val);
            }
            renderer.setText(val.toString());
            renderer.setBounds(box);
            renderer.paint(gfx);
        }

        @Override
        public boolean isPaintable() {
            return true;
        }

        static {
            renderer.setBorder(BorderFactory.createEmptyBorder(0, 2, 0, 2));
        }
    }

    private abstract class CommitNodeProperty<T>
    extends PropertySupport.ReadOnly<T> {
        protected CommitNodeProperty(String name, Class<T> type, String displayName, String shortDescription) {
            super(name, type, displayName, shortDescription);
        }

        public String toString() {
            try {
                return this.getValue().toString();
            }
            catch (Exception e) {
                ErrorManager.getDefault().notify(1, (Throwable)e);
                return e.getLocalizedMessage();
            }
        }

        public PropertyEditor getPropertyEditor() {
            try {
                return new RevisionPropertyEditor(this.getValue());
            }
            catch (Exception e) {
                return super.getPropertyEditor();
            }
        }
    }
}

