/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.jakartaee.ide;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.AttachingDICookie;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.modules.payara.spi.VMIntrospector;

public class VMIntrospectorImpl
implements VMIntrospector {
    private static final String LOCALHOST = "localhost";
    private static final String LOCALADDRESS = "127.0.0.1";

    public VMIntrospectorImpl() {
        Logger.getLogger("payara-jakartaee").log(Level.FINE, "VMIntrospector created");
    }

    public boolean isSuspended(String host, String port) {
        Logger.getLogger("payara-jakartaee").log(Level.FINE, "VMIntrospector called {0}, {1}", new Object[]{host, port});
        boolean retVal = false;
        Session[] sessions = DebuggerManager.getDebuggerManager().getSessions();
        for (int i = 0; !retVal && i < sessions.length; ++i) {
            JPDADebugger jpda;
            Object d;
            Object o;
            Session s = sessions[i];
            if (s == null || (o = s.lookupFirst(null, AttachingDICookie.class)) == null || (d = s.lookupFirst(null, JPDADebugger.class)) == null || (jpda = (JPDADebugger)d).getState() != 3) continue;
            AttachingDICookie attCookie = (AttachingDICookie)o;
            String shmName = attCookie.getSharedMemoryName();
            if (shmName != null) {
                if (!shmName.startsWith(port)) continue;
                retVal = true;
                continue;
            }
            int attachedPort = attCookie.getPortNumber();
            if (!this.sameMachine(attCookie.getHostName(), host) || Integer.parseInt(port) != attachedPort) continue;
            retVal = true;
        }
        return retVal;
    }

    boolean sameMachine(String host1, String host2) {
        try {
            String h1;
            String h12;
            String h2;
            String localCanonicalHostName;
            if (host1.equals(host2)) {
                return true;
            }
            if (host1.equals(LOCALHOST)) {
                if (host2.equals(LOCALADDRESS)) {
                    return true;
                }
                localCanonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
                if (localCanonicalHostName.equals(h2 = InetAddress.getByName(host2).getCanonicalHostName())) {
                    return true;
                }
            }
            if (host1.equals(LOCALADDRESS)) {
                if (host2.equals(LOCALHOST)) {
                    return true;
                }
                return true;
            }
            if (host2.equals(LOCALHOST)) {
                if (host1.equals(LOCALADDRESS)) {
                    return true;
                }
                localCanonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
                if (localCanonicalHostName.equals(h12 = InetAddress.getByName(host1).getCanonicalHostName())) {
                    return true;
                }
            }
            if (host2.equals(LOCALADDRESS)) {
                if (host1.equals(LOCALHOST)) {
                    return true;
                }
                localCanonicalHostName = InetAddress.getLocalHost().getCanonicalHostName();
                if (localCanonicalHostName.equals(h12 = InetAddress.getByName(host1).getCanonicalHostName())) {
                    return true;
                }
            }
            if ((h1 = InetAddress.getByName(host1).getCanonicalHostName()).equals(h2 = InetAddress.getByName(host2).getCanonicalHostName())) {
                return true;
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return false;
    }
}

