/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.subversion.ui.commit;

import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.GridLayout;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.LayoutStyle;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.text.JTextComponent;
import javax.swing.text.Keymap;
import org.netbeans.modules.spellchecker.api.Spellchecker;
import org.netbeans.modules.subversion.SvnFileNode;
import org.netbeans.modules.subversion.SvnModuleConfig;
import org.netbeans.modules.subversion.ui.commit.CommitTable;
import org.netbeans.modules.subversion.ui.diff.MultiDiffPanel;
import org.netbeans.modules.subversion.util.SvnUtils;
import org.netbeans.modules.versioning.hooks.SvnHook;
import org.netbeans.modules.versioning.hooks.SvnHookContext;
import org.netbeans.modules.versioning.hooks.VCSHookContext;
import org.netbeans.modules.versioning.util.AutoResizingPanel;
import org.netbeans.modules.versioning.util.ListenersSupport;
import org.netbeans.modules.versioning.util.PlaceholderPanel;
import org.netbeans.modules.versioning.util.StringSelector;
import org.netbeans.modules.versioning.util.TemplateSelector;
import org.netbeans.modules.versioning.util.UndoRedoSupport;
import org.netbeans.modules.versioning.util.Utils;
import org.netbeans.modules.versioning.util.VersioningListener;
import org.netbeans.modules.versioning.util.VerticallyNonResizingPanel;
import org.netbeans.modules.versioning.util.common.CommitMessageMouseAdapter;
import org.netbeans.modules.versioning.util.common.SectionButton;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.awt.TabbedPaneFactory;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.SaveCookie;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.actions.CallbackSystemAction;

public class CommitPanel
extends AutoResizingPanel
implements PreferenceChangeListener,
TableModelListener,
ChangeListener,
PropertyChangeListener {
    private final AutoResizingPanel basePanel = new AutoResizingPanel();
    static final Object EVENT_SETTINGS_CHANGED = new Object();
    private static final boolean DEFAULT_DISPLAY_FILES = true;
    private static final boolean DEFAULT_DISPLAY_HOOKS = false;
    final JLabel filesLabel = new JLabel();
    private final JPanel filesPanel = new JPanel(new GridLayout(1, 1));
    private SectionButton filesSectionButton = new SectionButton();
    private final JPanel filesSectionPanel = new JPanel();
    private SectionButton hooksSectionButton = new SectionButton();
    private final PlaceholderPanel hooksSectionPanel = new PlaceholderPanel();
    private final JLabel jLabel1 = new JLabel();
    private final JLabel jLabel2 = new JLabel();
    private final JScrollPane jScrollPane1 = new JScrollPane();
    private final JTextArea messageTextArea = new JTextArea();
    private final JLabel recentLink = new JLabel();
    private final JLabel templateLink = new JLabel();
    final PlaceholderPanel progressPanel = new PlaceholderPanel();
    private CommitTable commitTable;
    private Collection<SvnHook> hooks = Collections.emptyList();
    private SvnHookContext hookContext;
    private JTabbedPane tabbedPane;
    private HashMap<File, MultiDiffPanel> displayedDiffs = new HashMap();
    private UndoRedoSupport um;
    private final Preferences prefs;
    private int notifyState = 0;
    ListenersSupport listenerSupport = new ListenersSupport((Object)this);

    public CommitPanel() {
        this.prefs = SvnModuleConfig.getDefault().getPreferences();
        this.initComponents();
        this.initInteraction();
    }

    void setHooks(Collection<SvnHook> hooks, SvnHookContext context) {
        if (hooks == null) {
            hooks = Collections.emptyList();
        }
        this.hooks = hooks;
        this.hookContext = context;
    }

    void setCommitTable(CommitTable commitTable) {
        this.commitTable = commitTable;
    }

    void setErrorLabel(String htmlErrorLabel) {
        this.jLabel2.setText(htmlErrorLabel);
    }

    public void addNotify() {
        super.addNotify();
        this.prefs.addPreferenceChangeListener(this);
        if (this.notifyState == 1) {
            Logger.getLogger(CommitPanel.class.getName()).log(Level.WARNING, "addNotify called twice in a row: {0}", this.notifyState);
        }
        this.notifyState = 1;
        this.commitTable.getTableModel().addTableModelListener(this);
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
        this.initCollapsibleSections();
        TemplateSelector ts = new TemplateSelector(this.prefs);
        if (ts.isAutofill()) {
            this.messageTextArea.setText(ts.getTemplate());
        } else {
            List messages;
            String lastCommitMessage = SvnModuleConfig.getDefault().getLastCanceledCommitMessage();
            if (lastCommitMessage.isEmpty() && new StringSelector.RecentMessageSelector(this.prefs).isAutoFill() && (messages = Utils.getStringList((Preferences)this.prefs, (String)"recentCommitMessage")).size() > 0) {
                lastCommitMessage = (String)messages.get(0);
            }
            this.messageTextArea.setText(lastCommitMessage);
        }
        this.messageTextArea.selectAll();
        this.um = UndoRedoSupport.register((JTextComponent)this.messageTextArea);
    }

    public void removeNotify() {
        this.commitTable.getTableModel().removeTableModelListener(this);
        if (this.notifyState != 1) {
            Logger.getLogger(CommitPanel.class.getName()).log(Level.WARNING, "addNotify not called: {0}", this.notifyState);
        }
        this.notifyState = 2;
        this.prefs.removePreferenceChangeListener(this);
        if (this.um != null) {
            this.um.unregister();
            this.um = null;
        }
        super.removeNotify();
    }

    private void initCollapsibleSections() {
        this.initSectionButton(this.filesSectionButton, this.filesSectionPanel, "initFilesPanel", true);
        if (!this.hooks.isEmpty()) {
            Mnemonics.setLocalizedText((AbstractButton)this.hooksSectionButton, (String)(this.hooks.size() == 1 ? this.hooks.iterator().next().getDisplayName() : CommitPanel.getMessage("LBL_Advanced")));
            this.initSectionButton(this.hooksSectionButton, (JPanel)this.hooksSectionPanel, "initHooksPanel", false);
        } else {
            this.hooksSectionButton.setVisible(false);
        }
    }

    private void initSectionButton(SectionButton button, final JPanel panel, final String initPanelMethodName, boolean defaultSectionDisplayed) {
        if (defaultSectionDisplayed) {
            this.displaySection(panel, initPanelMethodName);
        } else {
            this.hideSection(panel);
        }
        button.setSelected(defaultSectionDisplayed);
        button.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent ae) {
                if (panel.isVisible()) {
                    CommitPanel.this.hideSection(panel);
                } else {
                    CommitPanel.this.displaySection(panel, initPanelMethodName);
                }
            }
        });
    }

    private void displaySection(Container sectionPanel, String initPanelMethodName) {
        if (sectionPanel.getComponentCount() == 0) {
            this.invokeInitPanelMethod(initPanelMethodName);
        }
        sectionPanel.setVisible(true);
        this.enlargeVerticallyAsNecessary();
    }

    private void hideSection(JPanel sectionPanel) {
        sectionPanel.setVisible(false);
    }

    private void invokeInitPanelMethod(String methodName) {
        try {
            this.getClass().getDeclaredMethod(methodName, new Class[0]).invoke((Object)this, new Object[0]);
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void initFilesPanel() {
        this.filesPanel.add(this.commitTable.getComponent());
        this.filesPanel.setPreferredSize(new Dimension(0, 2 * this.messageTextArea.getPreferredSize().height));
        this.filesSectionPanel.setLayout(new BoxLayout(this.filesSectionPanel, 1));
        this.filesSectionPanel.add(this.filesLabel);
        this.filesSectionPanel.add(this.makeVerticalStrut(this.filesLabel, this.filesPanel, LayoutStyle.ComponentPlacement.RELATED));
        this.filesSectionPanel.add(this.filesPanel);
        this.filesLabel.setAlignmentX(0.0f);
        this.filesPanel.setAlignmentX(0.0f);
    }

    private void initHooksPanel() {
        assert (!this.hooks.isEmpty());
        if (this.hooks.size() == 1) {
            this.hooksSectionPanel.add((Component)this.hooks.iterator().next().createComponent((VCSHookContext)this.hookContext));
        } else {
            JTabbedPane hooksTabbedPane = new JTabbedPane();
            for (SvnHook hook : this.hooks) {
                hooksTabbedPane.add((Component)hook.createComponent((VCSHookContext)this.hookContext), hook.getDisplayName().replace("&", ""));
            }
            this.hooksSectionPanel.add((Component)hooksTabbedPane);
        }
    }

    String getCommitMessage() {
        return SvnUtils.fixLineEndings(this.messageTextArea.getText());
    }

    private void onBrowseRecentMessages() {
        StringSelector.RecentMessageSelector selector = new StringSelector.RecentMessageSelector(this.prefs);
        String message = selector.getRecentMessage(CommitPanel.getMessage("CTL_CommitForm_RecentTitle"), CommitPanel.getMessage("CTL_CommitForm_RecentPrompt"), Utils.getStringList((Preferences)this.prefs, (String)"recentCommitMessage"));
        if (message != null) {
            this.messageTextArea.replaceSelection(message);
        }
    }

    private void onTemplate() {
        TemplateSelector ts = new TemplateSelector(this.prefs);
        if (ts.show("org.netbeans.modules.subversion.ui.commit.TemplatePanel")) {
            this.messageTextArea.setText(ts.getTemplate());
        }
    }

    @Override
    public void preferenceChange(PreferenceChangeEvent evt) {
        if (evt.getKey().startsWith("commitExclusions")) {
            Runnable inAWT = new Runnable(){

                @Override
                public void run() {
                    CommitPanel.this.commitTable.dataChanged();
                    CommitPanel.this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
                }
            };
            if (EventQueue.isDispatchThread()) {
                inAWT.run();
            } else {
                EventQueue.invokeLater(inAWT);
            }
        }
    }

    @Override
    public void tableChanged(TableModelEvent e) {
        this.listenerSupport.fireVersioningEvent(EVENT_SETTINGS_CHANGED);
    }

    private void initComponents() {
        this.jLabel1.setLabelFor(this.messageTextArea);
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)CommitPanel.getMessage("CTL_CommitForm_Message"));
        this.recentLink.setIcon(ImageUtilities.loadIcon((String)"org/netbeans/modules/subversion/resources/icons/recent_messages.png"));
        this.recentLink.setToolTipText(CommitPanel.getMessage("CTL_CommitForm_RecentMessages"));
        this.templateLink.setIcon(ImageUtilities.loadIcon((String)"org/netbeans/modules/subversion/resources/icons/load_template.png"));
        this.templateLink.setToolTipText(CommitPanel.getMessage("CTL_CommitForm_LoadTemplate"));
        this.messageTextArea.setColumns(70);
        this.messageTextArea.setLineWrap(true);
        this.messageTextArea.setRows(4);
        this.messageTextArea.setTabSize(4);
        this.messageTextArea.setWrapStyleWord(true);
        this.messageTextArea.setMinimumSize(new Dimension(100, 18));
        this.jScrollPane1.setViewportView(this.messageTextArea);
        this.messageTextArea.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitForm_Message"));
        this.messageTextArea.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitForm_Message"));
        this.messageTextArea.addMouseListener((MouseListener)new CommitMessageMouseAdapter());
        Mnemonics.setLocalizedText((AbstractButton)this.filesSectionButton, (String)CommitPanel.getMessage("LBL_CommitDialog_FilesToCommit"));
        Mnemonics.setLocalizedText((JLabel)this.filesLabel, (String)CommitPanel.getMessage("CTL_CommitForm_FilesToCommit"));
        Mnemonics.setLocalizedText((AbstractButton)this.hooksSectionButton, (String)CommitPanel.getMessage("LBL_Advanced"));
        VerticallyNonResizingPanel topPanel = new VerticallyNonResizingPanel();
        topPanel.setLayout(new BoxLayout((Container)topPanel, 0));
        topPanel.add(this.jLabel1);
        topPanel.add(Box.createHorizontalGlue());
        topPanel.add(this.recentLink);
        topPanel.add(this.makeHorizontalStrut(this.recentLink, this.templateLink, LayoutStyle.ComponentPlacement.RELATED));
        topPanel.add(this.templateLink);
        this.jLabel1.setAlignmentY(1.0f);
        this.recentLink.setAlignmentY(1.0f);
        this.templateLink.setAlignmentY(1.0f);
        VerticallyNonResizingPanel bottomPanel = new VerticallyNonResizingPanel();
        bottomPanel.setLayout(new BoxLayout((Container)bottomPanel, 0));
        bottomPanel.add((Component)this.progressPanel);
        this.progressPanel.setAlignmentY(0.5f);
        this.basePanel.setLayout((LayoutManager)new BoxLayout((Container)this.basePanel, 1));
        this.basePanel.add((Component)topPanel);
        this.basePanel.add(this.makeVerticalStrut(this.jLabel1, this.jScrollPane1, LayoutStyle.ComponentPlacement.RELATED));
        this.basePanel.add((Component)this.jScrollPane1);
        this.basePanel.add(this.makeVerticalStrut(this.jScrollPane1, (JComponent)this.filesSectionButton, LayoutStyle.ComponentPlacement.RELATED));
        this.filesSectionButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.filesSectionButton.getMaximumSize().height));
        this.basePanel.add((Component)this.filesSectionButton);
        this.basePanel.add(this.makeVerticalStrut((JComponent)this.filesSectionButton, this.filesSectionPanel, LayoutStyle.ComponentPlacement.RELATED));
        this.basePanel.add((Component)this.filesSectionPanel);
        this.basePanel.add(this.makeVerticalStrut(this.filesSectionPanel, (JComponent)this.hooksSectionButton, LayoutStyle.ComponentPlacement.RELATED));
        this.hooksSectionButton.setMaximumSize(new Dimension(Integer.MAX_VALUE, this.hooksSectionButton.getMaximumSize().height));
        this.basePanel.add((Component)this.hooksSectionButton);
        this.basePanel.add(this.makeVerticalStrut((JComponent)this.hooksSectionButton, (JComponent)this.hooksSectionPanel, LayoutStyle.ComponentPlacement.RELATED));
        this.basePanel.add((Component)this.hooksSectionPanel);
        this.basePanel.add(this.makeVerticalStrut((JComponent)this.hooksSectionPanel, this.jLabel2, LayoutStyle.ComponentPlacement.RELATED));
        this.basePanel.add((Component)this.jLabel2);
        this.basePanel.add(this.makeVerticalStrut((JComponent)this.hooksSectionPanel, (JComponent)bottomPanel, LayoutStyle.ComponentPlacement.RELATED));
        this.basePanel.add((Component)bottomPanel);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add((Component)this.basePanel);
        topPanel.setAlignmentX(0.0f);
        this.jScrollPane1.setAlignmentX(0.0f);
        this.filesSectionButton.setAlignmentX(0.0f);
        this.filesSectionPanel.setAlignmentX(0.0f);
        this.hooksSectionButton.setAlignmentX(0.0f);
        this.hooksSectionPanel.setAlignmentX(0.0f);
        bottomPanel.setAlignmentX(0.0f);
        this.basePanel.setBorder(BorderFactory.createEmptyBorder(26, this.getContainerGap(7), 0, 15));
        this.getAccessibleContext().setAccessibleName(CommitPanel.getMessage("ACSN_CommitDialog"));
        this.getAccessibleContext().setAccessibleDescription(CommitPanel.getMessage("ACSD_CommitDialog"));
    }

    private void initInteraction() {
        this.recentLink.setCursor(Cursor.getPredefinedCursor(12));
        this.recentLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommitPanel.this.onBrowseRecentMessages();
            }
        });
        this.templateLink.setCursor(Cursor.getPredefinedCursor(12));
        this.templateLink.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                CommitPanel.this.onTemplate();
            }
        });
        Spellchecker.register((JTextComponent)this.messageTextArea);
        this.initActions();
    }

    private Component makeVerticalStrut(JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement relatedUnrelated) {
        int height = LayoutStyle.getInstance().getPreferredGap(compA, compB, relatedUnrelated, 5, (Container)((Object)this));
        return Box.createVerticalStrut(height);
    }

    private Component makeHorizontalStrut(JComponent compA, JComponent compB, LayoutStyle.ComponentPlacement relatedUnrelated) {
        int width = LayoutStyle.getInstance().getPreferredGap(compA, compB, relatedUnrelated, 7, (Container)((Object)this));
        return Box.createHorizontalStrut(width);
    }

    private int getContainerGap(int direction) {
        return LayoutStyle.getInstance().getContainerGap((JComponent)((Object)this), direction, null);
    }

    private static String getMessage(String msgKey) {
        return NbBundle.getMessage(CommitPanel.class, (String)msgKey);
    }

    public void addVersioningListener(VersioningListener listener) {
        this.listenerSupport.addListener(listener);
    }

    public void removeVersioningListener(VersioningListener listener) {
        this.listenerSupport.removeListener(listener);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.tabbedPane && this.tabbedPane.getSelectedComponent() == this.basePanel) {
            this.commitTable.setModifiedFiles(new HashSet<File>(this.getModifiedFiles().keySet()));
        }
    }

    protected boolean processKeyBinding(KeyStroke ks, KeyEvent e, int condition, boolean pressed) {
        boolean ret = super.processKeyBinding(ks, e, condition, pressed);
        if (1 == condition && !ret && !e.isConsumed()) {
            Action action;
            Keymap km = (Keymap)Lookup.getDefault().lookup(Keymap.class);
            Action action2 = action = km != null ? km.getAction(ks) : null;
            if (action == null) {
                return false;
            }
            if (action instanceof CallbackSystemAction) {
                Action a;
                CallbackSystemAction csAction = (CallbackSystemAction)action;
                if (this.tabbedPane != null && (a = this.tabbedPane.getActionMap().get(csAction.getActionMapKey())) != null) {
                    a.actionPerformed(new ActionEvent(this, 1001, Utilities.keyToString((KeyStroke)ks)));
                    return true;
                }
            }
            return false;
        }
        return ret;
    }

    void openDiff(SvnFileNode[] nodes) {
        for (SvnFileNode node : nodes) {
            File file;
            MultiDiffPanel panel;
            if (this.tabbedPane == null) {
                this.initializeTabs();
            }
            if ((panel = this.displayedDiffs.get(file = node.getFile())) == null) {
                panel = new MultiDiffPanel(file, "BASE", "LOCAL", false);
                this.displayedDiffs.put(file, panel);
            }
            if (this.tabbedPane.indexOfComponent(panel) == -1) {
                this.tabbedPane.addTab(file.getName(), panel);
            }
            this.tabbedPane.setSelectedComponent(panel);
            this.tabbedPane.requestFocusInWindow();
            panel.requestActive();
        }
        this.revalidate();
        this.repaint();
    }

    SaveCookie[] getSaveCookies() {
        return this.getModifiedFiles().values().toArray(new SaveCookie[0]);
    }

    EditorCookie[] getEditorCookies() {
        LinkedList<EditorCookie> allCookies = new LinkedList<EditorCookie>();
        for (Map.Entry<File, MultiDiffPanel> e : this.displayedDiffs.entrySet()) {
            EditorCookie[] cookies = e.getValue().getEditorCookies(true);
            if (cookies.length <= 0) continue;
            allCookies.add(cookies[0]);
        }
        return allCookies.toArray(new EditorCookie[0]);
    }

    boolean canCommit() {
        boolean result = true;
        if (this.tabbedPane != null && this.tabbedPane.getSelectedComponent() != this.basePanel) {
            NotifyDescriptor nd = new NotifyDescriptor((Object)NbBundle.getMessage(CommitPanel.class, (String)"MSG_CommitDialog_CommitFromDiff"), NbBundle.getMessage(CommitPanel.class, (String)"LBL_CommitDialog_CommitFromDiff"), 0, 3, null, NotifyDescriptor.YES_OPTION);
            result = NotifyDescriptor.YES_OPTION == DialogDisplayer.getDefault().notify(nd);
        }
        return result;
    }

    private void initializeTabs() {
        this.tabbedPane = TabbedPaneFactory.createCloseButtonTabbedPane();
        this.tabbedPane.addPropertyChangeListener(this);
        this.tabbedPane.addTab(NbBundle.getMessage(CommitPanel.class, (String)"CTL_CommitDialog_Tab_Commit"), (Component)this.basePanel);
        this.tabbedPane.setPreferredSize(this.basePanel.getPreferredSize());
        this.add(this.tabbedPane);
        this.tabbedPane.addChangeListener(this);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if ("close".equals(evt.getPropertyName())) {
            JComponent comp = (JComponent)evt.getNewValue();
            this.removeTab(comp);
        }
    }

    private void removeTab(JComponent comp) {
        if (this.basePanel != comp && this.tabbedPane != null && this.tabbedPane.getTabCount() > 1) {
            this.tabbedPane.remove(comp);
            this.revalidate();
        }
    }

    private HashMap<File, SaveCookie> getModifiedFiles() {
        HashMap<File, SaveCookie> modifiedFiles = new HashMap<File, SaveCookie>();
        for (Map.Entry<File, MultiDiffPanel> e : this.displayedDiffs.entrySet()) {
            SaveCookie[] cookies = e.getValue().getSaveCookies(false);
            if (cookies.length <= 0) continue;
            modifiedFiles.put(e.getKey(), cookies[0]);
        }
        return modifiedFiles;
    }

    private void initActions() {
        InputMap inputMap = this.getInputMap(1);
        ActionMap actionMap = this.getActionMap();
        inputMap.put(KeyStroke.getKeyStroke(82, 512, false), "messageHistory");
        actionMap.put("messageHistory", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommitPanel.this.onBrowseRecentMessages();
            }
        });
        inputMap.put(KeyStroke.getKeyStroke(76, 512, false), "messageTemplate");
        actionMap.put("messageTemplate", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CommitPanel.this.onTemplate();
            }
        });
    }
}

