/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.project.ui.logicalview;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.Icon;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.php.project.PhpProject;
import org.netbeans.modules.php.project.ProjectPropertiesSupport;
import org.netbeans.modules.php.project.ui.actions.DebugFileCommand;
import org.netbeans.modules.php.project.ui.actions.DownloadCommand;
import org.netbeans.modules.php.project.ui.actions.RunFileCommand;
import org.netbeans.modules.php.project.ui.actions.RunTestCommand;
import org.netbeans.modules.php.project.ui.actions.RunTestsCommand;
import org.netbeans.modules.php.project.ui.actions.SyncCommand;
import org.netbeans.modules.php.project.ui.actions.UploadCommand;
import org.netbeans.modules.php.project.ui.actions.support.CommandUtils;
import org.netbeans.modules.php.project.ui.logicalview.PhpLogicalViewProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.FileSensitiveActions;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.actions.FileSystemAction;
import org.openide.actions.FindAction;
import org.openide.actions.PasteAction;
import org.openide.actions.ToolsAction;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUIUtils;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFilter;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.ProxyLookup;

@SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
public class SrcNode
extends FilterNode {
    static final String PACKAGE_BADGE_IMAGE = "org/netbeans/modules/php/project/ui/resources/packageBadge.gif";
    static final String WEB_ROOT_BADGE_IMAGE = "org/netbeans/modules/php/project/ui/resources/webRootBadge.gif";
    private final PhpProject project;
    private final boolean isTest;
    private final FileObject fo;
    static final Action[] COMMON_ACTIONS = new Action[]{null, FileSensitiveActions.fileCommandAction((String)"download", (String)DownloadCommand.DISPLAY_NAME, null), FileSensitiveActions.fileCommandAction((String)"upload", (String)UploadCommand.DISPLAY_NAME, null), FileSensitiveActions.fileCommandAction((String)"synchronize", (String)SyncCommand.DISPLAY_NAME, null)};

    SrcNode(PhpProject project, DataFolder folder, DataFilter filter, String name, boolean isTest) {
        this(project, folder, new FilterNode(folder.getNodeDelegate(), folder.createNodeChildren(filter)), name, isTest);
    }

    private SrcNode(final PhpProject project, DataFolder folder, final FilterNode node, String name, final boolean isTest) {
        super((Node)node, Children.createLazy((Callable)new Callable<Children>(){

            @Override
            public Children call() throws Exception {
                return new FolderChildren(project, (Node)node, isTest);
            }
        }), (Lookup)new ProxyLookup(new Lookup[]{folder.getNodeDelegate().getLookup()}));
        this.project = project;
        this.isTest = isTest;
        this.fo = folder.getPrimaryFile();
        this.disableDelegation(172);
        this.setDisplayName(name);
    }

    public String getShortDescription() {
        return FileUtil.getFileDisplayName((FileObject)this.fo);
    }

    public Image getIcon(int type) {
        return ImageUtilities.mergeImages((Image)super.getIcon(type), (Image)ImageUtilities.loadImage((String)PACKAGE_BADGE_IMAGE, (boolean)false), (int)7, (int)7);
    }

    public Image getOpenedIcon(int type) {
        return ImageUtilities.mergeImages((Image)super.getOpenedIcon(type), (Image)ImageUtilities.loadImage((String)PACKAGE_BADGE_IMAGE, (boolean)false), (int)7, (int)7);
    }

    public boolean canCopy() {
        return false;
    }

    public boolean canCut() {
        return false;
    }

    public boolean canRename() {
        return false;
    }

    public boolean canDestroy() {
        return false;
    }

    public Action[] getActions(boolean context) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(CommonProjectActions.newFileAction());
        actions.add(null);
        if (!this.isTest) {
            actions.add(FileSensitiveActions.fileCommandAction((String)"download", (String)DownloadCommand.DISPLAY_NAME, null));
            actions.add(FileSensitiveActions.fileCommandAction((String)"upload", (String)UploadCommand.DISPLAY_NAME, null));
            actions.add(FileSensitiveActions.fileCommandAction((String)"synchronize", (String)SyncCommand.DISPLAY_NAME, null));
            actions.add(null);
        } else if (this.project.getTestRoots().getRoots().length > 1) {
            actions.add(ProjectSensitiveActions.projectCommandAction((String)"runTestsInFolder", (String)RunTestsCommand.DISPLAY_NAME, null));
            actions.add(null);
        }
        actions.add((Action)SystemAction.get(FileSystemAction.class));
        actions.add(null);
        actions.add((Action)SystemAction.get(FindAction.class));
        actions.add(null);
        actions.add((Action)SystemAction.get(PasteAction.class));
        actions.add(null);
        actions.add((Action)SystemAction.get(ToolsAction.class));
        actions.add(null);
        Action customizeAction = null;
        customizeAction = this.isTest ? new PhpLogicalViewProvider.CustomizeProjectAction(this.project, "Testing") : CommonProjectActions.customizeProjectAction();
        if (customizeAction != null) {
            actions.add(customizeAction);
        }
        return actions.toArray(new Action[0]);
    }

    public static Action createDownloadAction() {
        return COMMON_ACTIONS[1];
    }

    public static Action createUploadAction() {
        return COMMON_ACTIONS[2];
    }

    public static Action createSynchronizeAction() {
        return COMMON_ACTIONS[3];
    }

    @SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    private static final class ObjectNode
    extends FilterNode {
        private final Node originalNode;
        private final boolean isTest;

        public ObjectNode(Node originalNode, boolean isTest) {
            super(originalNode);
            this.originalNode = originalNode;
            this.isTest = isTest;
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.addAll(Arrays.asList(this.getOriginal().getActions(context)));
            int idx = actions.indexOf(null);
            Action[] toAdd = this.getCommonActions();
            for (int i = 0; i < toAdd.length; ++i) {
                if (idx >= 0 && idx + toAdd.length < actions.size()) {
                    actions.add(idx + i + 1, toAdd[i]);
                    continue;
                }
                actions.add(toAdd[i]);
            }
            Iterator it = actions.iterator();
            while (it.hasNext()) {
                Action action = (Action)it.next();
                if (action == null || action.getClass().getName().indexOf("WhereUsedAction") == -1) continue;
                it.remove();
                break;
            }
            return actions.toArray(new Action[0]);
        }

        private Action[] getCommonActions() {
            ArrayList<Action> toAdd = new ArrayList<Action>();
            if (CommandUtils.isPhpOrHtmlFile(this.getFileObject())) {
                toAdd.add(null);
                toAdd.add(ProjectSensitiveActions.projectCommandAction((String)"run.single", (String)RunFileCommand.DISPLAY_NAME, null));
                toAdd.add(ProjectSensitiveActions.projectCommandAction((String)"debug.single", (String)DebugFileCommand.DISPLAY_NAME, null));
                if (!this.isTest) {
                    toAdd.add(ProjectSensitiveActions.projectCommandAction((String)"test.single", (String)RunTestCommand.DISPLAY_NAME, null));
                }
            }
            ArrayList<Action> actions = new ArrayList<Action>(COMMON_ACTIONS.length + toAdd.size());
            actions.addAll(toAdd);
            if (!this.isTest) {
                actions.addAll(Arrays.asList(COMMON_ACTIONS));
            }
            actions.add(null);
            return actions.toArray(new Action[0]);
        }

        private FileObject getFileObject() {
            FileObject fileObject = (FileObject)this.originalNode.getLookup().lookup(FileObject.class);
            if (fileObject != null) {
                return fileObject;
            }
            DataObject dataObject = (DataObject)this.originalNode.getLookup().lookup(DataObject.class);
            assert (dataObject != null);
            fileObject = dataObject.getPrimaryFile();
            assert (fileObject != null);
            return fileObject;
        }
    }

    @SuppressWarnings(value={"EQ_DOESNT_OVERRIDE_EQUALS"})
    private static final class PackageNode
    extends FilterNode {
        private static final Logger LOGGER = Logger.getLogger(PackageNode.class.getName());
        private final PhpProject project;
        private final boolean isTest;
        private final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                FileObject folder;
                String propertyName = evt.getPropertyName();
                if ("webRoot".equals(propertyName) && (Objects.equals(folder = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class), evt.getOldValue()) || Objects.equals(folder, evt.getNewValue()))) {
                    this.fireIconChange();
                    this.fireOpenedIconChange();
                }
            }
        };

        public PackageNode(PhpProject project, Node originalNode, boolean isTest) {
            super(originalNode, (Children)new FolderChildren(project, originalNode, isTest), (Lookup)new ProxyLookup(new Lookup[]{originalNode.getLookup()}));
            this.project = project;
            this.isTest = isTest;
            ProjectPropertiesSupport.addWeakProjectPropertyChangeListener(project, this.propertyChangeListener);
        }

        public Action[] getActions(boolean context) {
            ArrayList<Action> actions = new ArrayList<Action>();
            actions.addAll(Arrays.asList(this.getOriginal().getActions(context)));
            Action[] commonActions = this.getCommonActions();
            int idx = actions.indexOf(null);
            for (int i = 0; i < commonActions.length; ++i) {
                if (idx >= 0 && idx + commonActions.length < actions.size()) {
                    actions.add(idx + i + 1, commonActions[i]);
                    continue;
                }
                actions.add(commonActions[i]);
            }
            return actions.toArray(new Action[0]);
        }

        public Image getIcon(int type) {
            return this.getIcon(type, false);
        }

        public Image getOpenedIcon(int type) {
            return this.getIcon(type, true);
        }

        private Image getIcon(int type, boolean opened) {
            Image originalIcon;
            FileObject folder = (FileObject)this.getOriginal().getLookup().lookup(FileObject.class);
            Project owner = FileOwnerQuery.getOwner((FileObject)folder);
            if (owner != null && !owner.equals(this.project) && owner.getProjectDirectory().equals(folder)) {
                originalIcon = ImageUtilities.icon2Image((Icon)ProjectUtils.getInformation((Project)owner).getIcon());
                try {
                    HashSet clds = new HashSet();
                    Collections.addAll(clds, owner.getProjectDirectory().getChildren());
                    originalIcon = FileUIUtils.getImageDecorator((FileSystem)owner.getProjectDirectory().getFileSystem()).annotateIcon(originalIcon, type, clds);
                }
                catch (FileStateInvalidException e) {
                    LOGGER.log(Level.INFO, null, e);
                }
            } else {
                Image image = originalIcon = opened ? super.getOpenedIcon(type) : super.getIcon(type);
            }
            if (folder.equals(ProjectPropertiesSupport.getWebRootDirectory(this.project)) && !folder.equals(ProjectPropertiesSupport.getSourcesDirectory(this.project))) {
                return ImageUtilities.mergeImages((Image)originalIcon, (Image)ImageUtilities.loadImage((String)SrcNode.WEB_ROOT_BADGE_IMAGE, (boolean)false), (int)7, (int)7);
            }
            return originalIcon;
        }

        private Action[] getCommonActions() {
            if (this.isTest) {
                return new Action[]{ProjectSensitiveActions.projectCommandAction((String)"runTestsInFolder", (String)RunTestsCommand.DISPLAY_NAME, null), null};
            }
            Action[] actions = new Action[COMMON_ACTIONS.length + 1];
            System.arraycopy(COMMON_ACTIONS, 0, actions, 0, COMMON_ACTIONS.length);
            actions[actions.length - 1] = null;
            return actions;
        }
    }

    static class FolderChildren
    extends FilterNode.Children {
        private final PhpProject project;
        private final boolean isTest;

        FolderChildren(PhpProject project, Node originalNode, boolean isTest) {
            super(originalNode);
            this.project = project;
            this.isTest = isTest;
        }

        protected Node[] createNodes(Node key) {
            return super.createNodes(key);
        }

        protected Node copyNode(Node originalNode) {
            FileObject fo = (FileObject)originalNode.getLookup().lookup(FileObject.class);
            if (fo == null) {
                Logger.getLogger(FolderChildren.class.getName()).log(Level.WARNING, "No fileobject found for node: {0}", originalNode);
                return super.copyNode(originalNode);
            }
            if (fo.isFolder()) {
                return new PackageNode(this.project, originalNode, this.isTest);
            }
            return new ObjectNode(originalNode, this.isTest);
        }
    }
}

