/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core;

import com.oracle.bmc.ClientConfiguration;
import com.oracle.bmc.Region;
import com.oracle.bmc.Service;
import com.oracle.bmc.Services;
import com.oracle.bmc.auth.AbstractAuthenticationDetailsProvider;
import com.oracle.bmc.auth.BasicAuthenticationDetailsProvider;
import com.oracle.bmc.common.ClientBuilderBase;
import com.oracle.bmc.common.RegionalClientBuilder;
import com.oracle.bmc.core.ComputeAsync;
import com.oracle.bmc.core.model.AppCatalogListing;
import com.oracle.bmc.core.model.AppCatalogListingResourceVersion;
import com.oracle.bmc.core.model.AppCatalogListingResourceVersionAgreements;
import com.oracle.bmc.core.model.AppCatalogListingResourceVersionSummary;
import com.oracle.bmc.core.model.AppCatalogListingSummary;
import com.oracle.bmc.core.model.AppCatalogSubscription;
import com.oracle.bmc.core.model.AppCatalogSubscriptionSummary;
import com.oracle.bmc.core.model.BootVolumeAttachment;
import com.oracle.bmc.core.model.CapacityReservationInstanceSummary;
import com.oracle.bmc.core.model.ComputeCapacityReport;
import com.oracle.bmc.core.model.ComputeCapacityReservation;
import com.oracle.bmc.core.model.ComputeCapacityReservationInstanceShapeSummary;
import com.oracle.bmc.core.model.ComputeCapacityReservationSummary;
import com.oracle.bmc.core.model.ComputeCluster;
import com.oracle.bmc.core.model.ComputeClusterCollection;
import com.oracle.bmc.core.model.ComputeGlobalImageCapabilitySchema;
import com.oracle.bmc.core.model.ComputeGlobalImageCapabilitySchemaSummary;
import com.oracle.bmc.core.model.ComputeGlobalImageCapabilitySchemaVersion;
import com.oracle.bmc.core.model.ComputeGlobalImageCapabilitySchemaVersionSummary;
import com.oracle.bmc.core.model.ComputeImageCapabilitySchema;
import com.oracle.bmc.core.model.ComputeImageCapabilitySchemaSummary;
import com.oracle.bmc.core.model.ConsoleHistory;
import com.oracle.bmc.core.model.DedicatedVmHost;
import com.oracle.bmc.core.model.DedicatedVmHostInstanceShapeSummary;
import com.oracle.bmc.core.model.DedicatedVmHostInstanceSummary;
import com.oracle.bmc.core.model.DedicatedVmHostShapeSummary;
import com.oracle.bmc.core.model.DedicatedVmHostSummary;
import com.oracle.bmc.core.model.Device;
import com.oracle.bmc.core.model.Image;
import com.oracle.bmc.core.model.ImageShapeCompatibilityEntry;
import com.oracle.bmc.core.model.ImageShapeCompatibilitySummary;
import com.oracle.bmc.core.model.Instance;
import com.oracle.bmc.core.model.InstanceConsoleConnection;
import com.oracle.bmc.core.model.InstanceCredentials;
import com.oracle.bmc.core.model.InstanceMaintenanceReboot;
import com.oracle.bmc.core.model.MeasuredBootReport;
import com.oracle.bmc.core.model.Shape;
import com.oracle.bmc.core.model.VnicAttachment;
import com.oracle.bmc.core.model.VolumeAttachment;
import com.oracle.bmc.core.requests.AcceptShieldedIntegrityPolicyRequest;
import com.oracle.bmc.core.requests.AddImageShapeCompatibilityEntryRequest;
import com.oracle.bmc.core.requests.AttachBootVolumeRequest;
import com.oracle.bmc.core.requests.AttachVnicRequest;
import com.oracle.bmc.core.requests.AttachVolumeRequest;
import com.oracle.bmc.core.requests.CaptureConsoleHistoryRequest;
import com.oracle.bmc.core.requests.ChangeComputeCapacityReservationCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeComputeClusterCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeComputeImageCapabilitySchemaCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeDedicatedVmHostCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeImageCompartmentRequest;
import com.oracle.bmc.core.requests.ChangeInstanceCompartmentRequest;
import com.oracle.bmc.core.requests.CreateAppCatalogSubscriptionRequest;
import com.oracle.bmc.core.requests.CreateComputeCapacityReportRequest;
import com.oracle.bmc.core.requests.CreateComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.CreateComputeClusterRequest;
import com.oracle.bmc.core.requests.CreateComputeImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.CreateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.CreateImageRequest;
import com.oracle.bmc.core.requests.CreateInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.DeleteAppCatalogSubscriptionRequest;
import com.oracle.bmc.core.requests.DeleteComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.DeleteComputeClusterRequest;
import com.oracle.bmc.core.requests.DeleteComputeImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.DeleteConsoleHistoryRequest;
import com.oracle.bmc.core.requests.DeleteDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.DeleteImageRequest;
import com.oracle.bmc.core.requests.DeleteInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.DetachBootVolumeRequest;
import com.oracle.bmc.core.requests.DetachVnicRequest;
import com.oracle.bmc.core.requests.DetachVolumeRequest;
import com.oracle.bmc.core.requests.ExportImageRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingAgreementsRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingRequest;
import com.oracle.bmc.core.requests.GetAppCatalogListingResourceVersionRequest;
import com.oracle.bmc.core.requests.GetBootVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.GetComputeClusterRequest;
import com.oracle.bmc.core.requests.GetComputeGlobalImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.GetComputeGlobalImageCapabilitySchemaVersionRequest;
import com.oracle.bmc.core.requests.GetComputeImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryContentRequest;
import com.oracle.bmc.core.requests.GetConsoleHistoryRequest;
import com.oracle.bmc.core.requests.GetDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.GetImageRequest;
import com.oracle.bmc.core.requests.GetImageShapeCompatibilityEntryRequest;
import com.oracle.bmc.core.requests.GetInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.GetInstanceMaintenanceRebootRequest;
import com.oracle.bmc.core.requests.GetInstanceRequest;
import com.oracle.bmc.core.requests.GetMeasuredBootReportRequest;
import com.oracle.bmc.core.requests.GetVnicAttachmentRequest;
import com.oracle.bmc.core.requests.GetVolumeAttachmentRequest;
import com.oracle.bmc.core.requests.GetWindowsInstanceInitialCredentialsRequest;
import com.oracle.bmc.core.requests.InstanceActionRequest;
import com.oracle.bmc.core.requests.LaunchInstanceRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingResourceVersionsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogListingsRequest;
import com.oracle.bmc.core.requests.ListAppCatalogSubscriptionsRequest;
import com.oracle.bmc.core.requests.ListBootVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityReservationInstanceShapesRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityReservationInstancesRequest;
import com.oracle.bmc.core.requests.ListComputeCapacityReservationsRequest;
import com.oracle.bmc.core.requests.ListComputeClustersRequest;
import com.oracle.bmc.core.requests.ListComputeGlobalImageCapabilitySchemaVersionsRequest;
import com.oracle.bmc.core.requests.ListComputeGlobalImageCapabilitySchemasRequest;
import com.oracle.bmc.core.requests.ListComputeImageCapabilitySchemasRequest;
import com.oracle.bmc.core.requests.ListConsoleHistoriesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstanceShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostInstancesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostShapesRequest;
import com.oracle.bmc.core.requests.ListDedicatedVmHostsRequest;
import com.oracle.bmc.core.requests.ListImageShapeCompatibilityEntriesRequest;
import com.oracle.bmc.core.requests.ListImagesRequest;
import com.oracle.bmc.core.requests.ListInstanceConsoleConnectionsRequest;
import com.oracle.bmc.core.requests.ListInstanceDevicesRequest;
import com.oracle.bmc.core.requests.ListInstancesRequest;
import com.oracle.bmc.core.requests.ListShapesRequest;
import com.oracle.bmc.core.requests.ListVnicAttachmentsRequest;
import com.oracle.bmc.core.requests.ListVolumeAttachmentsRequest;
import com.oracle.bmc.core.requests.RemoveImageShapeCompatibilityEntryRequest;
import com.oracle.bmc.core.requests.TerminateInstanceRequest;
import com.oracle.bmc.core.requests.UpdateComputeCapacityReservationRequest;
import com.oracle.bmc.core.requests.UpdateComputeClusterRequest;
import com.oracle.bmc.core.requests.UpdateComputeImageCapabilitySchemaRequest;
import com.oracle.bmc.core.requests.UpdateConsoleHistoryRequest;
import com.oracle.bmc.core.requests.UpdateDedicatedVmHostRequest;
import com.oracle.bmc.core.requests.UpdateImageRequest;
import com.oracle.bmc.core.requests.UpdateInstanceConsoleConnectionRequest;
import com.oracle.bmc.core.requests.UpdateInstanceRequest;
import com.oracle.bmc.core.requests.UpdateVolumeAttachmentRequest;
import com.oracle.bmc.core.responses.AcceptShieldedIntegrityPolicyResponse;
import com.oracle.bmc.core.responses.AddImageShapeCompatibilityEntryResponse;
import com.oracle.bmc.core.responses.AttachBootVolumeResponse;
import com.oracle.bmc.core.responses.AttachVnicResponse;
import com.oracle.bmc.core.responses.AttachVolumeResponse;
import com.oracle.bmc.core.responses.CaptureConsoleHistoryResponse;
import com.oracle.bmc.core.responses.ChangeComputeCapacityReservationCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeComputeClusterCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeComputeImageCapabilitySchemaCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeDedicatedVmHostCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeImageCompartmentResponse;
import com.oracle.bmc.core.responses.ChangeInstanceCompartmentResponse;
import com.oracle.bmc.core.responses.CreateAppCatalogSubscriptionResponse;
import com.oracle.bmc.core.responses.CreateComputeCapacityReportResponse;
import com.oracle.bmc.core.responses.CreateComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.CreateComputeClusterResponse;
import com.oracle.bmc.core.responses.CreateComputeImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.CreateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.CreateImageResponse;
import com.oracle.bmc.core.responses.CreateInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.DeleteAppCatalogSubscriptionResponse;
import com.oracle.bmc.core.responses.DeleteComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.DeleteComputeClusterResponse;
import com.oracle.bmc.core.responses.DeleteComputeImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.DeleteConsoleHistoryResponse;
import com.oracle.bmc.core.responses.DeleteDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.DeleteImageResponse;
import com.oracle.bmc.core.responses.DeleteInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.DetachBootVolumeResponse;
import com.oracle.bmc.core.responses.DetachVnicResponse;
import com.oracle.bmc.core.responses.DetachVolumeResponse;
import com.oracle.bmc.core.responses.ExportImageResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingAgreementsResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingResourceVersionResponse;
import com.oracle.bmc.core.responses.GetAppCatalogListingResponse;
import com.oracle.bmc.core.responses.GetBootVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.GetComputeClusterResponse;
import com.oracle.bmc.core.responses.GetComputeGlobalImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.GetComputeGlobalImageCapabilitySchemaVersionResponse;
import com.oracle.bmc.core.responses.GetComputeImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryContentResponse;
import com.oracle.bmc.core.responses.GetConsoleHistoryResponse;
import com.oracle.bmc.core.responses.GetDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.GetImageResponse;
import com.oracle.bmc.core.responses.GetImageShapeCompatibilityEntryResponse;
import com.oracle.bmc.core.responses.GetInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.GetInstanceMaintenanceRebootResponse;
import com.oracle.bmc.core.responses.GetInstanceResponse;
import com.oracle.bmc.core.responses.GetMeasuredBootReportResponse;
import com.oracle.bmc.core.responses.GetVnicAttachmentResponse;
import com.oracle.bmc.core.responses.GetVolumeAttachmentResponse;
import com.oracle.bmc.core.responses.GetWindowsInstanceInitialCredentialsResponse;
import com.oracle.bmc.core.responses.InstanceActionResponse;
import com.oracle.bmc.core.responses.LaunchInstanceResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingResourceVersionsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogListingsResponse;
import com.oracle.bmc.core.responses.ListAppCatalogSubscriptionsResponse;
import com.oracle.bmc.core.responses.ListBootVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityReservationInstanceShapesResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityReservationInstancesResponse;
import com.oracle.bmc.core.responses.ListComputeCapacityReservationsResponse;
import com.oracle.bmc.core.responses.ListComputeClustersResponse;
import com.oracle.bmc.core.responses.ListComputeGlobalImageCapabilitySchemaVersionsResponse;
import com.oracle.bmc.core.responses.ListComputeGlobalImageCapabilitySchemasResponse;
import com.oracle.bmc.core.responses.ListComputeImageCapabilitySchemasResponse;
import com.oracle.bmc.core.responses.ListConsoleHistoriesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstanceShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostInstancesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostShapesResponse;
import com.oracle.bmc.core.responses.ListDedicatedVmHostsResponse;
import com.oracle.bmc.core.responses.ListImageShapeCompatibilityEntriesResponse;
import com.oracle.bmc.core.responses.ListImagesResponse;
import com.oracle.bmc.core.responses.ListInstanceConsoleConnectionsResponse;
import com.oracle.bmc.core.responses.ListInstanceDevicesResponse;
import com.oracle.bmc.core.responses.ListInstancesResponse;
import com.oracle.bmc.core.responses.ListShapesResponse;
import com.oracle.bmc.core.responses.ListVnicAttachmentsResponse;
import com.oracle.bmc.core.responses.ListVolumeAttachmentsResponse;
import com.oracle.bmc.core.responses.RemoveImageShapeCompatibilityEntryResponse;
import com.oracle.bmc.core.responses.TerminateInstanceResponse;
import com.oracle.bmc.core.responses.UpdateComputeCapacityReservationResponse;
import com.oracle.bmc.core.responses.UpdateComputeClusterResponse;
import com.oracle.bmc.core.responses.UpdateComputeImageCapabilitySchemaResponse;
import com.oracle.bmc.core.responses.UpdateConsoleHistoryResponse;
import com.oracle.bmc.core.responses.UpdateDedicatedVmHostResponse;
import com.oracle.bmc.core.responses.UpdateImageResponse;
import com.oracle.bmc.core.responses.UpdateInstanceConsoleConnectionResponse;
import com.oracle.bmc.core.responses.UpdateInstanceResponse;
import com.oracle.bmc.core.responses.UpdateVolumeAttachmentResponse;
import com.oracle.bmc.http.ClientConfigurator;
import com.oracle.bmc.http.client.Method;
import com.oracle.bmc.http.internal.BaseAsyncClient;
import com.oracle.bmc.http.internal.BmcEnum;
import com.oracle.bmc.http.signing.RequestSignerFactory;
import com.oracle.bmc.http.signing.SigningStrategy;
import com.oracle.bmc.http.signing.internal.DefaultRequestSignerFactory;
import com.oracle.bmc.internal.Alloy;
import com.oracle.bmc.responses.AsyncHandler;
import com.oracle.bmc.util.internal.Validate;
import jakarta.annotation.Nonnull;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Future;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ComputeAsyncClient
extends BaseAsyncClient
implements ComputeAsync {
    public static final Service SERVICE = Services.serviceBuilder().serviceName("COMPUTE").serviceEndpointPrefix("iaas").serviceEndpointTemplate("https://iaas.{region}.{secondLevelDomain}").build();
    private static final Logger LOG = LoggerFactory.getLogger(ComputeAsyncClient.class);

    ComputeAsyncClient(ClientBuilderBase<?, ?> builder, AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
        super(builder, authenticationDetailsProvider);
    }

    public static Builder builder() {
        return new Builder(SERVICE);
    }

    @Override
    public void setRegion(Region region) {
        super.setRegion(region);
    }

    @Override
    public void setRegion(String regionId) {
        super.setRegion(regionId);
    }

    @Override
    public Future<AcceptShieldedIntegrityPolicyResponse> acceptShieldedIntegrityPolicy(AcceptShieldedIntegrityPolicyRequest request, AsyncHandler<AcceptShieldedIntegrityPolicyRequest, AcceptShieldedIntegrityPolicyResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, AcceptShieldedIntegrityPolicyResponse::builder).logger(LOG, "acceptShieldedIntegrityPolicy").serviceDetails("Compute", "AcceptShieldedIntegrityPolicy", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/MeasuredBootReport/AcceptShieldedIntegrityPolicy").method(Method.POST).requestBuilder(AcceptShieldedIntegrityPolicyRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("actions").appendPathParam("acceptShieldedIntegrityPolicy").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-retry-token", request.getOpcRetryToken()).handleResponseHeaderString("opc-request-id", AcceptShieldedIntegrityPolicyResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AddImageShapeCompatibilityEntryResponse> addImageShapeCompatibilityEntry(AddImageShapeCompatibilityEntryRequest request, AsyncHandler<AddImageShapeCompatibilityEntryRequest, AddImageShapeCompatibilityEntryResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getShapeName(), (String)"shapeName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, AddImageShapeCompatibilityEntryResponse::builder).logger(LOG, "addImageShapeCompatibilityEntry").serviceDetails("Compute", "AddImageShapeCompatibilityEntry", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ImageShapeCompatibilityEntry/AddImageShapeCompatibilityEntry").method(Method.PUT).requestBuilder(AddImageShapeCompatibilityEntryRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("shapes").appendPathParam(request.getShapeName()).accept(new String[]{"application/json"}).hasBody().handleBody(ImageShapeCompatibilityEntry.class, AddImageShapeCompatibilityEntryResponse.Builder::imageShapeCompatibilityEntry).handleResponseHeaderString("opc-request-id", AddImageShapeCompatibilityEntryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AttachBootVolumeResponse> attachBootVolume(AttachBootVolumeRequest request, AsyncHandler<AttachBootVolumeRequest, AttachBootVolumeResponse> handler) {
        Objects.requireNonNull(request.getAttachBootVolumeDetails(), "attachBootVolumeDetails is required");
        return this.clientCall(request, AttachBootVolumeResponse::builder).logger(LOG, "attachBootVolume").serviceDetails("Compute", "AttachBootVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeAttachment/AttachBootVolume").method(Method.POST).requestBuilder(AttachBootVolumeRequest::builder).basePath("/20160918").appendPathParam("bootVolumeAttachments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(BootVolumeAttachment.class, AttachBootVolumeResponse.Builder::bootVolumeAttachment).handleResponseHeaderString("etag", AttachBootVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AttachBootVolumeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AttachVnicResponse> attachVnic(AttachVnicRequest request, AsyncHandler<AttachVnicRequest, AttachVnicResponse> handler) {
        Objects.requireNonNull(request.getAttachVnicDetails(), "attachVnicDetails is required");
        return this.clientCall(request, AttachVnicResponse::builder).logger(LOG, "attachVnic").serviceDetails("Compute", "AttachVnic", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VnicAttachment/AttachVnic").method(Method.POST).requestBuilder(AttachVnicRequest::builder).basePath("/20160918").appendPathParam("vnicAttachments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(VnicAttachment.class, AttachVnicResponse.Builder::vnicAttachment).handleResponseHeaderString("etag", AttachVnicResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AttachVnicResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<AttachVolumeResponse> attachVolume(AttachVolumeRequest request, AsyncHandler<AttachVolumeRequest, AttachVolumeResponse> handler) {
        Objects.requireNonNull(request.getAttachVolumeDetails(), "attachVolumeDetails is required");
        return this.clientCall(request, AttachVolumeResponse::builder).logger(LOG, "attachVolume").serviceDetails("Compute", "AttachVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/AttachVolume").method(Method.POST).requestBuilder(AttachVolumeRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(VolumeAttachment.class, AttachVolumeResponse.Builder::volumeAttachment).handleResponseHeaderString("etag", AttachVolumeResponse.Builder::etag).handleResponseHeaderString("opc-request-id", AttachVolumeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CaptureConsoleHistoryResponse> captureConsoleHistory(CaptureConsoleHistoryRequest request, AsyncHandler<CaptureConsoleHistoryRequest, CaptureConsoleHistoryResponse> handler) {
        Objects.requireNonNull(request.getCaptureConsoleHistoryDetails(), "captureConsoleHistoryDetails is required");
        return this.clientCall(request, CaptureConsoleHistoryResponse::builder).logger(LOG, "captureConsoleHistory").serviceDetails("Compute", "CaptureConsoleHistory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/CaptureConsoleHistory").method(Method.POST).requestBuilder(CaptureConsoleHistoryRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ConsoleHistory.class, CaptureConsoleHistoryResponse.Builder::consoleHistory).handleResponseHeaderString("etag", CaptureConsoleHistoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CaptureConsoleHistoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeComputeCapacityReservationCompartmentResponse> changeComputeCapacityReservationCompartment(ChangeComputeCapacityReservationCompartmentRequest request, AsyncHandler<ChangeComputeCapacityReservationCompartmentRequest, ChangeComputeCapacityReservationCompartmentResponse> handler) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeCapacityReservationCompartmentDetails(), "changeComputeCapacityReservationCompartmentDetails is required");
        return this.clientCall(request, ChangeComputeCapacityReservationCompartmentResponse::builder).logger(LOG, "changeComputeCapacityReservationCompartment").serviceDetails("Compute", "ChangeComputeCapacityReservationCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/ChangeComputeCapacityReservationCompartment").method(Method.POST).requestBuilder(ChangeComputeCapacityReservationCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeCapacityReservationCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeComputeCapacityReservationCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeComputeClusterCompartmentResponse> changeComputeClusterCompartment(ChangeComputeClusterCompartmentRequest request, AsyncHandler<ChangeComputeClusterCompartmentRequest, ChangeComputeClusterCompartmentResponse> handler) {
        Validate.notBlank((String)request.getComputeClusterId(), (String)"computeClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeClusterCompartmentDetails(), "changeComputeClusterCompartmentDetails is required");
        return this.clientCall(request, ChangeComputeClusterCompartmentResponse::builder).logger(LOG, "changeComputeClusterCompartment").serviceDetails("Compute", "ChangeComputeClusterCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/ChangeComputeClusterCompartment").method(Method.POST).requestBuilder(ChangeComputeClusterCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendPathParam(request.getComputeClusterId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeClusterCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeComputeImageCapabilitySchemaCompartmentResponse> changeComputeImageCapabilitySchemaCompartment(ChangeComputeImageCapabilitySchemaCompartmentRequest request, AsyncHandler<ChangeComputeImageCapabilitySchemaCompartmentRequest, ChangeComputeImageCapabilitySchemaCompartmentResponse> handler) {
        Validate.notBlank((String)request.getComputeImageCapabilitySchemaId(), (String)"computeImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeComputeImageCapabilitySchemaCompartmentDetails(), "changeComputeImageCapabilitySchemaCompartmentDetails is required");
        return this.clientCall(request, ChangeComputeImageCapabilitySchemaCompartmentResponse::builder).logger(LOG, "changeComputeImageCapabilitySchemaCompartment").serviceDetails("Compute", "ChangeComputeImageCapabilitySchemaCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/ChangeComputeImageCapabilitySchemaCompartment").method(Method.POST).requestBuilder(ChangeComputeImageCapabilitySchemaCompartmentRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendPathParam(request.getComputeImageCapabilitySchemaId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("opc-request-id", ChangeComputeImageCapabilitySchemaCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeDedicatedVmHostCompartmentResponse> changeDedicatedVmHostCompartment(ChangeDedicatedVmHostCompartmentRequest request, AsyncHandler<ChangeDedicatedVmHostCompartmentRequest, ChangeDedicatedVmHostCompartmentResponse> handler) {
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeDedicatedVmHostCompartmentDetails(), "changeDedicatedVmHostCompartmentDetails is required");
        return this.clientCall(request, ChangeDedicatedVmHostCompartmentResponse::builder).logger(LOG, "changeDedicatedVmHostCompartment").serviceDetails("Compute", "ChangeDedicatedVmHostCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/ChangeDedicatedVmHostCompartment").method(Method.POST).requestBuilder(ChangeDedicatedVmHostCompartmentRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeDedicatedVmHostCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeDedicatedVmHostCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeDedicatedVmHostCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeImageCompartmentResponse> changeImageCompartment(ChangeImageCompartmentRequest request, AsyncHandler<ChangeImageCompartmentRequest, ChangeImageCompartmentResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeImageCompartmentDetails(), "changeImageCompartmentDetails is required");
        return this.clientCall(request, ChangeImageCompartmentResponse::builder).logger(LOG, "changeImageCompartment").serviceDetails("Compute", "ChangeImageCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/ChangeImageCompartment").method(Method.POST).requestBuilder(ChangeImageCompartmentRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeImageCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeImageCompartmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ChangeInstanceCompartmentResponse> changeInstanceCompartment(ChangeInstanceCompartmentRequest request, AsyncHandler<ChangeInstanceCompartmentRequest, ChangeInstanceCompartmentResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getChangeInstanceCompartmentDetails(), "changeInstanceCompartmentDetails is required");
        return this.clientCall(request, ChangeInstanceCompartmentResponse::builder).logger(LOG, "changeInstanceCompartment").serviceDetails("Compute", "ChangeInstanceCompartment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/ChangeInstanceCompartment").method(Method.POST).requestBuilder(ChangeInstanceCompartmentRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("actions").appendPathParam("changeCompartment").accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleResponseHeaderString("etag", ChangeInstanceCompartmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ChangeInstanceCompartmentResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ChangeInstanceCompartmentResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateAppCatalogSubscriptionResponse> createAppCatalogSubscription(CreateAppCatalogSubscriptionRequest request, AsyncHandler<CreateAppCatalogSubscriptionRequest, CreateAppCatalogSubscriptionResponse> handler) {
        Objects.requireNonNull(request.getCreateAppCatalogSubscriptionDetails(), "createAppCatalogSubscriptionDetails is required");
        return this.clientCall(request, CreateAppCatalogSubscriptionResponse::builder).logger(LOG, "createAppCatalogSubscription").serviceDetails("Compute", "CreateAppCatalogSubscription", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogSubscription/CreateAppCatalogSubscription").method(Method.POST).requestBuilder(CreateAppCatalogSubscriptionRequest::builder).basePath("/20160918").appendPathParam("appCatalogSubscriptions").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(AppCatalogSubscription.class, CreateAppCatalogSubscriptionResponse.Builder::appCatalogSubscription).handleResponseHeaderString("etag", CreateAppCatalogSubscriptionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateAppCatalogSubscriptionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateComputeCapacityReportResponse> createComputeCapacityReport(CreateComputeCapacityReportRequest request, AsyncHandler<CreateComputeCapacityReportRequest, CreateComputeCapacityReportResponse> handler) {
        Objects.requireNonNull(request.getCreateComputeCapacityReportDetails(), "createComputeCapacityReportDetails is required");
        return this.clientCall(request, CreateComputeCapacityReportResponse::builder).logger(LOG, "createComputeCapacityReport").serviceDetails("Compute", "CreateComputeCapacityReport", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReport/CreateComputeCapacityReport").method(Method.POST).requestBuilder(CreateComputeCapacityReportRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReports").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ComputeCapacityReport.class, CreateComputeCapacityReportResponse.Builder::computeCapacityReport).handleResponseHeaderString("opc-request-id", CreateComputeCapacityReportResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateComputeCapacityReservationResponse> createComputeCapacityReservation(CreateComputeCapacityReservationRequest request, AsyncHandler<CreateComputeCapacityReservationRequest, CreateComputeCapacityReservationResponse> handler) {
        Objects.requireNonNull(request.getCreateComputeCapacityReservationDetails(), "createComputeCapacityReservationDetails is required");
        return this.clientCall(request, CreateComputeCapacityReservationResponse::builder).logger(LOG, "createComputeCapacityReservation").serviceDetails("Compute", "CreateComputeCapacityReservation", "").method(Method.POST).requestBuilder(CreateComputeCapacityReservationRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ComputeCapacityReservation.class, CreateComputeCapacityReservationResponse.Builder::computeCapacityReservation).handleResponseHeaderString("etag", CreateComputeCapacityReservationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateComputeCapacityReservationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateComputeCapacityReservationResponse.Builder::opcWorkRequestId).handleResponseHeaderString("location", CreateComputeCapacityReservationResponse.Builder::location).callAsync(handler);
    }

    @Override
    public Future<CreateComputeClusterResponse> createComputeCluster(CreateComputeClusterRequest request, AsyncHandler<CreateComputeClusterRequest, CreateComputeClusterResponse> handler) {
        Objects.requireNonNull(request.getCreateComputeClusterDetails(), "createComputeClusterDetails is required");
        return this.clientCall(request, CreateComputeClusterResponse::builder).logger(LOG, "createComputeCluster").serviceDetails("Compute", "CreateComputeCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/CreateComputeCluster").method(Method.POST).requestBuilder(CreateComputeClusterRequest::builder).basePath("/20160918").appendPathParam("computeClusters").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleBody(ComputeCluster.class, CreateComputeClusterResponse.Builder::computeCluster).handleResponseHeaderString("etag", CreateComputeClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateComputeClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateComputeImageCapabilitySchemaResponse> createComputeImageCapabilitySchema(CreateComputeImageCapabilitySchemaRequest request, AsyncHandler<CreateComputeImageCapabilitySchemaRequest, CreateComputeImageCapabilitySchemaResponse> handler) {
        Objects.requireNonNull(request.getCreateComputeImageCapabilitySchemaDetails(), "createComputeImageCapabilitySchemaDetails is required");
        return this.clientCall(request, CreateComputeImageCapabilitySchemaResponse::builder).logger(LOG, "createComputeImageCapabilitySchema").serviceDetails("Compute", "CreateComputeImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/CreateComputeImageCapabilitySchema").method(Method.POST).requestBuilder(CreateComputeImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(ComputeImageCapabilitySchema.class, CreateComputeImageCapabilitySchemaResponse.Builder::computeImageCapabilitySchema).handleResponseHeaderString("etag", CreateComputeImageCapabilitySchemaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateComputeImageCapabilitySchemaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateDedicatedVmHostResponse> createDedicatedVmHost(CreateDedicatedVmHostRequest request, AsyncHandler<CreateDedicatedVmHostRequest, CreateDedicatedVmHostResponse> handler) {
        Objects.requireNonNull(request.getCreateDedicatedVmHostDetails(), "createDedicatedVmHostDetails is required");
        return this.clientCall(request, CreateDedicatedVmHostResponse::builder).logger(LOG, "createDedicatedVmHost").serviceDetails("Compute", "CreateDedicatedVmHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/CreateDedicatedVmHost").method(Method.POST).requestBuilder(CreateDedicatedVmHostRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DedicatedVmHost.class, CreateDedicatedVmHostResponse.Builder::dedicatedVmHost).handleResponseHeaderString("etag", CreateDedicatedVmHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateDedicatedVmHostResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateDedicatedVmHostResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateImageResponse> createImage(CreateImageRequest request, AsyncHandler<CreateImageRequest, CreateImageResponse> handler) {
        Objects.requireNonNull(request.getCreateImageDetails(), "createImageDetails is required");
        return this.clientCall(request, CreateImageResponse::builder).logger(LOG, "createImage").serviceDetails("Compute", "CreateImage", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/CreateImage").method(Method.POST).requestBuilder(CreateImageRequest::builder).basePath("/20160918").appendPathParam("images").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Image.class, CreateImageResponse.Builder::image).handleResponseHeaderString("etag", CreateImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateImageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", CreateImageResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<CreateInstanceConsoleConnectionResponse> createInstanceConsoleConnection(CreateInstanceConsoleConnectionRequest request, AsyncHandler<CreateInstanceConsoleConnectionRequest, CreateInstanceConsoleConnectionResponse> handler) {
        Objects.requireNonNull(request.getCreateInstanceConsoleConnectionDetails(), "createInstanceConsoleConnectionDetails is required");
        return this.clientCall(request, CreateInstanceConsoleConnectionResponse::builder).logger(LOG, "createInstanceConsoleConnection").serviceDetails("Compute", "CreateInstanceConsoleConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/CreateInstanceConsoleConnection").method(Method.POST).requestBuilder(CreateInstanceConsoleConnectionRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(InstanceConsoleConnection.class, CreateInstanceConsoleConnectionResponse.Builder::instanceConsoleConnection).handleResponseHeaderString("etag", CreateInstanceConsoleConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", CreateInstanceConsoleConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteAppCatalogSubscriptionResponse> deleteAppCatalogSubscription(DeleteAppCatalogSubscriptionRequest request, AsyncHandler<DeleteAppCatalogSubscriptionRequest, DeleteAppCatalogSubscriptionResponse> handler) {
        Objects.requireNonNull(request.getListingId(), "listingId is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Objects.requireNonNull(request.getResourceVersion(), "resourceVersion is required");
        return this.clientCall(request, DeleteAppCatalogSubscriptionResponse::builder).logger(LOG, "deleteAppCatalogSubscription").serviceDetails("Compute", "DeleteAppCatalogSubscription", "").method(Method.DELETE).requestBuilder(DeleteAppCatalogSubscriptionRequest::builder).basePath("/20160918").appendPathParam("appCatalogSubscriptions").appendQueryParam("listingId", (Object)request.getListingId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("resourceVersion", (Object)request.getResourceVersion()).accept(new String[]{"application/json"}).handleResponseHeaderString("opc-request-id", DeleteAppCatalogSubscriptionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteComputeCapacityReservationResponse> deleteComputeCapacityReservation(DeleteComputeCapacityReservationRequest request, AsyncHandler<DeleteComputeCapacityReservationRequest, DeleteComputeCapacityReservationResponse> handler) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteComputeCapacityReservationResponse::builder).logger(LOG, "deleteComputeCapacityReservation").serviceDetails("Compute", "DeleteComputeCapacityReservation", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/DeleteComputeCapacityReservation").method(Method.DELETE).requestBuilder(DeleteComputeCapacityReservationRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteComputeCapacityReservationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteComputeCapacityReservationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteComputeClusterResponse> deleteComputeCluster(DeleteComputeClusterRequest request, AsyncHandler<DeleteComputeClusterRequest, DeleteComputeClusterResponse> handler) {
        Validate.notBlank((String)request.getComputeClusterId(), (String)"computeClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteComputeClusterResponse::builder).logger(LOG, "deleteComputeCluster").serviceDetails("Compute", "DeleteComputeCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/DeleteComputeCluster").method(Method.DELETE).requestBuilder(DeleteComputeClusterRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendPathParam(request.getComputeClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteComputeClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteComputeImageCapabilitySchemaResponse> deleteComputeImageCapabilitySchema(DeleteComputeImageCapabilitySchemaRequest request, AsyncHandler<DeleteComputeImageCapabilitySchemaRequest, DeleteComputeImageCapabilitySchemaResponse> handler) {
        Validate.notBlank((String)request.getComputeImageCapabilitySchemaId(), (String)"computeImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteComputeImageCapabilitySchemaResponse::builder).logger(LOG, "deleteComputeImageCapabilitySchema").serviceDetails("Compute", "DeleteComputeImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/DeleteComputeImageCapabilitySchema").method(Method.DELETE).requestBuilder(DeleteComputeImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendPathParam(request.getComputeImageCapabilitySchemaId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteComputeImageCapabilitySchemaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteConsoleHistoryResponse> deleteConsoleHistory(DeleteConsoleHistoryRequest request, AsyncHandler<DeleteConsoleHistoryRequest, DeleteConsoleHistoryResponse> handler) {
        Validate.notBlank((String)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteConsoleHistoryResponse::builder).logger(LOG, "deleteConsoleHistory").serviceDetails("Compute", "DeleteConsoleHistory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/DeleteConsoleHistory").method(Method.DELETE).requestBuilder(DeleteConsoleHistoryRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendPathParam(request.getInstanceConsoleHistoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteConsoleHistoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteDedicatedVmHostResponse> deleteDedicatedVmHost(DeleteDedicatedVmHostRequest request, AsyncHandler<DeleteDedicatedVmHostRequest, DeleteDedicatedVmHostResponse> handler) {
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteDedicatedVmHostResponse::builder).logger(LOG, "deleteDedicatedVmHost").serviceDetails("Compute", "DeleteDedicatedVmHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/DeleteDedicatedVmHost").method(Method.DELETE).requestBuilder(DeleteDedicatedVmHostRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleResponseHeaderString("opc-request-id", DeleteDedicatedVmHostResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", DeleteDedicatedVmHostResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteImageResponse> deleteImage(DeleteImageRequest request, AsyncHandler<DeleteImageRequest, DeleteImageResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteImageResponse::builder).logger(LOG, "deleteImage").serviceDetails("Compute", "DeleteImage", "").method(Method.DELETE).requestBuilder(DeleteImageRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteImageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DeleteInstanceConsoleConnectionResponse> deleteInstanceConsoleConnection(DeleteInstanceConsoleConnectionRequest request, AsyncHandler<DeleteInstanceConsoleConnectionRequest, DeleteInstanceConsoleConnectionResponse> handler) {
        Validate.notBlank((String)request.getInstanceConsoleConnectionId(), (String)"instanceConsoleConnectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DeleteInstanceConsoleConnectionResponse::builder).logger(LOG, "deleteInstanceConsoleConnection").serviceDetails("Compute", "DeleteInstanceConsoleConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/DeleteInstanceConsoleConnection").method(Method.DELETE).requestBuilder(DeleteInstanceConsoleConnectionRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").appendPathParam(request.getInstanceConsoleConnectionId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DeleteInstanceConsoleConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachBootVolumeResponse> detachBootVolume(DetachBootVolumeRequest request, AsyncHandler<DetachBootVolumeRequest, DetachBootVolumeResponse> handler) {
        Validate.notBlank((String)request.getBootVolumeAttachmentId(), (String)"bootVolumeAttachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DetachBootVolumeResponse::builder).logger(LOG, "detachBootVolume").serviceDetails("Compute", "DetachBootVolume", "").method(Method.DELETE).requestBuilder(DetachBootVolumeRequest::builder).basePath("/20160918").appendPathParam("bootVolumeAttachments").appendPathParam(request.getBootVolumeAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DetachBootVolumeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachVnicResponse> detachVnic(DetachVnicRequest request, AsyncHandler<DetachVnicRequest, DetachVnicResponse> handler) {
        Validate.notBlank((String)request.getVnicAttachmentId(), (String)"vnicAttachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DetachVnicResponse::builder).logger(LOG, "detachVnic").serviceDetails("Compute", "DetachVnic", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VnicAttachment/DetachVnic").method(Method.DELETE).requestBuilder(DetachVnicRequest::builder).basePath("/20160918").appendPathParam("vnicAttachments").appendPathParam(request.getVnicAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DetachVnicResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<DetachVolumeResponse> detachVolume(DetachVolumeRequest request, AsyncHandler<DetachVolumeRequest, DetachVolumeResponse> handler) {
        Validate.notBlank((String)request.getVolumeAttachmentId(), (String)"volumeAttachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, DetachVolumeResponse::builder).logger(LOG, "detachVolume").serviceDetails("Compute", "DetachVolume", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/DetachVolume").method(Method.DELETE).requestBuilder(DetachVolumeRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").appendPathParam(request.getVolumeAttachmentId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", DetachVolumeResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ExportImageResponse> exportImage(ExportImageRequest request, AsyncHandler<ExportImageRequest, ExportImageResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getExportImageDetails(), "exportImageDetails is required");
        return this.clientCall(request, ExportImageResponse::builder).logger(LOG, "exportImage").serviceDetails("Compute", "ExportImage", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/ExportImage").method(Method.POST).requestBuilder(ExportImageRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("actions").appendPathParam("export").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Image.class, ExportImageResponse.Builder::image).handleResponseHeaderString("etag", ExportImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", ExportImageResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", ExportImageResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAppCatalogListingResponse> getAppCatalogListing(GetAppCatalogListingRequest request, AsyncHandler<GetAppCatalogListingRequest, GetAppCatalogListingResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAppCatalogListingResponse::builder).logger(LOG, "getAppCatalogListing").serviceDetails("Compute", "GetAppCatalogListing", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListing/GetAppCatalogListing").method(Method.GET).requestBuilder(GetAppCatalogListingRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendPathParam(request.getListingId()).accept(new String[]{"application/json"}).handleBody(AppCatalogListing.class, GetAppCatalogListingResponse.Builder::appCatalogListing).handleResponseHeaderString("etag", GetAppCatalogListingResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAppCatalogListingResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAppCatalogListingAgreementsResponse> getAppCatalogListingAgreements(GetAppCatalogListingAgreementsRequest request, AsyncHandler<GetAppCatalogListingAgreementsRequest, GetAppCatalogListingAgreementsResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResourceVersion(), (String)"resourceVersion must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAppCatalogListingAgreementsResponse::builder).logger(LOG, "getAppCatalogListingAgreements").serviceDetails("Compute", "GetAppCatalogListingAgreements", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListingResourceVersionAgreements/GetAppCatalogListingAgreements").method(Method.GET).requestBuilder(GetAppCatalogListingAgreementsRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendPathParam(request.getListingId()).appendPathParam("resourceVersions").appendPathParam(request.getResourceVersion()).appendPathParam("agreements").accept(new String[]{"application/json"}).handleBody(AppCatalogListingResourceVersionAgreements.class, GetAppCatalogListingAgreementsResponse.Builder::appCatalogListingResourceVersionAgreements).handleResponseHeaderString("etag", GetAppCatalogListingAgreementsResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAppCatalogListingAgreementsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetAppCatalogListingResourceVersionResponse> getAppCatalogListingResourceVersion(GetAppCatalogListingResourceVersionRequest request, AsyncHandler<GetAppCatalogListingResourceVersionRequest, GetAppCatalogListingResourceVersionResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getResourceVersion(), (String)"resourceVersion must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetAppCatalogListingResourceVersionResponse::builder).logger(LOG, "getAppCatalogListingResourceVersion").serviceDetails("Compute", "GetAppCatalogListingResourceVersion", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListingResourceVersion/GetAppCatalogListingResourceVersion").method(Method.GET).requestBuilder(GetAppCatalogListingResourceVersionRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendPathParam(request.getListingId()).appendPathParam("resourceVersions").appendPathParam(request.getResourceVersion()).accept(new String[]{"application/json"}).handleBody(AppCatalogListingResourceVersion.class, GetAppCatalogListingResourceVersionResponse.Builder::appCatalogListingResourceVersion).handleResponseHeaderString("etag", GetAppCatalogListingResourceVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetAppCatalogListingResourceVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetBootVolumeAttachmentResponse> getBootVolumeAttachment(GetBootVolumeAttachmentRequest request, AsyncHandler<GetBootVolumeAttachmentRequest, GetBootVolumeAttachmentResponse> handler) {
        Validate.notBlank((String)request.getBootVolumeAttachmentId(), (String)"bootVolumeAttachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetBootVolumeAttachmentResponse::builder).logger(LOG, "getBootVolumeAttachment").serviceDetails("Compute", "GetBootVolumeAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeAttachment/GetBootVolumeAttachment").method(Method.GET).requestBuilder(GetBootVolumeAttachmentRequest::builder).basePath("/20160918").appendPathParam("bootVolumeAttachments").appendPathParam(request.getBootVolumeAttachmentId()).accept(new String[]{"application/json"}).handleBody(BootVolumeAttachment.class, GetBootVolumeAttachmentResponse.Builder::bootVolumeAttachment).handleResponseHeaderString("etag", GetBootVolumeAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetBootVolumeAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetComputeCapacityReservationResponse> getComputeCapacityReservation(GetComputeCapacityReservationRequest request, AsyncHandler<GetComputeCapacityReservationRequest, GetComputeCapacityReservationResponse> handler) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetComputeCapacityReservationResponse::builder).logger(LOG, "getComputeCapacityReservation").serviceDetails("Compute", "GetComputeCapacityReservation", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/GetComputeCapacityReservation").method(Method.GET).requestBuilder(GetComputeCapacityReservationRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComputeCapacityReservation.class, GetComputeCapacityReservationResponse.Builder::computeCapacityReservation).handleResponseHeaderString("etag", GetComputeCapacityReservationResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeCapacityReservationResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetComputeClusterResponse> getComputeCluster(GetComputeClusterRequest request, AsyncHandler<GetComputeClusterRequest, GetComputeClusterResponse> handler) {
        Validate.notBlank((String)request.getComputeClusterId(), (String)"computeClusterId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetComputeClusterResponse::builder).logger(LOG, "getComputeCluster").serviceDetails("Compute", "GetComputeCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/GetComputeCluster").method(Method.GET).requestBuilder(GetComputeClusterRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendPathParam(request.getComputeClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComputeCluster.class, GetComputeClusterResponse.Builder::computeCluster).handleResponseHeaderString("etag", GetComputeClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetComputeGlobalImageCapabilitySchemaResponse> getComputeGlobalImageCapabilitySchema(GetComputeGlobalImageCapabilitySchemaRequest request, AsyncHandler<GetComputeGlobalImageCapabilitySchemaRequest, GetComputeGlobalImageCapabilitySchemaResponse> handler) {
        Validate.notBlank((String)request.getComputeGlobalImageCapabilitySchemaId(), (String)"computeGlobalImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetComputeGlobalImageCapabilitySchemaResponse::builder).logger(LOG, "getComputeGlobalImageCapabilitySchema").serviceDetails("Compute", "GetComputeGlobalImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGlobalImageCapabilitySchema/GetComputeGlobalImageCapabilitySchema").method(Method.GET).requestBuilder(GetComputeGlobalImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeGlobalImageCapabilitySchemas").appendPathParam(request.getComputeGlobalImageCapabilitySchemaId()).accept(new String[]{"application/json"}).handleBody(ComputeGlobalImageCapabilitySchema.class, GetComputeGlobalImageCapabilitySchemaResponse.Builder::computeGlobalImageCapabilitySchema).handleResponseHeaderString("etag", GetComputeGlobalImageCapabilitySchemaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeGlobalImageCapabilitySchemaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetComputeGlobalImageCapabilitySchemaVersionResponse> getComputeGlobalImageCapabilitySchemaVersion(GetComputeGlobalImageCapabilitySchemaVersionRequest request, AsyncHandler<GetComputeGlobalImageCapabilitySchemaVersionRequest, GetComputeGlobalImageCapabilitySchemaVersionResponse> handler) {
        Validate.notBlank((String)request.getComputeGlobalImageCapabilitySchemaId(), (String)"computeGlobalImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getComputeGlobalImageCapabilitySchemaVersionName(), (String)"computeGlobalImageCapabilitySchemaVersionName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetComputeGlobalImageCapabilitySchemaVersionResponse::builder).logger(LOG, "getComputeGlobalImageCapabilitySchemaVersion").serviceDetails("Compute", "GetComputeGlobalImageCapabilitySchemaVersion", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGlobalImageCapabilitySchemaVersion/GetComputeGlobalImageCapabilitySchemaVersion").method(Method.GET).requestBuilder(GetComputeGlobalImageCapabilitySchemaVersionRequest::builder).basePath("/20160918").appendPathParam("computeGlobalImageCapabilitySchemas").appendPathParam(request.getComputeGlobalImageCapabilitySchemaId()).appendPathParam("versions").appendPathParam(request.getComputeGlobalImageCapabilitySchemaVersionName()).accept(new String[]{"application/json"}).handleBody(ComputeGlobalImageCapabilitySchemaVersion.class, GetComputeGlobalImageCapabilitySchemaVersionResponse.Builder::computeGlobalImageCapabilitySchemaVersion).handleResponseHeaderString("etag", GetComputeGlobalImageCapabilitySchemaVersionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeGlobalImageCapabilitySchemaVersionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetComputeImageCapabilitySchemaResponse> getComputeImageCapabilitySchema(GetComputeImageCapabilitySchemaRequest request, AsyncHandler<GetComputeImageCapabilitySchemaRequest, GetComputeImageCapabilitySchemaResponse> handler) {
        Validate.notBlank((String)request.getComputeImageCapabilitySchemaId(), (String)"computeImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetComputeImageCapabilitySchemaResponse::builder).logger(LOG, "getComputeImageCapabilitySchema").serviceDetails("Compute", "GetComputeImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/GetComputeImageCapabilitySchema").method(Method.GET).requestBuilder(GetComputeImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendPathParam(request.getComputeImageCapabilitySchemaId()).appendQueryParam("isMergeEnabled", (Object)request.getIsMergeEnabled()).accept(new String[]{"application/json"}).handleBody(ComputeImageCapabilitySchema.class, GetComputeImageCapabilitySchemaResponse.Builder::computeImageCapabilitySchema).handleResponseHeaderString("etag", GetComputeImageCapabilitySchemaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetComputeImageCapabilitySchemaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConsoleHistoryResponse> getConsoleHistory(GetConsoleHistoryRequest request, AsyncHandler<GetConsoleHistoryRequest, GetConsoleHistoryResponse> handler) {
        Validate.notBlank((String)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConsoleHistoryResponse::builder).logger(LOG, "getConsoleHistory").serviceDetails("Compute", "GetConsoleHistory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/GetConsoleHistory").method(Method.GET).requestBuilder(GetConsoleHistoryRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendPathParam(request.getInstanceConsoleHistoryId()).accept(new String[]{"application/json"}).handleBody(ConsoleHistory.class, GetConsoleHistoryResponse.Builder::consoleHistory).handleResponseHeaderString("etag", GetConsoleHistoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetConsoleHistoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetConsoleHistoryContentResponse> getConsoleHistoryContent(GetConsoleHistoryContentRequest request, AsyncHandler<GetConsoleHistoryContentRequest, GetConsoleHistoryContentResponse> handler) {
        Validate.notBlank((String)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetConsoleHistoryContentResponse::builder).logger(LOG, "getConsoleHistoryContent").serviceDetails("Compute", "GetConsoleHistoryContent", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/GetConsoleHistoryContent").method(Method.GET).requestBuilder(GetConsoleHistoryContentRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendPathParam(request.getInstanceConsoleHistoryId()).appendPathParam("data").appendQueryParam("offset", (Object)request.getOffset()).appendQueryParam("length", (Object)request.getLength()).accept(new String[]{"application/json"}).handleBody(String.class, GetConsoleHistoryContentResponse.Builder::value).handleResponseHeaderInteger("opc-bytes-remaining", GetConsoleHistoryContentResponse.Builder::opcBytesRemaining).handleResponseHeaderString("opc-request-id", GetConsoleHistoryContentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetDedicatedVmHostResponse> getDedicatedVmHost(GetDedicatedVmHostRequest request, AsyncHandler<GetDedicatedVmHostRequest, GetDedicatedVmHostResponse> handler) {
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetDedicatedVmHostResponse::builder).logger(LOG, "getDedicatedVmHost").serviceDetails("Compute", "GetDedicatedVmHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/GetDedicatedVmHost").method(Method.GET).requestBuilder(GetDedicatedVmHostRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(DedicatedVmHost.class, GetDedicatedVmHostResponse.Builder::dedicatedVmHost).handleResponseHeaderString("etag", GetDedicatedVmHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetDedicatedVmHostResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetImageResponse> getImage(GetImageRequest request, AsyncHandler<GetImageRequest, GetImageResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetImageResponse::builder).logger(LOG, "getImage").serviceDetails("Compute", "GetImage", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/GetImage").method(Method.GET).requestBuilder(GetImageRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).accept(new String[]{"application/json"}).handleBody(Image.class, GetImageResponse.Builder::image).handleResponseHeaderString("etag", GetImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetImageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetImageShapeCompatibilityEntryResponse> getImageShapeCompatibilityEntry(GetImageShapeCompatibilityEntryRequest request, AsyncHandler<GetImageShapeCompatibilityEntryRequest, GetImageShapeCompatibilityEntryResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getShapeName(), (String)"shapeName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetImageShapeCompatibilityEntryResponse::builder).logger(LOG, "getImageShapeCompatibilityEntry").serviceDetails("Compute", "GetImageShapeCompatibilityEntry", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ImageShapeCompatibilityEntry/GetImageShapeCompatibilityEntry").method(Method.GET).requestBuilder(GetImageShapeCompatibilityEntryRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("shapes").appendPathParam(request.getShapeName()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ImageShapeCompatibilityEntry.class, GetImageShapeCompatibilityEntryResponse.Builder::imageShapeCompatibilityEntry).handleResponseHeaderString("opc-request-id", GetImageShapeCompatibilityEntryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstanceResponse> getInstance(GetInstanceRequest request, AsyncHandler<GetInstanceRequest, GetInstanceResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstanceResponse::builder).logger(LOG, "getInstance").serviceDetails("Compute", "GetInstance", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/GetInstance").method(Method.GET).requestBuilder(GetInstanceRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).accept(new String[]{"application/json"}).handleBody(Instance.class, GetInstanceResponse.Builder::instance).handleResponseHeaderString("etag", GetInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstanceConsoleConnectionResponse> getInstanceConsoleConnection(GetInstanceConsoleConnectionRequest request, AsyncHandler<GetInstanceConsoleConnectionRequest, GetInstanceConsoleConnectionResponse> handler) {
        Validate.notBlank((String)request.getInstanceConsoleConnectionId(), (String)"instanceConsoleConnectionId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstanceConsoleConnectionResponse::builder).logger(LOG, "getInstanceConsoleConnection").serviceDetails("Compute", "GetInstanceConsoleConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/GetInstanceConsoleConnection").method(Method.GET).requestBuilder(GetInstanceConsoleConnectionRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").appendPathParam(request.getInstanceConsoleConnectionId()).accept(new String[]{"application/json"}).handleBody(InstanceConsoleConnection.class, GetInstanceConsoleConnectionResponse.Builder::instanceConsoleConnection).handleResponseHeaderString("opc-request-id", GetInstanceConsoleConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetInstanceMaintenanceRebootResponse> getInstanceMaintenanceReboot(GetInstanceMaintenanceRebootRequest request, AsyncHandler<GetInstanceMaintenanceRebootRequest, GetInstanceMaintenanceRebootResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetInstanceMaintenanceRebootResponse::builder).logger(LOG, "getInstanceMaintenanceReboot").serviceDetails("Compute", "GetInstanceMaintenanceReboot", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceMaintenanceReboot/GetInstanceMaintenanceReboot").method(Method.GET).requestBuilder(GetInstanceMaintenanceRebootRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("maintenanceReboot").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(InstanceMaintenanceReboot.class, GetInstanceMaintenanceRebootResponse.Builder::instanceMaintenanceReboot).handleResponseHeaderString("opc-request-id", GetInstanceMaintenanceRebootResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetMeasuredBootReportResponse> getMeasuredBootReport(GetMeasuredBootReportRequest request, AsyncHandler<GetMeasuredBootReportRequest, GetMeasuredBootReportResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetMeasuredBootReportResponse::builder).logger(LOG, "getMeasuredBootReport").serviceDetails("Compute", "GetMeasuredBootReport", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/MeasuredBootReport/GetMeasuredBootReport").method(Method.GET).requestBuilder(GetMeasuredBootReportRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("measuredBootReport").accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(MeasuredBootReport.class, GetMeasuredBootReportResponse.Builder::measuredBootReport).handleResponseHeaderString("etag", GetMeasuredBootReportResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetMeasuredBootReportResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVnicAttachmentResponse> getVnicAttachment(GetVnicAttachmentRequest request, AsyncHandler<GetVnicAttachmentRequest, GetVnicAttachmentResponse> handler) {
        Validate.notBlank((String)request.getVnicAttachmentId(), (String)"vnicAttachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVnicAttachmentResponse::builder).logger(LOG, "getVnicAttachment").serviceDetails("Compute", "GetVnicAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VnicAttachment/GetVnicAttachment").method(Method.GET).requestBuilder(GetVnicAttachmentRequest::builder).basePath("/20160918").appendPathParam("vnicAttachments").appendPathParam(request.getVnicAttachmentId()).accept(new String[]{"application/json"}).handleBody(VnicAttachment.class, GetVnicAttachmentResponse.Builder::vnicAttachment).handleResponseHeaderString("etag", GetVnicAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVnicAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetVolumeAttachmentResponse> getVolumeAttachment(GetVolumeAttachmentRequest request, AsyncHandler<GetVolumeAttachmentRequest, GetVolumeAttachmentResponse> handler) {
        Validate.notBlank((String)request.getVolumeAttachmentId(), (String)"volumeAttachmentId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetVolumeAttachmentResponse::builder).logger(LOG, "getVolumeAttachment").serviceDetails("Compute", "GetVolumeAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/GetVolumeAttachment").method(Method.GET).requestBuilder(GetVolumeAttachmentRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").appendPathParam(request.getVolumeAttachmentId()).accept(new String[]{"application/json"}).handleBody(VolumeAttachment.class, GetVolumeAttachmentResponse.Builder::volumeAttachment).handleResponseHeaderString("etag", GetVolumeAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", GetVolumeAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<GetWindowsInstanceInitialCredentialsResponse> getWindowsInstanceInitialCredentials(GetWindowsInstanceInitialCredentialsRequest request, AsyncHandler<GetWindowsInstanceInitialCredentialsRequest, GetWindowsInstanceInitialCredentialsResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, GetWindowsInstanceInitialCredentialsResponse::builder).logger(LOG, "getWindowsInstanceInitialCredentials").serviceDetails("Compute", "GetWindowsInstanceInitialCredentials", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceCredentials/GetWindowsInstanceInitialCredentials").method(Method.GET).requestBuilder(GetWindowsInstanceInitialCredentialsRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("initialCredentials").accept(new String[]{"application/json"}).handleBody(InstanceCredentials.class, GetWindowsInstanceInitialCredentialsResponse.Builder::instanceCredentials).handleResponseHeaderString("opc-request-id", GetWindowsInstanceInitialCredentialsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<InstanceActionResponse> instanceAction(InstanceActionRequest request, AsyncHandler<InstanceActionRequest, InstanceActionResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getAction(), "action is required");
        return this.clientCall(request, InstanceActionResponse::builder).logger(LOG, "instanceAction").serviceDetails("Compute", "InstanceAction", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/InstanceAction").method(Method.POST).requestBuilder(InstanceActionRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendQueryParam("action", (Object)request.getAction()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Instance.class, InstanceActionResponse.Builder::instance).handleResponseHeaderString("etag", InstanceActionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", InstanceActionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<LaunchInstanceResponse> launchInstance(LaunchInstanceRequest request, AsyncHandler<LaunchInstanceRequest, LaunchInstanceResponse> handler) {
        Objects.requireNonNull(request.getLaunchInstanceDetails(), "launchInstanceDetails is required");
        return this.clientCall(request, LaunchInstanceResponse::builder).logger(LOG, "launchInstance").serviceDetails("Compute", "LaunchInstance", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/LaunchInstance").method(Method.POST).requestBuilder(LaunchInstanceRequest::builder).basePath("/20160918").appendPathParam("instances").accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(Instance.class, LaunchInstanceResponse.Builder::instance).handleResponseHeaderString("etag", LaunchInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", LaunchInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", LaunchInstanceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAppCatalogListingResourceVersionsResponse> listAppCatalogListingResourceVersions(ListAppCatalogListingResourceVersionsRequest request, AsyncHandler<ListAppCatalogListingResourceVersionsRequest, ListAppCatalogListingResourceVersionsResponse> handler) {
        Validate.notBlank((String)request.getListingId(), (String)"listingId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListAppCatalogListingResourceVersionsResponse::builder).logger(LOG, "listAppCatalogListingResourceVersions").serviceDetails("Compute", "ListAppCatalogListingResourceVersions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListingResourceVersionSummary/ListAppCatalogListingResourceVersions").method(Method.GET).requestBuilder(ListAppCatalogListingResourceVersionsRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendPathParam(request.getListingId()).appendPathParam("resourceVersions").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(AppCatalogListingResourceVersionSummary.class, ListAppCatalogListingResourceVersionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAppCatalogListingResourceVersionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAppCatalogListingResourceVersionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAppCatalogListingsResponse> listAppCatalogListings(ListAppCatalogListingsRequest request, AsyncHandler<ListAppCatalogListingsRequest, ListAppCatalogListingsResponse> handler) {
        return this.clientCall(request, ListAppCatalogListingsResponse::builder).logger(LOG, "listAppCatalogListings").serviceDetails("Compute", "ListAppCatalogListings", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogListingSummary/ListAppCatalogListings").method(Method.GET).requestBuilder(ListAppCatalogListingsRequest::builder).basePath("/20160918").appendPathParam("appCatalogListings").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("publisherName", (Object)request.getPublisherName()).appendQueryParam("publisherType", (Object)request.getPublisherType()).appendQueryParam("displayName", (Object)request.getDisplayName()).accept(new String[]{"application/json"}).handleBodyList(AppCatalogListingSummary.class, ListAppCatalogListingsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAppCatalogListingsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAppCatalogListingsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListAppCatalogSubscriptionsResponse> listAppCatalogSubscriptions(ListAppCatalogSubscriptionsRequest request, AsyncHandler<ListAppCatalogSubscriptionsRequest, ListAppCatalogSubscriptionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListAppCatalogSubscriptionsResponse::builder).logger(LOG, "listAppCatalogSubscriptions").serviceDetails("Compute", "ListAppCatalogSubscriptions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/AppCatalogSubscriptionSummary/ListAppCatalogSubscriptions").method(Method.GET).requestBuilder(ListAppCatalogSubscriptionsRequest::builder).basePath("/20160918").appendPathParam("appCatalogSubscriptions").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("listingId", (Object)request.getListingId()).accept(new String[]{"application/json"}).handleBodyList(AppCatalogSubscriptionSummary.class, ListAppCatalogSubscriptionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListAppCatalogSubscriptionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListAppCatalogSubscriptionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListBootVolumeAttachmentsResponse> listBootVolumeAttachments(ListBootVolumeAttachmentsRequest request, AsyncHandler<ListBootVolumeAttachmentsRequest, ListBootVolumeAttachmentsResponse> handler) {
        Objects.requireNonNull(request.getAvailabilityDomain(), "availabilityDomain is required");
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListBootVolumeAttachmentsResponse::builder).logger(LOG, "listBootVolumeAttachments").serviceDetails("Compute", "ListBootVolumeAttachments", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/BootVolumeAttachment/ListBootVolumeAttachments").method(Method.GET).requestBuilder(ListBootVolumeAttachmentsRequest::builder).basePath("/20160918").appendPathParam("bootVolumeAttachments").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("bootVolumeId", (Object)request.getBootVolumeId()).accept(new String[]{"application/json, application/x-json-stream"}).handleBodyList(BootVolumeAttachment.class, ListBootVolumeAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListBootVolumeAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListBootVolumeAttachmentsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputeCapacityReservationInstanceShapesResponse> listComputeCapacityReservationInstanceShapes(ListComputeCapacityReservationInstanceShapesRequest request, AsyncHandler<ListComputeCapacityReservationInstanceShapesRequest, ListComputeCapacityReservationInstanceShapesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListComputeCapacityReservationInstanceShapesResponse::builder).logger(LOG, "listComputeCapacityReservationInstanceShapes").serviceDetails("Compute", "ListComputeCapacityReservationInstanceShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservationInstanceShapeSummary/ListComputeCapacityReservationInstanceShapes").method(Method.GET).requestBuilder(ListComputeCapacityReservationInstanceShapesRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservationInstanceShapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ComputeCapacityReservationInstanceShapeSummary.class, ListComputeCapacityReservationInstanceShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeCapacityReservationInstanceShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityReservationInstanceShapesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputeCapacityReservationInstancesResponse> listComputeCapacityReservationInstances(ListComputeCapacityReservationInstancesRequest request, AsyncHandler<ListComputeCapacityReservationInstancesRequest, ListComputeCapacityReservationInstancesResponse> handler) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListComputeCapacityReservationInstancesResponse::builder).logger(LOG, "listComputeCapacityReservationInstances").serviceDetails("Compute", "ListComputeCapacityReservationInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/CapacityReservationInstanceSummary/ListComputeCapacityReservationInstances").method(Method.GET).requestBuilder(ListComputeCapacityReservationInstancesRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).appendPathParam("instances").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(CapacityReservationInstanceSummary.class, ListComputeCapacityReservationInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeCapacityReservationInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityReservationInstancesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputeCapacityReservationsResponse> listComputeCapacityReservations(ListComputeCapacityReservationsRequest request, AsyncHandler<ListComputeCapacityReservationsRequest, ListComputeCapacityReservationsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListComputeCapacityReservationsResponse::builder).logger(LOG, "listComputeCapacityReservations").serviceDetails("Compute", "ListComputeCapacityReservations", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/ListComputeCapacityReservations").method(Method.GET).requestBuilder(ListComputeCapacityReservationsRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ComputeCapacityReservationSummary.class, ListComputeCapacityReservationsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeCapacityReservationsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeCapacityReservationsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputeClustersResponse> listComputeClusters(ListComputeClustersRequest request, AsyncHandler<ListComputeClustersRequest, ListComputeClustersResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListComputeClustersResponse::builder).logger(LOG, "listComputeClusters").serviceDetails("Compute", "ListComputeClusters", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/ListComputeClusters").method(Method.GET).requestBuilder(ListComputeClustersRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBody(ComputeClusterCollection.class, ListComputeClustersResponse.Builder::computeClusterCollection).handleResponseHeaderString("opc-next-page", ListComputeClustersResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeClustersResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputeGlobalImageCapabilitySchemaVersionsResponse> listComputeGlobalImageCapabilitySchemaVersions(ListComputeGlobalImageCapabilitySchemaVersionsRequest request, AsyncHandler<ListComputeGlobalImageCapabilitySchemaVersionsRequest, ListComputeGlobalImageCapabilitySchemaVersionsResponse> handler) {
        Validate.notBlank((String)request.getComputeGlobalImageCapabilitySchemaId(), (String)"computeGlobalImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListComputeGlobalImageCapabilitySchemaVersionsResponse::builder).logger(LOG, "listComputeGlobalImageCapabilitySchemaVersions").serviceDetails("Compute", "ListComputeGlobalImageCapabilitySchemaVersions", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGlobalImageCapabilitySchemaVersionSummary/ListComputeGlobalImageCapabilitySchemaVersions").method(Method.GET).requestBuilder(ListComputeGlobalImageCapabilitySchemaVersionsRequest::builder).basePath("/20160918").appendPathParam("computeGlobalImageCapabilitySchemas").appendPathParam(request.getComputeGlobalImageCapabilitySchemaId()).appendPathParam("versions").appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(ComputeGlobalImageCapabilitySchemaVersionSummary.class, ListComputeGlobalImageCapabilitySchemaVersionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeGlobalImageCapabilitySchemaVersionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeGlobalImageCapabilitySchemaVersionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputeGlobalImageCapabilitySchemasResponse> listComputeGlobalImageCapabilitySchemas(ListComputeGlobalImageCapabilitySchemasRequest request, AsyncHandler<ListComputeGlobalImageCapabilitySchemasRequest, ListComputeGlobalImageCapabilitySchemasResponse> handler) {
        return this.clientCall(request, ListComputeGlobalImageCapabilitySchemasResponse::builder).logger(LOG, "listComputeGlobalImageCapabilitySchemas").serviceDetails("Compute", "ListComputeGlobalImageCapabilitySchemas", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeGlobalImageCapabilitySchemaSummary/ListComputeGlobalImageCapabilitySchemas").method(Method.GET).requestBuilder(ListComputeGlobalImageCapabilitySchemasRequest::builder).basePath("/20160918").appendPathParam("computeGlobalImageCapabilitySchemas").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(ComputeGlobalImageCapabilitySchemaSummary.class, ListComputeGlobalImageCapabilitySchemasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeGlobalImageCapabilitySchemasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeGlobalImageCapabilitySchemasResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListComputeImageCapabilitySchemasResponse> listComputeImageCapabilitySchemas(ListComputeImageCapabilitySchemasRequest request, AsyncHandler<ListComputeImageCapabilitySchemasRequest, ListComputeImageCapabilitySchemasResponse> handler) {
        return this.clientCall(request, ListComputeImageCapabilitySchemasResponse::builder).logger(LOG, "listComputeImageCapabilitySchemas").serviceDetails("Compute", "ListComputeImageCapabilitySchemas", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchemaSummary/ListComputeImageCapabilitySchemas").method(Method.GET).requestBuilder(ListComputeImageCapabilitySchemasRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("imageId", (Object)request.getImageId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).handleBodyList(ComputeImageCapabilitySchemaSummary.class, ListComputeImageCapabilitySchemasResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListComputeImageCapabilitySchemasResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListComputeImageCapabilitySchemasResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListConsoleHistoriesResponse> listConsoleHistories(ListConsoleHistoriesRequest request, AsyncHandler<ListConsoleHistoriesRequest, ListConsoleHistoriesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListConsoleHistoriesResponse::builder).logger(LOG, "listConsoleHistories").serviceDetails("Compute", "ListConsoleHistories", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/ListConsoleHistories").method(Method.GET).requestBuilder(ListConsoleHistoriesRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(ConsoleHistory.class, ListConsoleHistoriesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListConsoleHistoriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListConsoleHistoriesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDedicatedVmHostInstanceShapesResponse> listDedicatedVmHostInstanceShapes(ListDedicatedVmHostInstanceShapesRequest request, AsyncHandler<ListDedicatedVmHostInstanceShapesRequest, ListDedicatedVmHostInstanceShapesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDedicatedVmHostInstanceShapesResponse::builder).logger(LOG, "listDedicatedVmHostInstanceShapes").serviceDetails("Compute", "ListDedicatedVmHostInstanceShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHostInstanceShapeSummary/ListDedicatedVmHostInstanceShapes").method(Method.GET).requestBuilder(ListDedicatedVmHostInstanceShapesRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHostInstanceShapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("dedicatedVmHostShape", (Object)request.getDedicatedVmHostShape()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DedicatedVmHostInstanceShapeSummary.class, ListDedicatedVmHostInstanceShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDedicatedVmHostInstanceShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDedicatedVmHostInstanceShapesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDedicatedVmHostInstancesResponse> listDedicatedVmHostInstances(ListDedicatedVmHostInstancesRequest request, AsyncHandler<ListDedicatedVmHostInstancesRequest, ListDedicatedVmHostInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListDedicatedVmHostInstancesResponse::builder).logger(LOG, "listDedicatedVmHostInstances").serviceDetails("Compute", "ListDedicatedVmHostInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHostInstanceSummary/ListDedicatedVmHostInstances").method(Method.GET).requestBuilder(ListDedicatedVmHostInstancesRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).appendPathParam("instances").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DedicatedVmHostInstanceSummary.class, ListDedicatedVmHostInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDedicatedVmHostInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDedicatedVmHostInstancesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDedicatedVmHostShapesResponse> listDedicatedVmHostShapes(ListDedicatedVmHostShapesRequest request, AsyncHandler<ListDedicatedVmHostShapesRequest, ListDedicatedVmHostShapesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDedicatedVmHostShapesResponse::builder).logger(LOG, "listDedicatedVmHostShapes").serviceDetails("Compute", "ListDedicatedVmHostShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHostShapeSummary/ListDedicatedVmHostShapes").method(Method.GET).requestBuilder(ListDedicatedVmHostShapesRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHostShapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceShapeName", (Object)request.getInstanceShapeName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DedicatedVmHostShapeSummary.class, ListDedicatedVmHostShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDedicatedVmHostShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDedicatedVmHostShapesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListDedicatedVmHostsResponse> listDedicatedVmHosts(ListDedicatedVmHostsRequest request, AsyncHandler<ListDedicatedVmHostsRequest, ListDedicatedVmHostsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListDedicatedVmHostsResponse::builder).logger(LOG, "listDedicatedVmHosts").serviceDetails("Compute", "ListDedicatedVmHosts", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHostSummary/ListDedicatedVmHosts").method(Method.GET).requestBuilder(ListDedicatedVmHostsRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("instanceShapeName", (Object)request.getInstanceShapeName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendQueryParam("remainingMemoryInGBsGreaterThanOrEqualTo", (Object)request.getRemainingMemoryInGBsGreaterThanOrEqualTo()).appendQueryParam("remainingOcpusGreaterThanOrEqualTo", (Object)request.getRemainingOcpusGreaterThanOrEqualTo()).accept(new String[]{"application/json, application/x-json-stream"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(DedicatedVmHostSummary.class, ListDedicatedVmHostsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListDedicatedVmHostsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListDedicatedVmHostsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListImageShapeCompatibilityEntriesResponse> listImageShapeCompatibilityEntries(ListImageShapeCompatibilityEntriesRequest request, AsyncHandler<ListImageShapeCompatibilityEntriesRequest, ListImageShapeCompatibilityEntriesResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListImageShapeCompatibilityEntriesResponse::builder).logger(LOG, "listImageShapeCompatibilityEntries").serviceDetails("Compute", "ListImageShapeCompatibilityEntries", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ImageShapeCompatibilityEntry/ListImageShapeCompatibilityEntries").method(Method.GET).requestBuilder(ListImageShapeCompatibilityEntriesRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("shapes").appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(ImageShapeCompatibilitySummary.class, ListImageShapeCompatibilityEntriesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListImageShapeCompatibilityEntriesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListImageShapeCompatibilityEntriesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListImagesResponse> listImages(ListImagesRequest request, AsyncHandler<ListImagesRequest, ListImagesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListImagesResponse::builder).logger(LOG, "listImages").serviceDetails("Compute", "ListImages", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/ListImages").method(Method.GET).requestBuilder(ListImagesRequest::builder).basePath("/20160918").appendPathParam("images").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("operatingSystem", (Object)request.getOperatingSystem()).appendQueryParam("operatingSystemVersion", (Object)request.getOperatingSystemVersion()).appendQueryParam("shape", (Object)request.getShape()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json"}).handleBodyList(Image.class, ListImagesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListImagesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListImagesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstanceConsoleConnectionsResponse> listInstanceConsoleConnections(ListInstanceConsoleConnectionsRequest request, AsyncHandler<ListInstanceConsoleConnectionsRequest, ListInstanceConsoleConnectionsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListInstanceConsoleConnectionsResponse::builder).logger(LOG, "listInstanceConsoleConnections").serviceDetails("Compute", "ListInstanceConsoleConnections", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/ListInstanceConsoleConnections").method(Method.GET).requestBuilder(ListInstanceConsoleConnectionsRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).accept(new String[]{"application/json"}).handleBodyList(InstanceConsoleConnection.class, ListInstanceConsoleConnectionsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstanceConsoleConnectionsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstanceConsoleConnectionsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstanceDevicesResponse> listInstanceDevices(ListInstanceDevicesRequest request, AsyncHandler<ListInstanceDevicesRequest, ListInstanceDevicesResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, ListInstanceDevicesResponse::builder).logger(LOG, "listInstanceDevices").serviceDetails("Compute", "ListInstanceDevices", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Device/ListInstanceDevices").method(Method.GET).requestBuilder(ListInstanceDevicesRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendPathParam("devices").appendQueryParam("isAvailable", (Object)request.getIsAvailable()).appendQueryParam("name", (Object)request.getName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).handleBodyList(Device.class, ListInstanceDevicesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstanceDevicesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstanceDevicesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListInstancesResponse> listInstances(ListInstancesRequest request, AsyncHandler<ListInstancesRequest, ListInstancesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListInstancesResponse::builder).logger(LOG, "listInstances").serviceDetails("Compute", "ListInstances", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/ListInstances").method(Method.GET).requestBuilder(ListInstancesRequest::builder).basePath("/20160918").appendPathParam("instances").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("capacityReservationId", (Object)request.getCapacityReservationId()).appendQueryParam("computeClusterId", (Object)request.getComputeClusterId()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("displayName", (Object)request.getDisplayName()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendEnumQueryParam("sortBy", (BmcEnum)request.getSortBy()).appendEnumQueryParam("sortOrder", (BmcEnum)request.getSortOrder()).appendEnumQueryParam("lifecycleState", (BmcEnum)request.getLifecycleState()).accept(new String[]{"application/json, application/x-json-stream"}).handleBodyList(Instance.class, ListInstancesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListInstancesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListInstancesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListShapesResponse> listShapes(ListShapesRequest request, AsyncHandler<ListShapesRequest, ListShapesResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListShapesResponse::builder).logger(LOG, "listShapes").serviceDetails("Compute", "ListShapes", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Shape/ListShapes").method(Method.GET).requestBuilder(ListShapesRequest::builder).basePath("/20160918").appendPathParam("shapes").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("imageId", (Object)request.getImageId()).accept(new String[]{"application/json"}).handleBodyList(Shape.class, ListShapesResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListShapesResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListShapesResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListVnicAttachmentsResponse> listVnicAttachments(ListVnicAttachmentsRequest request, AsyncHandler<ListVnicAttachmentsRequest, ListVnicAttachmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVnicAttachmentsResponse::builder).logger(LOG, "listVnicAttachments").serviceDetails("Compute", "ListVnicAttachments", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VnicAttachment/ListVnicAttachments").method(Method.GET).requestBuilder(ListVnicAttachmentsRequest::builder).basePath("/20160918").appendPathParam("vnicAttachments").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("vnicId", (Object)request.getVnicId()).accept(new String[]{"application/json, application/x-json-stream"}).handleBodyList(VnicAttachment.class, ListVnicAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVnicAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVnicAttachmentsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<ListVolumeAttachmentsResponse> listVolumeAttachments(ListVolumeAttachmentsRequest request, AsyncHandler<ListVolumeAttachmentsRequest, ListVolumeAttachmentsResponse> handler) {
        Objects.requireNonNull(request.getCompartmentId(), "compartmentId is required");
        return this.clientCall(request, ListVolumeAttachmentsResponse::builder).logger(LOG, "listVolumeAttachments").serviceDetails("Compute", "ListVolumeAttachments", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/ListVolumeAttachments").method(Method.GET).requestBuilder(ListVolumeAttachmentsRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").appendQueryParam("availabilityDomain", (Object)request.getAvailabilityDomain()).appendQueryParam("compartmentId", (Object)request.getCompartmentId()).appendQueryParam("limit", (Object)request.getLimit()).appendQueryParam("page", (Object)request.getPage()).appendQueryParam("instanceId", (Object)request.getInstanceId()).appendQueryParam("volumeId", (Object)request.getVolumeId()).accept(new String[]{"application/json, application/x-json-stream"}).handleBodyList(VolumeAttachment.class, ListVolumeAttachmentsResponse.Builder::items).handleResponseHeaderString("opc-next-page", ListVolumeAttachmentsResponse.Builder::opcNextPage).handleResponseHeaderString("opc-request-id", ListVolumeAttachmentsResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<RemoveImageShapeCompatibilityEntryResponse> removeImageShapeCompatibilityEntry(RemoveImageShapeCompatibilityEntryRequest request, AsyncHandler<RemoveImageShapeCompatibilityEntryRequest, RemoveImageShapeCompatibilityEntryResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Validate.notBlank((String)request.getShapeName(), (String)"shapeName must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, RemoveImageShapeCompatibilityEntryResponse::builder).logger(LOG, "removeImageShapeCompatibilityEntry").serviceDetails("Compute", "RemoveImageShapeCompatibilityEntry", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ImageShapeCompatibilityEntry/RemoveImageShapeCompatibilityEntry").method(Method.DELETE).requestBuilder(RemoveImageShapeCompatibilityEntryRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).appendPathParam("shapes").appendPathParam(request.getShapeName()).accept(new String[]{"application/json"}).handleResponseHeaderString("opc-request-id", RemoveImageShapeCompatibilityEntryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<TerminateInstanceResponse> terminateInstance(TerminateInstanceRequest request, AsyncHandler<TerminateInstanceRequest, TerminateInstanceResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        return this.clientCall(request, TerminateInstanceResponse::builder).logger(LOG, "terminateInstance").serviceDetails("Compute", "TerminateInstance", "").method(Method.DELETE).requestBuilder(TerminateInstanceRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).appendQueryParam("preserveBootVolume", (Object)request.getPreserveBootVolume()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).handleResponseHeaderString("opc-request-id", TerminateInstanceResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateComputeCapacityReservationResponse> updateComputeCapacityReservation(UpdateComputeCapacityReservationRequest request, AsyncHandler<UpdateComputeCapacityReservationRequest, UpdateComputeCapacityReservationResponse> handler) {
        Validate.notBlank((String)request.getCapacityReservationId(), (String)"capacityReservationId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeCapacityReservationDetails(), "updateComputeCapacityReservationDetails is required");
        return this.clientCall(request, UpdateComputeCapacityReservationResponse::builder).logger(LOG, "updateComputeCapacityReservation").serviceDetails("Compute", "UpdateComputeCapacityReservation", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCapacityReservation/UpdateComputeCapacityReservation").method(Method.PUT).requestBuilder(UpdateComputeCapacityReservationRequest::builder).basePath("/20160918").appendPathParam("computeCapacityReservations").appendPathParam(request.getCapacityReservationId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).hasBody().handleResponseHeaderString("opc-request-id", UpdateComputeCapacityReservationResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateComputeCapacityReservationResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateComputeClusterResponse> updateComputeCluster(UpdateComputeClusterRequest request, AsyncHandler<UpdateComputeClusterRequest, UpdateComputeClusterResponse> handler) {
        Validate.notBlank((String)request.getComputeClusterId(), (String)"computeClusterId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeClusterDetails(), "updateComputeClusterDetails is required");
        return this.clientCall(request, UpdateComputeClusterResponse::builder).logger(LOG, "updateComputeCluster").serviceDetails("Compute", "UpdateComputeCluster", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeCluster/UpdateComputeCluster").method(Method.PUT).requestBuilder(UpdateComputeClusterRequest::builder).basePath("/20160918").appendPathParam("computeClusters").appendPathParam(request.getComputeClusterId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ComputeCluster.class, UpdateComputeClusterResponse.Builder::computeCluster).handleResponseHeaderString("etag", UpdateComputeClusterResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateComputeClusterResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateComputeImageCapabilitySchemaResponse> updateComputeImageCapabilitySchema(UpdateComputeImageCapabilitySchemaRequest request, AsyncHandler<UpdateComputeImageCapabilitySchemaRequest, UpdateComputeImageCapabilitySchemaResponse> handler) {
        Validate.notBlank((String)request.getComputeImageCapabilitySchemaId(), (String)"computeImageCapabilitySchemaId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateComputeImageCapabilitySchemaDetails(), "updateComputeImageCapabilitySchemaDetails is required");
        return this.clientCall(request, UpdateComputeImageCapabilitySchemaResponse::builder).logger(LOG, "updateComputeImageCapabilitySchema").serviceDetails("Compute", "UpdateComputeImageCapabilitySchema", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ComputeImageCapabilitySchema/UpdateComputeImageCapabilitySchema").method(Method.PUT).requestBuilder(UpdateComputeImageCapabilitySchemaRequest::builder).basePath("/20160918").appendPathParam("computeImageCapabilitySchemas").appendPathParam(request.getComputeImageCapabilitySchemaId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ComputeImageCapabilitySchema.class, UpdateComputeImageCapabilitySchemaResponse.Builder::computeImageCapabilitySchema).handleResponseHeaderString("etag", UpdateComputeImageCapabilitySchemaResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateComputeImageCapabilitySchemaResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateConsoleHistoryResponse> updateConsoleHistory(UpdateConsoleHistoryRequest request, AsyncHandler<UpdateConsoleHistoryRequest, UpdateConsoleHistoryResponse> handler) {
        Validate.notBlank((String)request.getInstanceConsoleHistoryId(), (String)"instanceConsoleHistoryId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateConsoleHistoryDetails(), "updateConsoleHistoryDetails is required");
        return this.clientCall(request, UpdateConsoleHistoryResponse::builder).logger(LOG, "updateConsoleHistory").serviceDetails("Compute", "UpdateConsoleHistory", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/ConsoleHistory/UpdateConsoleHistory").method(Method.PUT).requestBuilder(UpdateConsoleHistoryRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleHistories").appendPathParam(request.getInstanceConsoleHistoryId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(ConsoleHistory.class, UpdateConsoleHistoryResponse.Builder::consoleHistory).handleResponseHeaderString("etag", UpdateConsoleHistoryResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateConsoleHistoryResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateDedicatedVmHostResponse> updateDedicatedVmHost(UpdateDedicatedVmHostRequest request, AsyncHandler<UpdateDedicatedVmHostRequest, UpdateDedicatedVmHostResponse> handler) {
        Validate.notBlank((String)request.getDedicatedVmHostId(), (String)"dedicatedVmHostId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateDedicatedVmHostDetails(), "updateDedicatedVmHostDetails is required");
        return this.clientCall(request, UpdateDedicatedVmHostResponse::builder).logger(LOG, "updateDedicatedVmHost").serviceDetails("Compute", "UpdateDedicatedVmHost", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/DedicatedVmHost/UpdateDedicatedVmHost").method(Method.PUT).requestBuilder(UpdateDedicatedVmHostRequest::builder).basePath("/20160918").appendPathParam("dedicatedVmHosts").appendPathParam(request.getDedicatedVmHostId()).accept(new String[]{"application/json"}).appendHeader("if-match", request.getIfMatch()).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("opc-retry-token", request.getOpcRetryToken()).hasBody().handleBody(DedicatedVmHost.class, UpdateDedicatedVmHostResponse.Builder::dedicatedVmHost).handleResponseHeaderString("etag", UpdateDedicatedVmHostResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateDedicatedVmHostResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateImageResponse> updateImage(UpdateImageRequest request, AsyncHandler<UpdateImageRequest, UpdateImageResponse> handler) {
        Validate.notBlank((String)request.getImageId(), (String)"imageId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateImageDetails(), "updateImageDetails is required");
        return this.clientCall(request, UpdateImageResponse::builder).logger(LOG, "updateImage").serviceDetails("Compute", "UpdateImage", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Image/UpdateImage").method(Method.PUT).requestBuilder(UpdateImageRequest::builder).basePath("/20160918").appendPathParam("images").appendPathParam(request.getImageId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Image.class, UpdateImageResponse.Builder::image).handleResponseHeaderString("etag", UpdateImageResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateImageResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateInstanceResponse> updateInstance(UpdateInstanceRequest request, AsyncHandler<UpdateInstanceRequest, UpdateInstanceResponse> handler) {
        Validate.notBlank((String)request.getInstanceId(), (String)"instanceId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInstanceDetails(), "updateInstanceDetails is required");
        return this.clientCall(request, UpdateInstanceResponse::builder).logger(LOG, "updateInstance").serviceDetails("Compute", "UpdateInstance", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/Instance/UpdateInstance").method(Method.PUT).requestBuilder(UpdateInstanceRequest::builder).basePath("/20160918").appendPathParam("instances").appendPathParam(request.getInstanceId()).accept(new String[]{"application/json"}).appendHeader("opc-retry-token", request.getOpcRetryToken()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(Instance.class, UpdateInstanceResponse.Builder::instance).handleResponseHeaderString("etag", UpdateInstanceResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInstanceResponse.Builder::opcRequestId).handleResponseHeaderString("opc-work-request-id", UpdateInstanceResponse.Builder::opcWorkRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateInstanceConsoleConnectionResponse> updateInstanceConsoleConnection(UpdateInstanceConsoleConnectionRequest request, AsyncHandler<UpdateInstanceConsoleConnectionRequest, UpdateInstanceConsoleConnectionResponse> handler) {
        Validate.notBlank((String)request.getInstanceConsoleConnectionId(), (String)"instanceConsoleConnectionId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateInstanceConsoleConnectionDetails(), "updateInstanceConsoleConnectionDetails is required");
        return this.clientCall(request, UpdateInstanceConsoleConnectionResponse::builder).logger(LOG, "updateInstanceConsoleConnection").serviceDetails("Compute", "UpdateInstanceConsoleConnection", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/InstanceConsoleConnection/UpdateInstanceConsoleConnection").method(Method.PUT).requestBuilder(UpdateInstanceConsoleConnectionRequest::builder).basePath("/20160918").appendPathParam("instanceConsoleConnections").appendPathParam(request.getInstanceConsoleConnectionId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(InstanceConsoleConnection.class, UpdateInstanceConsoleConnectionResponse.Builder::instanceConsoleConnection).handleResponseHeaderString("etag", UpdateInstanceConsoleConnectionResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateInstanceConsoleConnectionResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Override
    public Future<UpdateVolumeAttachmentResponse> updateVolumeAttachment(UpdateVolumeAttachmentRequest request, AsyncHandler<UpdateVolumeAttachmentRequest, UpdateVolumeAttachmentResponse> handler) {
        Validate.notBlank((String)request.getVolumeAttachmentId(), (String)"volumeAttachmentId must not be blank", (Object[])new Object[0]);
        Objects.requireNonNull(request.getUpdateVolumeAttachmentDetails(), "updateVolumeAttachmentDetails is required");
        return this.clientCall(request, UpdateVolumeAttachmentResponse::builder).logger(LOG, "updateVolumeAttachment").serviceDetails("Compute", "UpdateVolumeAttachment", "https://docs.oracle.com/iaas/api/#/en/iaas/20160918/VolumeAttachment/UpdateVolumeAttachment").method(Method.PUT).requestBuilder(UpdateVolumeAttachmentRequest::builder).basePath("/20160918").appendPathParam("volumeAttachments").appendPathParam(request.getVolumeAttachmentId()).accept(new String[]{"application/json"}).appendHeader("opc-request-id", request.getOpcRequestId()).appendHeader("if-match", request.getIfMatch()).hasBody().handleBody(VolumeAttachment.class, UpdateVolumeAttachmentResponse.Builder::volumeAttachment).handleResponseHeaderString("etag", UpdateVolumeAttachmentResponse.Builder::etag).handleResponseHeaderString("opc-request-id", UpdateVolumeAttachmentResponse.Builder::opcRequestId).callAsync(handler);
    }

    @Deprecated
    public ComputeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider) {
        this((ClientBuilderBase<?, ?>)ComputeAsyncClient.builder(), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration) {
        this(ComputeAsyncClient.builder().configuration(configuration), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeAsyncClient(BasicAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator) {
        this(((Builder)ComputeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator), (AbstractAuthenticationDetailsProvider)authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory) {
        this(((Builder)((Builder)ComputeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators) {
        this(((Builder)((Builder)((Builder)ComputeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)ComputeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint), authenticationDetailsProvider);
    }

    @Deprecated
    public ComputeAsyncClient(AbstractAuthenticationDetailsProvider authenticationDetailsProvider, ClientConfiguration configuration, ClientConfigurator clientConfigurator, RequestSignerFactory defaultRequestSignerFactory, Map<SigningStrategy, RequestSignerFactory> signingStrategyRequestSignerFactories, List<ClientConfigurator> additionalClientConfigurators, String endpoint) {
        this(((Builder)((Builder)((Builder)((Builder)((Builder)ComputeAsyncClient.builder().configuration(configuration)).clientConfigurator(clientConfigurator)).requestSignerFactory(defaultRequestSignerFactory)).additionalClientConfigurators(additionalClientConfigurators)).endpoint(endpoint)).signingStrategyRequestSignerFactories(signingStrategyRequestSignerFactories), authenticationDetailsProvider);
    }

    public static class Builder
    extends RegionalClientBuilder<Builder, ComputeAsyncClient> {
        private Builder(Service service) {
            super(service);
            String packageName = "core";
            Alloy.throwDisabledServiceExceptionIfAppropriate((String)"core");
            this.requestSignerFactory = new DefaultRequestSignerFactory(SigningStrategy.STANDARD);
        }

        public ComputeAsyncClient build(@Nonnull AbstractAuthenticationDetailsProvider authenticationDetailsProvider) {
            return new ComputeAsyncClient((ClientBuilderBase<?, ?>)this, authenticationDetailsProvider);
        }
    }
}

