/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.lsp.client.debugger.breakpoints;

import java.util.LinkedList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.modules.lsp.client.debugger.breakpoints.Bundle;
import org.netbeans.modules.lsp.client.debugger.breakpoints.DAPLineBreakpoint;
import org.netbeans.spi.debugger.ui.BreakpointAnnotation;
import org.openide.text.Annotatable;
import org.openide.text.Line;

public final class DebuggerBreakpointAnnotation
extends BreakpointAnnotation {
    public static final String BREAKPOINT_ANNOTATION_TYPE = "Breakpoint";
    public static final String DISABLED_BREAKPOINT_ANNOTATION_TYPE = "DisabledBreakpoint";
    public static final String CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "CondBreakpoint";
    public static final String DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE = "DisabledCondBreakpoint";
    private final String type;
    private final DAPLineBreakpoint breakpoint;

    private DebuggerBreakpointAnnotation(String type, Annotatable annotatable, DAPLineBreakpoint b) {
        this.type = type;
        this.breakpoint = b;
        this.attach(annotatable);
    }

    @CheckForNull
    public static DebuggerBreakpointAnnotation create(String type, DAPLineBreakpoint b) {
        Line line = b.getLine();
        if (line == null) {
            return null;
        }
        return new DebuggerBreakpointAnnotation(type, (Annotatable)line, b);
    }

    public String getAnnotationType() {
        return this.type;
    }

    public String getShortDescription() {
        Breakpoint.HIT_COUNT_FILTERING_STYLE hitCountFilteringStyle;
        LinkedList<String> list = new LinkedList<String>();
        String condition = this.breakpoint.getCondition();
        if (condition != null) {
            list.add(condition);
        }
        if ((hitCountFilteringStyle = this.breakpoint.getHitCountFilteringStyle()) != null) {
            int hcf = this.breakpoint.getHitCountFilter();
            list.add(switch (hitCountFilteringStyle) {
                case Breakpoint.HIT_COUNT_FILTERING_STYLE.EQUAL -> Bundle.TTP_Breakpoint_HitsEqual(hcf);
                case Breakpoint.HIT_COUNT_FILTERING_STYLE.GREATER -> Bundle.TTP_Breakpoint_HitsGreaterThan(hcf);
                case Breakpoint.HIT_COUNT_FILTERING_STYLE.MULTIPLE -> Bundle.TTP_Breakpoint_HitsMultipleOf(hcf);
                default -> throw new IllegalStateException("Unknown HitCountFilteringStyle: " + hitCountFilteringStyle);
            });
        }
        String typeDesc = this.getBPTypeDescription();
        if (list.isEmpty()) {
            return typeDesc;
        }
        StringBuilder result = new StringBuilder(typeDesc);
        result.append("\n");
        result.append(Bundle.TTP_Breakpoint_Hits());
        for (String text : list) {
            result.append("\n");
            result.append(text);
        }
        return result.toString();
    }

    private String getBPTypeDescription() {
        if (this.type.endsWith("_broken")) {
            if (this.breakpoint.getValidity() == Breakpoint.VALIDITY.INVALID) {
                String msg = this.breakpoint.getValidityMessage();
                return Bundle.TTP_BreakpointBrokenInvalid(msg);
            }
            return Bundle.TTP_BreakpointBroken();
        }
        if (this.type.endsWith("_stroke")) {
            return Bundle.TTP_BreakpointStroke();
        }
        switch (this.type) {
            case "Breakpoint": {
                return Bundle.TTP_Breakpoint();
            }
            case "DisabledBreakpoint": {
                return Bundle.TTP_BreakpointDisabled();
            }
            case "CondBreakpoint": {
                return Bundle.TTP_BreakpointConditional();
            }
            case "DisabledCondBreakpoint": {
                return Bundle.TTP_BreakpointDisabledConditional();
            }
        }
        throw new IllegalStateException(this.type);
    }

    public Breakpoint getBreakpoint() {
        return this.breakpoint;
    }
}

