/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.api.common.project;

import java.awt.Dialog;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.EventListener;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.lang.model.element.TypeElement;
import javax.swing.JButton;
import javax.swing.SwingUtilities;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.project.runner.JavaRunner;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.ActionProviderSupport;
import org.netbeans.modules.java.api.common.project.Bundle;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassChooser;
import org.netbeans.modules.java.api.common.project.ui.customizer.MainClassWarning;
import org.netbeans.modules.java.api.common.util.CommonProjectUtils;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.ProjectConfiguration;
import org.netbeans.spi.project.SingleMethod;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.ui.CustomizerProvider2;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.MouseUtils;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class JavaActionProvider
implements ActionProvider {
    private static final Logger LOG = Logger.getLogger(JavaActionProvider.class.getName());
    private static final FileObject[] EMPTY = new FileObject[0];
    static volatile String unitTestingSupport_fixClasses;
    private final Project prj;
    private final UpdateHelper updateHelper;
    private final PropertyEvaluator eval;
    private final Function<String, ClassPath> classpaths;
    private final Map<String, Action> supportedActions;
    private final List<AntTargetInvocationListener> listeners;
    private final Supplier<? extends JavaPlatform> jpp;
    private final BiFunction<String, Lookup, Map<String, String>> additionalPropertiesProvider;
    private final BiFunction<String, Lookup, Set<String>> concealedPropertiesProvider;
    private final Supplier<? extends Set<? extends CompileOnSaveOperation>> cosOpsProvider;
    private ActionProviderSupport.UserPropertiesPolicy userPropertiesPolicy;

    private JavaActionProvider(@NonNull Project project, @NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator evaluator, @NonNull Function<String, ClassPath> classpaths, @NonNull Collection<? extends Action> actions, @NonNull Supplier<? extends JavaPlatform> javaPlatformProvider, @NullAllowed BiFunction<String, Lookup, Map<String, String>> additionalPropertiesProvider, @NullAllowed BiFunction<String, Lookup, Set<String>> concealedPropertiesProvider, @NonNull Supplier<? extends Set<? extends CompileOnSaveOperation>> cosOpsProvider, final @NonNull ActionProviderSupport.ModifiedFilesSupport mfs) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
        Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
        Parameters.notNull((CharSequence)"classpaths", classpaths);
        Parameters.notNull((CharSequence)"actions", actions);
        Parameters.notNull((CharSequence)"javaPlatformProvider", javaPlatformProvider);
        Parameters.notNull((CharSequence)"cosOpsProvider", cosOpsProvider);
        Parameters.notNull((CharSequence)"mfs", (Object)mfs);
        this.prj = project;
        this.updateHelper = updateHelper;
        this.eval = evaluator;
        this.classpaths = classpaths;
        HashMap<String, Action> abn = new HashMap<String, Action>();
        for (Action action : actions) {
            abn.put(action.getCommand(), action);
        }
        this.supportedActions = Collections.unmodifiableMap(abn);
        this.listeners = new CopyOnWriteArrayList<AntTargetInvocationListener>();
        this.listeners.add(new AntTargetInvocationListener(){

            @Override
            public void antTargetInvocationStarted(String command, Lookup context) {
            }

            @Override
            public void antTargetInvocationFinished(String command, Lookup context, int result) {
                if (result != 0 || "clean".equals(command)) {
                    mfs.resetDirtyList();
                }
            }

            @Override
            public void antTargetInvocationFailed(String command, Lookup context) {
            }
        });
        this.jpp = javaPlatformProvider;
        this.additionalPropertiesProvider = additionalPropertiesProvider;
        this.concealedPropertiesProvider = concealedPropertiesProvider;
        this.cosOpsProvider = cosOpsProvider;
    }

    public String[] getSupportedActions() {
        return this.supportedActions.keySet().toArray(new String[this.supportedActions.size()]);
    }

    public boolean isActionEnabled(@NonNull String command, @NonNull Lookup context) throws IllegalArgumentException {
        return Optional.ofNullable(this.supportedActions.get(command)).map(act -> act.isEnabled(new Context(this.prj, this.updateHelper, this.eval, this.classpaths, command, context, this.userPropertiesPolicy, this.jpp, this.additionalPropertiesProvider, this.concealedPropertiesProvider, this.cosOpsProvider, this.listeners))).orElse(Boolean.FALSE);
    }

    public void invokeAction(@NonNull String command, @NonNull Lookup context) throws IllegalArgumentException {
        assert (SwingUtilities.isEventDispatchThread());
        Optional.ofNullable(this.supportedActions.get(command)).ifPresent(act -> {
            Context ctx = new Context(this.prj, this.updateHelper, this.eval, this.classpaths, command, context, this.userPropertiesPolicy, this.jpp, this.additionalPropertiesProvider, this.concealedPropertiesProvider, this.cosOpsProvider, this.listeners);
            try {
                act.invoke(ctx);
            }
            finally {
                this.userPropertiesPolicy = ctx.getUserPropertiesPolicy();
            }
        });
    }

    public void addAntTargetInvocationListener(@NonNull AntTargetInvocationListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.add(listener);
    }

    public void removeAntTargetInvocationListener(@NonNull AntTargetInvocationListener listener) {
        Parameters.notNull((CharSequence)"listener", (Object)listener);
        this.listeners.remove(listener);
    }

    @CheckForNull
    Action getAction(@NonNull String command) {
        return this.supportedActions.get(command);
    }

    @NonNull
    private static ScriptAction createBuildAction(boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, @NonNull Supplier<? extends String[]> targets, final @NonNull ActionProviderSupport.ModifiedFilesSupport mfs) {
        return new BaseScriptAction("build", true, javaModelSensitive, scanSensitive, enabledInCoS, targets){

            @Override
            public String[] getTargetNames(Context context) {
                String includes;
                String[] targets = super.getTargetNames(context);
                if (targets != null && (includes = mfs.prepareDirtyList(true)) != null) {
                    context.setProperty("includes", includes);
                }
                return targets;
            }

            @Override
            public ScriptAction.Result performCompileOnSave(Context context, String[] targetNames) {
                if (!ActionProviderSupport.allowAntBuild(context.getPropertyEvaluator(), context.getUpdateHelper())) {
                    this.showBuildActionWarning(context);
                    return ScriptAction.Result.abort();
                }
                return ScriptAction.Result.follow();
            }

            @SuppressWarnings(value={"ES_COMPARING_STRINGS_WITH_EQ"})
            private void showBuildActionWarning(Context context) {
                ActionProvider ap;
                String projectProperties = Bundle.BTN_ProjectProperties();
                String cleanAndBuild = Bundle.BTN_CleanAndBuild();
                String ok = Bundle.BTN_OK();
                DialogDescriptor dd = new DialogDescriptor((Object)Bundle.LBL_ProjectBuiltAutomatically(), Bundle.TITLE_BuildProjectWarning(ProjectUtils.getInformation((Project)context.getProject()).getDisplayName()), true, new Object[]{projectProperties, cleanAndBuild, ok}, (Object)ok, 0, null, null);
                dd.setMessageType(2);
                Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)dd);
                if (result == projectProperties) {
                    CustomizerProvider2 p = (CustomizerProvider2)context.getProject().getLookup().lookup(CustomizerProvider2.class);
                    p.showCustomizer("Build", null);
                    return;
                }
                if (result == cleanAndBuild && (ap = (ActionProvider)context.getProject().getLookup().lookup(ActionProvider.class)) != null) {
                    ap.invokeAction("rebuild", context.getActiveLookup());
                }
            }
        };
    }

    @NonNull
    private static ScriptAction createCompileSingleAction(boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, final @NonNull SourceRoots sourceRoots, final @NonNull SourceRoots testRoots, @NonNull Supplier<? extends String[]> targets) {
        return new BaseScriptAction("compile.single", true, javaModelSensitive, scanSensitive, enabledInCoS, targets){

            @Override
            public boolean isEnabled(Context context) {
                return super.isEnabled(context) && (ActionProviderSupport.findSourcesAndPackages(context.getActiveLookup(), sourceRoots.getRoots()) != null || ActionProviderSupport.findSourcesAndPackages(context.getActiveLookup(), testRoots.getRoots()) != null);
            }

            @Override
            public String[] getTargetNames(Context context) {
                String[] res = super.getTargetNames(context);
                if (res != null) {
                    boolean recursive;
                    Lookup lkp = context.getActiveLookup();
                    FileObject[] srcRoots = sourceRoots.getRoots();
                    FileObject[] files = ActionProviderSupport.findSourcesAndPackages(lkp, srcRoots);
                    boolean bl = recursive = lkp.lookup(NonRecursiveFolder.class) == null;
                    if (files != null) {
                        context.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)ActionProviderSupport.getRoot(srcRoots, files[0]), (boolean)recursive));
                        String[] cfgTargets = ActionProviderSupport.loadTargetsFromConfig(context.getProject(), context.getPropertyEvaluator()).get(context.getCommand());
                        if (cfgTargets != null) {
                            res = cfgTargets;
                        }
                    } else {
                        srcRoots = testRoots.getRoots();
                        files = ActionProviderSupport.findSourcesAndPackages(context.getActiveLookup(), srcRoots);
                        if (files != null) {
                            context.setProperty("javac.includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)ActionProviderSupport.getRoot(srcRoots, files[0]), (boolean)recursive));
                            res = new String[]{"compile-test-single"};
                        } else {
                            res = null;
                        }
                    }
                }
                return res;
            }
        };
    }

    @NonNull
    private static ScriptAction createRunSingleAction(final @NonNull String command, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, SourceRoots sr, SourceRoots tr, @NonNull Supplier<? extends String[]> targets, final @NullAllowed Builder.CustomFileExecutor customFileExecutor) {
        return new BaseRunSingleAction(command, true, javaModelSensitive, scanSensitive, enabledInCoS, sr, tr, targets){
            private static final String PROP_CUSTOM_RUNNER = "JavaActionProvider.invokeByCustomExecutor";

            @Override
            public boolean isEnabled(Context context) {
                if (super.isEnabled(context)) {
                    FileObject[] fos = ActionProviderSupport.findSources(this.getSourceRoots().getRoots(), context.getActiveLookup());
                    if (fos != null && fos.length == 1) {
                        return true;
                    }
                    fos = ActionProviderSupport.findTestSources(this.getSourceRoots().getRoots(), this.getTestRoots().getRoots(), context.getActiveLookup(), false);
                    if (fos != null && fos.length == 1) {
                        return true;
                    }
                    JavaActionProvider.logNoFiles(this.getSourceRoots(), this.getTestRoots(), context);
                }
                return false;
            }

            @Override
            public ScriptAction.Result performCompileOnSave(Context context, String[] targetNames) {
                boolean cr;
                boolean bl = cr = context.getProperty(PROP_CUSTOM_RUNNER) != null;
                if (cr) {
                    context.removeProperty(PROP_CUSTOM_RUNNER);
                    return customFileExecutor.performCompileOnSave(context, targetNames);
                }
                return super.performCompileOnSave(context, targetNames);
            }

            @Override
            public String[] getTargetNames(Context context) {
                String[] res = super.getTargetNames(context);
                if (res != null) {
                    boolean hasMainClassFromTest;
                    FileObject[] files = ActionProviderSupport.findTestSources(this.getSourceRoots().getRoots(), this.getTestRoots().getRoots(), context.getActiveLookup(), false);
                    FileObject[] rootz = this.getTestRoots().getRoots();
                    boolean isTest = true;
                    if (files == null) {
                        isTest = false;
                        files = ActionProviderSupport.findSources(this.getSourceRoots().getRoots(), context.getActiveLookup());
                        rootz = this.getSourceRoots().getRoots();
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Is test: {0} Files: {1} Roots: {2}", new Object[]{isTest, JavaActionProvider.asPath(files), JavaActionProvider.asPath(rootz)});
                    }
                    if (files == null) {
                        return null;
                    }
                    FileObject file = files[0];
                    assert (file != null);
                    if (!file.isValid()) {
                        LOG.log(Level.WARNING, "FileObject to execute: {0} is not valid.", FileUtil.getFileDisplayName((FileObject)file));
                        return null;
                    }
                    String[] pathFqn = ActionProviderSupport.pathAndFqn(file, rootz);
                    if (pathFqn == null) {
                        return null;
                    }
                    context.setProperty("javac.includes", pathFqn[0]);
                    String clazz = pathFqn[1];
                    LOG.log(Level.FINE, "Class to run: {0}", clazz);
                    boolean bl = hasMainClassFromTest = MainClassChooser.unitTestingSupport_hasMainMethodResult == null ? false : MainClassChooser.unitTestingSupport_hasMainMethodResult;
                    if (context.doJavaChecks()) {
                        Collection<ElementHandle<TypeElement>> mainClasses = CommonProjectUtils.getMainMethods(file);
                        LOG.log(Level.FINE, "Main classes: {0} ", mainClasses);
                        if (!hasMainClassFromTest && mainClasses.isEmpty()) {
                            String[] customTargets;
                            String[] stringArray = customTargets = customFileExecutor == null ? null : customFileExecutor.getTargetNames(file, context);
                            if (customTargets != null) {
                                context.setProperty(PROP_CUSTOM_RUNNER, Boolean.TRUE.toString());
                                res = customTargets;
                            } else if (isTest) {
                                res = ActionProviderSupport.setupTestSingle(context, files, this.getTestRoots().getRoots());
                            } else {
                                ActionProviderSupport.JavaMainAction javaMainAction = ActionProviderSupport.getJavaMainAction(context.getPropertyEvaluator());
                                if (javaMainAction == null) {
                                    NotifyDescriptor.Message nd = new NotifyDescriptor.Message((Object)Bundle.LBL_No_Main_Class_Found(clazz), 1);
                                    DialogDisplayer.getDefault().notify((NotifyDescriptor)nd);
                                    return null;
                                }
                                if (javaMainAction == ActionProviderSupport.JavaMainAction.RUN) {
                                    res = this.updateTargets(res, clazz, false, context);
                                } else if (javaMainAction == ActionProviderSupport.JavaMainAction.TEST) {
                                    res = ActionProviderSupport.setupTestSingle(context, files, this.getSourceRoots().getRoots());
                                }
                            }
                        } else {
                            if (!hasMainClassFromTest) {
                                if (mainClasses.size() == 1) {
                                    clazz = mainClasses.iterator().next().getBinaryName();
                                } else {
                                    clazz = this.showMainClassWarning(file, mainClasses);
                                    if (clazz == null) {
                                        return null;
                                    }
                                }
                            }
                            res = this.updateTargets(res, clazz, isTest, context);
                        }
                    } else {
                        res = this.updateTargets(res, clazz, isTest, context);
                    }
                }
                return res;
            }

            private String[] updateTargets(@NonNull String[] targets, @NonNull String clazz, boolean isTest, @NonNull Context context) {
                String[] cfgTargets;
                switch (context.getCommand()) {
                    case "run.single": {
                        context.setProperty("run.class", clazz);
                        if (!isTest) break;
                        targets = new String[]{"run-test-with-main"};
                        break;
                    }
                    case "debug.single": {
                        context.setProperty("debug.class", clazz);
                        if (!isTest) break;
                        targets = new String[]{"debug-test-with-main"};
                        break;
                    }
                    default: {
                        context.setProperty("run.class", clazz);
                        if (!isTest) break;
                        targets = new String[]{"profile-test-with-main"};
                    }
                }
                if ((cfgTargets = ActionProviderSupport.loadTargetsFromConfig(context.getProject(), context.getPropertyEvaluator()).get(command)) != null) {
                    targets = cfgTargets;
                }
                return targets;
            }

            private String showMainClassWarning(FileObject file, Collection<ElementHandle<TypeElement>> mainClasses) {
                assert (mainClasses != null);
                String mainClass = null;
                JButton okButton = new JButton(Bundle.LBL_MainClassWarning_ChooseMainClass_OK());
                okButton.getAccessibleContext().setAccessibleDescription(Bundle.AD_MainClassWarning_ChooseMainClass_OK());
                MainClassWarning panel = new MainClassWarning(Bundle.CTL_FileMultipleMain(file.getNameExt()), mainClasses);
                Object[] options = new Object[]{okButton, DialogDescriptor.CANCEL_OPTION};
                panel.addChangeListener(e -> {
                    if (e.getSource() instanceof MouseEvent && MouseUtils.isDoubleClick((MouseEvent)((MouseEvent)e.getSource()))) {
                        okButton.doClick();
                    } else {
                        okButton.setEnabled(panel.getSelectedMainClass() != null);
                    }
                });
                DialogDescriptor desc = new DialogDescriptor((Object)panel, Bundle.CTL_FileMainClass_Title(), true, options, options[0], 0, null, null);
                desc.setMessageType(1);
                Dialog dlg = DialogDisplayer.getDefault().createDialog(desc);
                dlg.setVisible(true);
                if (desc.getValue() == options[0]) {
                    mainClass = panel.getSelectedMainClass();
                }
                dlg.dispose();
                return mainClass;
            }
        };
    }

    @NonNull
    private static ScriptAction createTestSingleAction(boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, @NonNull SourceRoots sr, @NonNull SourceRoots tr, @NonNull Supplier<? extends String[]> targets) {
        return new BaseRunSingleAction("test.single", true, javaModelSensitive, scanSensitive, enabledInCoS, sr, tr, (Supplier)targets){

            @Override
            public boolean isEnabled(Context context) {
                return super.isEnabled(context) && ActionProviderSupport.findTestSourcesForFiles(this.getSourceRoots().getRoots(), this.getTestRoots().getRoots(), context.getActiveLookup()) != null;
            }

            @Override
            public String[] getTargetNames(Context context) {
                context.setProperty("ignore.failing.tests", "true");
                FileObject[] files = ActionProviderSupport.findTestSourcesForFiles(this.getSourceRoots().getRoots(), this.getTestRoots().getRoots(), context.getActiveLookup());
                if (files == null) {
                    return null;
                }
                if (files.length == 1 && files[0].isData()) {
                    return ActionProviderSupport.setupTestSingle(context, files, this.getTestRoots().getRoots());
                }
                if (files != null) {
                    FileObject root = ActionProviderSupport.getRoot(this.getTestRoots().getRoots(), files[0]);
                    context.setProperty("includes", ActionUtils.antIncludesList((FileObject[])files, (FileObject)root).replace("**", "**/*Test.java"));
                }
                return new String[]{"test"};
            }
        };
    }

    @NonNull
    private static ScriptAction createDebugTestSingleAction(@NonNull String command, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, @NonNull SourceRoots sr, @NonNull SourceRoots tr, @NonNull Supplier<? extends String[]> targets) {
        return new BaseRunSingleAction(command, true, javaModelSensitive, scanSensitive, enabledInCoS, sr, tr, (Supplier)targets){

            @Override
            public boolean isEnabled(Context context) {
                if (!super.isEnabled(context)) {
                    return false;
                }
                FileObject[] fos = ActionProviderSupport.findTestSources(this.getSourceRoots().getRoots(), this.getTestRoots().getRoots(), context.getActiveLookup(), true);
                return fos != null && fos.length == 1;
            }

            @Override
            public String[] getTargetNames(Context context) {
                FileObject[] files = ActionProviderSupport.findTestSources(this.getSourceRoots().getRoots(), this.getTestRoots().getRoots(), context.getActiveLookup(), true);
                if (files != null) {
                    return ActionProviderSupport.setupTestSingle(context, files, this.getTestRoots().getRoots());
                }
                return null;
            }
        };
    }

    @NonNull
    private static ScriptAction createRunSingleMethodAction(final @NonNull String command, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, final @NonNull SourceRoots testRoots, @NonNull Supplier<? extends String[]> targets) {
        return new BaseScriptAction(command, true, javaModelSensitive, scanSensitive, enabledInCoS, targets){

            @Override
            public boolean isEnabled(Context context) {
                if (!super.isEnabled(context)) {
                    return false;
                }
                SingleMethod[] methodSpecs = this.findTestMethods(context);
                return methodSpecs != null && methodSpecs.length == 1;
            }

            @Override
            @CheckForNull
            public String[] getTargetNames(Context context) {
                String[] res = super.getTargetNames(context);
                if (res != null) {
                    SingleMethod[] methodSpecs = this.findTestMethods(context);
                    if (methodSpecs == null || methodSpecs.length != 1) {
                        return null;
                    }
                    FileObject testFile = methodSpecs[0].getFile();
                    String[] pathFqn = ActionProviderSupport.pathAndFqn(testFile, testRoots.getRoots());
                    if (pathFqn == null) {
                        return null;
                    }
                    context.setProperty("javac.includes", pathFqn[0]);
                    context.setProperty("test.class", pathFqn[1]);
                    context.setProperty("test.method", methodSpecs[0].getMethodName());
                }
                return res;
            }

            @Override
            @NonNull
            public ScriptAction.Result performCompileOnSave(@NonNull Context context, @NonNull String[] targetNames) {
                SingleMethod[] methodSpecs = this.findTestMethods(context);
                if (methodSpecs != null) {
                    try {
                        Map<String, Object> execProperties = ActionProviderSupport.createBaseCoSProperties(context);
                        execProperties.put("methodname", methodSpecs[0].getMethodName());
                        execProperties.put("execute.file", methodSpecs[0].getFile());
                        String buildDir = context.getPropertyEvaluator().getProperty("build.dir");
                        if (buildDir != null) {
                            execProperties.put("tmp.dir", context.getUpdateHelper().getAntProjectHelper().resolvePath(buildDir));
                        }
                        boolean vote = true;
                        BiFunction<Context, Map<String, Object>, Boolean> cosi = this.getCoSInterceptor();
                        if (cosi != null) {
                            vote = cosi.apply(context, execProperties);
                        }
                        if (vote) {
                            return ScriptAction.Result.success(JavaRunner.execute((String)(command.equals("run.single.method") ? "junit" : "junit-debug"), execProperties));
                        }
                    }
                    catch (IOException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
                return ScriptAction.Result.abort();
            }

            @CheckForNull
            @SuppressWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"})
            private SingleMethod[] findTestMethods(@NonNull Context context) {
                Collection methodSpecs = context.getActiveLookup().lookupAll(SingleMethod.class);
                if (methodSpecs.isEmpty()) {
                    return null;
                }
                FileObject[] testSrcPath = testRoots.getRoots();
                if (testSrcPath == null || testSrcPath.length == 0) {
                    return null;
                }
                LinkedHashSet<SingleMethod> specs = new LinkedHashSet<SingleMethod>();
                for (FileObject testRoot : testSrcPath) {
                    for (SingleMethod spec : methodSpecs) {
                        FileObject f = spec.getFile();
                        if (FileUtil.toFile((FileObject)f) == null || f != testRoot && !FileUtil.isParentOf((FileObject)testRoot, (FileObject)f) || !f.getNameExt().endsWith(".java")) continue;
                        specs.add(spec);
                    }
                }
                if (specs.isEmpty()) {
                    return null;
                }
                return specs.toArray(new SingleMethod[0]);
            }
        };
    }

    private static ScriptAction createDebugFixAction(@NonNull String command, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, final @NonNull SourceRoots sourceRoots, final @NonNull SourceRoots testRoots, @NonNull Supplier<? extends String[]> targets) {
        return new BaseScriptAction(command, true, javaModelSensitive, scanSensitive, enabledInCoS, targets){

            @Override
            public boolean isEnabled(Context context) {
                if (super.isEnabled(context)) {
                    FileObject[] fos = ActionProviderSupport.findSources(sourceRoots.getRoots(), context.getActiveLookup());
                    if (fos != null && fos.length == 1) {
                        return true;
                    }
                    fos = ActionProviderSupport.findTestSources(sourceRoots.getRoots(), testRoots.getRoots(), context.getActiveLookup(), false);
                    if (fos != null && fos.length == 1) {
                        return true;
                    }
                    if (LOG.isLoggable(Level.FINE)) {
                        LOG.log(Level.FINE, "Source Roots: {0} Test Roots: {1} Lookup Content: {2}", new Object[]{JavaActionProvider.asPath(sourceRoots.getRoots()), JavaActionProvider.asPath(testRoots.getRoots()), JavaActionProvider.asPath(context.getActiveLookup())});
                    }
                }
                return false;
            }

            @Override
            public String[] getTargetNames(Context context) {
                String[] res = super.getTargetNames(context);
                if (res != null) {
                    String path;
                    FileObject[] files = ActionProviderSupport.findSources(sourceRoots.getRoots(), context.getActiveLookup());
                    String classes = "";
                    if (files != null) {
                        path = FileUtil.getRelativePath((FileObject)ActionProviderSupport.getRoot(sourceRoots.getRoots(), files[0]), (FileObject)files[0]);
                        res = new String[]{"debug-fix"};
                        classes = this.getTopLevelClasses(files[0]);
                    } else {
                        files = ActionProviderSupport.findTestSources(sourceRoots.getRoots(), testRoots.getRoots(), context.getActiveLookup(), false);
                        assert (files != null) : "findTestSources () can't be null: " + Arrays.toString(testRoots.getRoots());
                        path = FileUtil.getRelativePath((FileObject)ActionProviderSupport.getRoot(testRoots.getRoots(), files[0]), (FileObject)files[0]);
                        res = new String[]{"debug-fix-test"};
                    }
                    if (path.endsWith(".java")) {
                        path = path.substring(0, path.length() - 5);
                    }
                    context.setProperty("fix.includes", path);
                    context.setProperty("fix.classes", classes);
                }
                return res;
            }

            private String getTopLevelClasses(FileObject file) {
                assert (file != null);
                String utfc = unitTestingSupport_fixClasses;
                if (utfc != null) {
                    return utfc;
                }
                String[] classes = new String[]{""};
                JavaSource js = JavaSource.forFileObject((FileObject)file);
                if (js != null) {
                    try {
                        js.runUserActionTask(ci -> {
                            if (ci.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED).compareTo((Enum)JavaSource.Phase.ELEMENTS_RESOLVED) < 0) {
                                LOG.log(Level.WARNING, "Unable to resolve {0} to phase {1}, current phase = {2}\nDiagnostics = {3}\nFree memory = {4}", new Object[]{ci.getFileObject(), JavaSource.Phase.RESOLVED, ci.getPhase(), ci.getDiagnostics(), Runtime.getRuntime().freeMemory()});
                                return;
                            }
                            List types = ci.getTopLevelElements();
                            if (types.size() > 0) {
                                for (TypeElement type : types) {
                                    if (classes[0].length() > 0) {
                                        classes[0] = classes[0] + " ";
                                    }
                                    classes[0] = classes[0] + type.getQualifiedName().toString().replace('.', '/') + "*.class";
                                }
                            }
                        }, true);
                    }
                    catch (IOException ioex) {
                        Exceptions.printStackTrace((Throwable)ioex);
                    }
                }
                return classes[0];
            }
        };
    }

    @NonNull
    private static ScriptAction createRunAction(final @NonNull String command, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, @NonNull Supplier<? extends String[]> targets, final @NonNull ActionProviderSupport.ModifiedFilesSupport mfs, final @NonNull Object[] mainClassServices) {
        return new BaseScriptAction(command, true, javaModelSensitive, scanSensitive, enabledInCoS, targets){

            @Override
            public String[] getTargetNames(Context context) {
                String[] targets = super.getTargetNames(context);
                if (targets != null) {
                    String[] cfgTargets;
                    String includes;
                    boolean hasCfg = context.getActiveLookup().lookup(ProjectConfiguration.class) != null;
                    boolean verifyMain = context.doJavaChecks() && !hasCfg && ActionProviderSupport.getJavaMainAction(context.getPropertyEvaluator()) == null;
                    String mainClass = (String)((Function)mainClassServices[0]).apply(verifyMain);
                    if (mainClass == null) {
                        do {
                            if (!((Boolean)((Supplier)mainClassServices[1]).get()).booleanValue()) {
                                return null;
                            }
                            mainClass = context.getPropertyEvaluator().getProperty("main.class");
                        } while ((mainClass = (String)((Function)mainClassServices[0]).apply(verifyMain)) == null);
                    }
                    if (mainClass != null) {
                        switch (command) {
                            case "profile": {
                                context.setProperty("run.class", mainClass);
                                break;
                            }
                            case "debug": 
                            case "debug.stepinto": {
                                context.setProperty("debug.class", mainClass);
                            }
                        }
                    }
                    if ((includes = mfs.prepareDirtyList(false)) != null) {
                        context.setProperty("includes", includes);
                    }
                    if ((cfgTargets = ActionProviderSupport.loadTargetsFromConfig(context.getProject(), context.getPropertyEvaluator()).get(command)) != null) {
                        targets = cfgTargets;
                    }
                }
                return targets;
            }

            @Override
            public ScriptAction.Result performCompileOnSave(Context context, String[] targetNames) {
                Map<String, Object> execProperties = ActionProviderSupport.createBaseCoSProperties(context);
                ActionProviderSupport.prepareSystemProperties(context, execProperties, false);
                AtomicReference<ExecutorTask> _task = new AtomicReference<ExecutorTask>();
                ActionProviderSupport.bypassAntBuildScript(context, execProperties, EMPTY, EMPTY, _task, this.getCoSInterceptor());
                ExecutorTask t = _task.get();
                return t == null ? ScriptAction.Result.abort() : ScriptAction.Result.success(t);
            }
        };
    }

    @NonNull
    private static ScriptAction createNonCosAction(String command, boolean platformSensitive, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, @NonNull Supplier<? extends String[]> targets, @NonNull Map<String, String> props) {
        return new BaseScriptAction(command, platformSensitive, javaModelSensitive, scanSensitive, enabledInCoS, targets, props);
    }

    private static void logNoFiles(@NonNull SourceRoots sourceRoots, @NonNull SourceRoots testRoots, @NonNull Context context) {
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "Source Roots: {0} Test Roots: {1} Lookup Content: {2}", new Object[]{JavaActionProvider.asPath(sourceRoots.getRoots()), JavaActionProvider.asPath(testRoots.getRoots()), JavaActionProvider.asPath(context.getActiveLookup())});
        }
    }

    @NonNull
    private static CharSequence asPath(@NonNull Lookup context) {
        HashSet fos = new HashSet();
        context.lookupAll(DataObject.class).stream().map(DataObject::getPrimaryFile).forEach(fos::add);
        context.lookupAll(FileObject.class).stream().forEach(fos::add);
        return JavaActionProvider.asPath(fos.toArray(new FileObject[0]));
    }

    @NonNull
    private static CharSequence asPath(@NonNull FileObject[] fos) {
        if (fos == null) {
            return null;
        }
        return Arrays.stream(fos).map(FileUtil::getFileDisplayName).collect(Collectors.joining(File.pathSeparator));
    }

    public static interface Action {
        public String getCommand();

        public boolean isEnabled(@NonNull Context var1);

        public void invoke(@NonNull Context var1);
    }

    public static final class Builder {
        private final Project project;
        private final UpdateHelper updateHelper;
        private final PropertyEvaluator evaluator;
        private final SourceRoots sourceRoots;
        private final SourceRoots testRoots;
        private final List<Action> actions;
        private final ActionProviderSupport.ModifiedFilesSupport mfs;
        private final Function<String, ClassPath> classpaths;
        private volatile Object[] mainClassServices;
        private Supplier<? extends JavaPlatform> jpp;
        private BiFunction<String, Lookup, Map<String, String>> additionalPropertiesProvider;
        private BiFunction<String, Lookup, Set<String>> concealedPropertiesProvider;
        private Supplier<? extends Set<? extends CompileOnSaveOperation>> cosOpsProvider;

        private Builder(@NonNull Project project, @NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots, @NonNull Function<String, ClassPath> projectClassPaths) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            Parameters.notNull((CharSequence)"updateHelper", (Object)updateHelper);
            Parameters.notNull((CharSequence)"evaluator", (Object)evaluator);
            Parameters.notNull((CharSequence)"sourceRoots", (Object)sourceRoots);
            Parameters.notNull((CharSequence)"testSourceRoots", (Object)testSourceRoots);
            Parameters.notNull((CharSequence)"projectClassPaths", projectClassPaths);
            this.project = project;
            this.updateHelper = updateHelper;
            this.evaluator = evaluator;
            this.sourceRoots = sourceRoots;
            this.testRoots = testSourceRoots;
            this.actions = new ArrayList<Action>();
            this.jpp = this.createJavaPlatformProvider("platform.active");
            this.mfs = ActionProviderSupport.ModifiedFilesSupport.newInstance(project, updateHelper, evaluator);
            this.classpaths = projectClassPaths;
            Function<Boolean, String> pmcp = validate -> ActionProviderSupport.getProjectMainClass(project, evaluator, sourceRoots, this.classpaths, validate);
            Supplier<Boolean> mcc = () -> ActionProviderSupport.showCustomizer(project, updateHelper, evaluator, sourceRoots, this.classpaths);
            this.mainClassServices = new Object[]{pmcp, mcc};
        }

        @NonNull
        public Builder addAction(@NonNull Action action) {
            Parameters.notNull((CharSequence)"action", (Object)action);
            this.actions.add(action);
            return this;
        }

        @NonNull
        public Action createProjectOperation(String command) {
            return new SimpleAction(command, switch (command) {
                case "delete" -> ctx -> DefaultProjectOperations.performDefaultDeleteOperation((Project)ctx.getProject());
                case "move" -> ctx -> DefaultProjectOperations.performDefaultMoveOperation((Project)ctx.getProject());
                case "copy" -> ctx -> DefaultProjectOperations.performDefaultCopyOperation((Project)ctx.getProject());
                case "rename" -> ctx -> DefaultProjectOperations.performDefaultRenameOperation((Project)ctx.getProject(), null);
                default -> throw new IllegalArgumentException(command);
            });
        }

        @NonNull
        public ScriptAction createSimpleScriptAction(@NonNull String command, boolean requiresValidJavaPlatform, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, String ... targets) {
            Parameters.notNull((CharSequence)"targets", (Object)targets);
            return this.createSimpleScriptAction(command, requiresValidJavaPlatform, javaModelSensitive, scanSensitive, enabledInCoS, (Context ctx) -> true, () -> targets);
        }

        @NonNull
        public ScriptAction createSimpleScriptAction(@NonNull String command, boolean requiresValidJavaPlatform, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, final @NonNull Predicate<Context> enabled, @NonNull Supplier<? extends String[]> targets) {
            Parameters.notNull((CharSequence)"enabled", enabled);
            Parameters.notNull((CharSequence)"targets", targets);
            return new BaseScriptAction(command, requiresValidJavaPlatform, javaModelSensitive, scanSensitive, enabledInCoS, targets){

                @Override
                public boolean isEnabled(Context context) {
                    return super.isEnabled(context) && enabled.test(context);
                }
            };
        }

        @NonNull
        public ScriptAction createDefaultScriptAction(@NonNull String command, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, String ... targets) {
            Parameters.notNull((CharSequence)"targets", (Object)targets);
            return this.createDefaultScriptAction(command, javaModelSensitive, scanSensitive, enabledInCoS, () -> targets, null);
        }

        @NonNull
        public ScriptAction createDefaultScriptAction(@NonNull String command, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, @NonNull Supplier<? extends String[]> targets) {
            return this.createDefaultScriptAction(command, javaModelSensitive, scanSensitive, enabledInCoS, targets, null);
        }

        @NonNull
        public ScriptAction createDefaultScriptAction(@NonNull String command, boolean javaModelSensitive, boolean scanSensitive, boolean enabledInCoS, @NonNull Supplier<? extends String[]> targets, @NullAllowed CustomFileExecutor customFileExecutor) {
            Parameters.notNull((CharSequence)"command", (Object)command);
            Parameters.notNull((CharSequence)"targets", targets);
            switch (command) {
                case "clean": {
                    return JavaActionProvider.createNonCosAction(command, false, javaModelSensitive, scanSensitive, enabledInCoS, targets, Collections.emptyMap());
                }
                case "rebuild": {
                    return JavaActionProvider.createNonCosAction(command, true, javaModelSensitive, scanSensitive, enabledInCoS, targets, Collections.emptyMap());
                }
                case "build": {
                    return JavaActionProvider.createBuildAction(javaModelSensitive, scanSensitive, enabledInCoS, targets, this.mfs);
                }
                case "run": 
                case "debug": 
                case "debug.stepinto": 
                case "profile": {
                    return JavaActionProvider.createRunAction(command, javaModelSensitive, scanSensitive, enabledInCoS, targets, this.mfs, this.mainClassServices);
                }
                case "test": {
                    return JavaActionProvider.createNonCosAction(command, true, javaModelSensitive, scanSensitive, enabledInCoS, targets, Collections.singletonMap("ignore.failing.tests", "true"));
                }
                case "compile.single": {
                    return JavaActionProvider.createCompileSingleAction(javaModelSensitive, scanSensitive, enabledInCoS, this.sourceRoots, this.testRoots, targets);
                }
                case "run.single": 
                case "debug.single": 
                case "profile.single": {
                    return JavaActionProvider.createRunSingleAction(command, javaModelSensitive, scanSensitive, enabledInCoS, this.sourceRoots, this.testRoots, targets, customFileExecutor);
                }
                case "test.single": {
                    return JavaActionProvider.createTestSingleAction(javaModelSensitive, scanSensitive, enabledInCoS, this.sourceRoots, this.testRoots, targets);
                }
                case "debug.test.single": 
                case "profile.test.single": {
                    return JavaActionProvider.createDebugTestSingleAction(command, javaModelSensitive, scanSensitive, enabledInCoS, this.sourceRoots, this.testRoots, targets);
                }
                case "run.single.method": 
                case "debug.single.method": {
                    return JavaActionProvider.createRunSingleMethodAction(command, javaModelSensitive, scanSensitive, enabledInCoS, this.testRoots, targets);
                }
                case "debug.fix": {
                    return JavaActionProvider.createDebugFixAction(command, javaModelSensitive, scanSensitive, enabledInCoS, this.sourceRoots, this.testRoots, targets);
                }
            }
            throw new UnsupportedOperationException(String.format("Unsupported command: %s", command));
        }

        @NonNull
        public Builder setActivePlatformProperty(@NonNull String activePlatformProperty) {
            Parameters.notNull((CharSequence)"activePlatformProperty", (Object)activePlatformProperty);
            this.jpp = this.createJavaPlatformProvider(activePlatformProperty);
            return this;
        }

        @NonNull
        public Builder setActivePlatformProvider(@NonNull Supplier<? extends JavaPlatform> javaPlatformProvider) {
            Parameters.notNull((CharSequence)"javaPlatformProvider", javaPlatformProvider);
            this.jpp = javaPlatformProvider;
            return this;
        }

        @NonNull
        public Builder setCompileOnSaveOperationsProvider(@NonNull Supplier<? extends Set<? extends CompileOnSaveOperation>> cosOpsProvider) {
            Parameters.notNull((CharSequence)"cosOpsProvider", cosOpsProvider);
            this.cosOpsProvider = cosOpsProvider;
            return this;
        }

        @NonNull
        public Builder setProjectMainClassProvider(@NonNull Function<Boolean, String> mainClassProvider) {
            Parameters.notNull((CharSequence)"mainClassProvider", mainClassProvider);
            this.mainClassServices[0] = mainClassProvider;
            this.mainClassServices = this.mainClassServices;
            return this;
        }

        @NonNull
        public Builder setProjectMainClassSelector(@NonNull Supplier<Boolean> selectMainClassAction) {
            Parameters.notNull((CharSequence)"selectMainClassAction", selectMainClassAction);
            this.mainClassServices[1] = selectMainClassAction;
            this.mainClassServices = this.mainClassServices;
            return this;
        }

        @NonNull
        public Builder setAdditionalPropertiesProvider(@NonNull BiFunction<String, Lookup, Map<String, String>> additionalPropertiesProvider) {
            Parameters.notNull((CharSequence)"additionalPropertiesProvider", additionalPropertiesProvider);
            this.additionalPropertiesProvider = additionalPropertiesProvider;
            return this;
        }

        @NonNull
        public Builder setConcealedPropertiesProvider(@NonNull BiFunction<String, Lookup, Set<String>> concealedPropertiesProvider) {
            Parameters.notNull((CharSequence)"concealedPropertiesProvider", concealedPropertiesProvider);
            this.concealedPropertiesProvider = concealedPropertiesProvider;
            return this;
        }

        @NonNull
        public JavaActionProvider build() {
            JavaActionProvider ap = new JavaActionProvider(this.project, this.updateHelper, this.evaluator, this.classpaths, this.actions, this.jpp, this.additionalPropertiesProvider, this.concealedPropertiesProvider, this.cosOpsProvider, this.mfs);
            this.mfs.start();
            return ap;
        }

        @NonNull
        private Supplier<? extends JavaPlatform> createJavaPlatformProvider(@NonNull String activePlatformProperty) {
            return () -> ActionProviderSupport.getActivePlatform(this.project, this.evaluator, activePlatformProperty);
        }

        @NonNull
        public static Builder newInstance(@NonNull Project project, @NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator evaluator, @NonNull SourceRoots sourceRoots, @NonNull SourceRoots testSourceRoots, @NonNull Function<String, ClassPath> projectClassPaths) {
            return new Builder(project, updateHelper, evaluator, sourceRoots, testSourceRoots, projectClassPaths);
        }

        public static interface CustomFileExecutor {
            @CheckForNull
            public String[] getTargetNames(@NonNull FileObject var1, @NonNull Context var2);

            @NonNull
            default public ScriptAction.Result performCompileOnSave(@NonNull Context context, @NonNull String[] targetNames) {
                return ScriptAction.Result.follow();
            }
        }
    }

    private static class BaseScriptAction
    extends ScriptAction {
        private final Supplier<? extends String[]> targetNames;
        private final Map<String, String> initialProps;

        BaseScriptAction(@NonNull String command, boolean ps, boolean jms, boolean sc, boolean cos, Supplier<? extends String[]> targetNames) {
            this(command, ps, jms, sc, cos, targetNames, Collections.emptyMap());
        }

        BaseScriptAction(@NonNull String command, boolean ps, boolean jms, boolean sc, boolean cos, @NonNull Supplier<? extends String[]> targetNames, @NonNull Map<String, String> initialProps) {
            super(command, null, ps, jms, sc, cos);
            this.targetNames = targetNames;
            this.initialProps = initialProps;
        }

        @Override
        public String[] getTargetNames(Context context) {
            for (Map.Entry<String, String> e : this.initialProps.entrySet()) {
                context.setProperty(e.getKey(), e.getValue());
            }
            return this.targetNames.get();
        }
    }

    public static final class Context {
        private final Project project;
        private final UpdateHelper updateHelper;
        private final PropertyEvaluator eval;
        private final Function<String, ClassPath> classpaths;
        private final String command;
        private final Lookup lkp;
        private boolean doJavaChecks;
        private Set<? extends CompileOnSaveOperation> cosOpsCache;
        private ActionProviderSupport.UserPropertiesPolicy userPropertiesPolicy;
        private final Supplier<? extends JavaPlatform> jpp;
        private final BiFunction<String, Lookup, Map<String, String>> additionalPropertiesProvider;
        private final BiFunction<String, Lookup, Set<String>> concealedPropertiesProvider;
        private final Supplier<? extends Set<? extends CompileOnSaveOperation>> cosOpsProvider;
        private final Collection<? extends AntTargetInvocationListener> listeners;
        private final Properties properties;
        private final Set<String> concealedProperties;

        Context(@NonNull Project project, @NonNull UpdateHelper updateHelper, @NonNull PropertyEvaluator eval, @NonNull Function<String, ClassPath> classpaths, @NonNull String command, @NonNull Lookup lookup, @NullAllowed ActionProviderSupport.UserPropertiesPolicy userPropertiesPolicy, @NullAllowed Supplier<? extends JavaPlatform> jpp, @NullAllowed BiFunction<String, Lookup, Map<String, String>> additionalPropertiesProvider, @NullAllowed BiFunction<String, Lookup, Set<String>> concealedPropertiesProvider, @NonNull Supplier<? extends Set<? extends CompileOnSaveOperation>> cosOpsProvider, @NonNull Collection<? extends AntTargetInvocationListener> listeners) {
            this.project = project;
            this.updateHelper = updateHelper;
            this.eval = eval;
            this.classpaths = classpaths;
            this.command = command;
            this.lkp = lookup;
            this.doJavaChecks = true;
            this.userPropertiesPolicy = userPropertiesPolicy;
            this.jpp = jpp;
            this.additionalPropertiesProvider = additionalPropertiesProvider;
            this.concealedPropertiesProvider = concealedPropertiesProvider;
            this.cosOpsProvider = cosOpsProvider;
            this.listeners = listeners;
            this.properties = new Properties();
            this.concealedProperties = new HashSet<String>();
        }

        @NonNull
        public String getCommand() {
            return this.command;
        }

        @NonNull
        public Lookup getActiveLookup() {
            return this.lkp;
        }

        @NonNull
        public Project getProject() {
            return this.project;
        }

        @NonNull
        public UpdateHelper getUpdateHelper() {
            return this.updateHelper;
        }

        @NonNull
        public PropertyEvaluator getPropertyEvaluator() {
            return this.eval;
        }

        @CheckForNull
        public JavaPlatform getActiveJavaPlatform() {
            return Optional.ofNullable(this.jpp).map(p -> (JavaPlatform)p.get()).orElse(null);
        }

        public boolean doJavaChecks() {
            return this.doJavaChecks;
        }

        @NonNull
        public Set<? extends CompileOnSaveOperation> getCompileOnSaveOperations() {
            Set<? extends CompileOnSaveOperation> res = this.cosOpsCache;
            if (res == null) {
                res = this.cosOpsCache = this.cosOpsProvider.get();
            }
            return res;
        }

        @CheckForNull
        public ClassPath getProjectClassPath(@NonNull String classPathId) {
            return this.classpaths.apply(classPathId);
        }

        @CheckForNull
        public String getProperty(@NonNull String propName) {
            return this.properties.getProperty(propName);
        }

        public void setProperty(@NonNull String propName, @NonNull String propValue) {
            Parameters.notNull((CharSequence)"propName", (Object)propName);
            Parameters.notNull((CharSequence)"propValue", (Object)propValue);
            this.properties.put(propName, propValue);
        }

        public void addConcealedProperty(@NonNull String propName) {
            Parameters.notNull((CharSequence)"propName", (Object)propName);
            this.concealedProperties.add(propName);
        }

        void removeProperty(@NonNull String propName) {
            this.properties.remove(propName);
        }

        void setJavaChecks(boolean doJavaChecks) {
            this.doJavaChecks = doJavaChecks;
        }

        @CheckForNull
        ActionProviderSupport.UserPropertiesPolicy getUserPropertiesPolicy() {
            return this.userPropertiesPolicy;
        }

        void setUserPropertiesPolicy(@NullAllowed ActionProviderSupport.UserPropertiesPolicy p) {
            this.userPropertiesPolicy = p;
        }

        void fireAntTargetInvocationListener(int state, int res) {
            block5: for (AntTargetInvocationListener antTargetInvocationListener : this.listeners) {
                switch (state) {
                    case 0: {
                        antTargetInvocationListener.antTargetInvocationStarted(this.command, this.lkp);
                        continue block5;
                    }
                    case 1: {
                        antTargetInvocationListener.antTargetInvocationFinished(this.command, this.lkp, res);
                        continue block5;
                    }
                    case 2: {
                        antTargetInvocationListener.antTargetInvocationFailed(this.command, this.lkp);
                        continue block5;
                    }
                }
                throw new IllegalArgumentException(Integer.toString(state));
            }
        }

        @CheckForNull
        Properties getProperties() {
            Optional.ofNullable(this.additionalPropertiesProvider).map(p -> (Map)p.apply(this.getCommand(), this.getActiveLookup())).ifPresent(this.properties::putAll);
            return this.properties.keySet().isEmpty() ? null : this.properties;
        }

        @CheckForNull
        Set<String> getConcealedProperties() {
            Optional.ofNullable(this.concealedPropertiesProvider).map(p -> (Set)p.apply(this.getCommand(), this.getActiveLookup())).ifPresent(this.concealedProperties::addAll);
            return this.concealedProperties.isEmpty() ? null : this.concealedProperties;
        }

        @CheckForNull
        Set<String> copyAdditionalProperties(@NonNull Map<String, Object> into) {
            Optional.ofNullable(this.additionalPropertiesProvider).map(p -> (Map)p.apply(this.getCommand(), this.getActiveLookup())).ifPresent(into::putAll);
            HashSet<String> cps = new HashSet<String>(this.concealedProperties);
            Optional.ofNullable(this.concealedPropertiesProvider).map(p -> (Set)p.apply(this.getCommand(), this.getActiveLookup())).ifPresent(cps::addAll);
            return cps.isEmpty() ? null : cps;
        }
    }

    private static class BaseRunSingleAction
    extends BaseScriptAction {
        private final SourceRoots sourceRoots;
        private final SourceRoots testRoots;

        BaseRunSingleAction(@NonNull String command, boolean ps, boolean jms, boolean sc, boolean cos, SourceRoots sourceRoots, SourceRoots testRoots, Supplier<? extends String[]> targetNames) {
            super(command, ps, jms, sc, cos, targetNames);
            this.sourceRoots = sourceRoots;
            this.testRoots = testRoots;
        }

        @Override
        public ScriptAction.Result performCompileOnSave(Context context, String[] targetNames) {
            if (Arrays.equals(targetNames, new String[]{"test"})) {
                return ScriptAction.Result.follow();
            }
            String command = context.getCommand();
            Map<String, Object> execProperties = ActionProviderSupport.createBaseCoSProperties(context);
            if ("run.single".equals(command) || "debug.single".equals(command) || "profile.single".equals(command)) {
                ActionProviderSupport.prepareSystemProperties(context, execProperties, false);
                switch (command) {
                    case "run.single": {
                        execProperties.put("classname", context.getProperty("run.class"));
                        break;
                    }
                    case "debug.single": {
                        execProperties.put("classname", context.getProperty("debug.class"));
                        break;
                    }
                    case "profile.single": {
                        execProperties.put("classname", context.getProperty("profile.class"));
                        break;
                    }
                    default: {
                        throw new IllegalStateException(command);
                    }
                }
                AtomicReference<ExecutorTask> _task = new AtomicReference<ExecutorTask>();
                ActionProviderSupport.bypassAntBuildScript(context, execProperties, this.sourceRoots.getRoots(), this.testRoots.getRoots(), _task, this.getCoSInterceptor());
                ExecutorTask t = _task.get();
                return t == null ? ScriptAction.Result.abort() : ScriptAction.Result.success(t);
            }
            if ("test.single".equals(command) || "debug.test.single".equals(command) || "profile.test.single".equals(command)) {
                FileObject[] files = ActionProviderSupport.findTestSources(this.sourceRoots.getRoots(), this.testRoots.getRoots(), context.getActiveLookup(), true);
                try {
                    ActionProviderSupport.prepareSystemProperties(context, execProperties, true);
                    execProperties.put("execute.file", files[0]);
                    String buildDir = context.getPropertyEvaluator().getProperty("build.dir");
                    if (buildDir != null) {
                        context.setProperty("tmp.dir", context.getUpdateHelper().getAntProjectHelper().resolvePath(buildDir));
                    }
                    boolean vote = true;
                    BiFunction<Context, Map<String, Object>, Boolean> cosi = this.getCoSInterceptor();
                    if (cosi != null) {
                        vote = cosi.apply(context, execProperties);
                    }
                    if (vote) {
                        return ScriptAction.Result.success(JavaRunner.execute((String)(command.equals("test.single") ? "junit" : ("debug.test.single".equals(command) ? "junit-debug" : "junit-profile")), execProperties));
                    }
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
                return ScriptAction.Result.abort();
            }
            assert (false) : "Unhandled command:" + command;
            return ScriptAction.Result.follow();
        }

        @NonNull
        final SourceRoots getSourceRoots() {
            return this.sourceRoots;
        }

        @NonNull
        final SourceRoots getTestRoots() {
            return this.testRoots;
        }
    }

    private static final class SimpleAction
    implements Action {
        private final String name;
        private final Consumer<? super Context> performer;

        SimpleAction(@NonNull String name, Consumer<? super Context> performer) {
            Parameters.notNull((CharSequence)"name", (Object)name);
            Parameters.notNull((CharSequence)"performer", performer);
            this.name = name;
            this.performer = performer;
        }

        @Override
        @NonNull
        public final String getCommand() {
            return this.name;
        }

        @Override
        public boolean isEnabled(@NonNull Context context) {
            return true;
        }

        @Override
        public void invoke(@NonNull Context context) {
            this.performer.accept(context);
        }
    }

    public static abstract class ScriptAction
    implements Action {
        private final String command;
        private final String displayName;
        private final Set<ActionProviderSupport.ActionFlag> actionFlags;
        private volatile BiFunction<Context, Map<String, Object>, Boolean> cosInterceptor;

        protected ScriptAction(@NonNull String command, @NullAllowed String dispalyName, boolean platformSensitive, boolean javaModelSensitive, boolean scanSensitive, boolean cosEnabled) {
            Parameters.notNull((CharSequence)"command", (Object)command);
            this.command = command;
            this.displayName = dispalyName;
            this.actionFlags = EnumSet.noneOf(ActionProviderSupport.ActionFlag.class);
            if (platformSensitive) {
                this.actionFlags.add(ActionProviderSupport.ActionFlag.PLATFORM_SENSITIVE);
            }
            if (javaModelSensitive) {
                this.actionFlags.add(ActionProviderSupport.ActionFlag.JAVA_MODEL_SENSITIVE);
            }
            if (scanSensitive) {
                this.actionFlags.add(ActionProviderSupport.ActionFlag.SCAN_SENSITIVE);
            }
            if (cosEnabled) {
                this.actionFlags.add(ActionProviderSupport.ActionFlag.COS_ENABLED);
            }
        }

        @CheckForNull
        public abstract String[] getTargetNames(@NonNull Context var1);

        @NonNull
        public Result performCompileOnSave(@NonNull Context context, @NonNull String[] targetNames) {
            return Result.follow();
        }

        @Override
        public boolean isEnabled(Context context) {
            return this.actionFlags.contains((Object)ActionProviderSupport.ActionFlag.COS_ENABLED) || context.getCompileOnSaveOperations().isEmpty() || ActionProviderSupport.allowAntBuild(context.getPropertyEvaluator(), context.getUpdateHelper());
        }

        @Override
        public final String getCommand() {
            return this.command;
        }

        @Override
        public final void invoke(@NonNull Context context) {
            if (this.actionFlags.contains((Object)ActionProviderSupport.ActionFlag.PLATFORM_SENSITIVE) && context.getActiveJavaPlatform() == null) {
                ActionProviderSupport.showPlatformWarning(context.getProject());
                return;
            }
            ActionProviderSupport.invokeTarget(this, context);
        }

        @NonNull
        final String getDisplayName() {
            String res = this.displayName;
            if (res == null) {
                res = ScriptAction.getCommandDisplayName(this.command);
            }
            return res;
        }

        @NonNull
        final Set<ActionProviderSupport.ActionFlag> getActionFlags() {
            return this.actionFlags;
        }

        @CheckForNull
        final BiFunction<Context, Map<String, Object>, Boolean> getCoSInterceptor() {
            return this.cosInterceptor;
        }

        final void setCoSInterceptor(@NullAllowed BiFunction<Context, Map<String, Object>, Boolean> cosInterceptor) {
            this.cosInterceptor = cosInterceptor;
        }

        private static String getCommandDisplayName(String command) throws MissingResourceException {
            if (command.equals("run")) {
                return Bundle.ACTION_run();
            }
            if (command.equals("run.single")) {
                return Bundle.ACTION_run_single();
            }
            if (command.equals("run.single.method")) {
                return Bundle.ACTION_run_single_method();
            }
            if (command.equals("debug")) {
                return Bundle.ACTION_debug();
            }
            if (command.equals("debug.single")) {
                return Bundle.ACTION_debug_single();
            }
            if (command.equals("debug.single.method")) {
                return Bundle.ACTION_debug_single_method();
            }
            if (command.equals("debug.stepinto")) {
                return Bundle.ACTION_debug_stepinto();
            }
            if (command.equals("debug.fix")) {
                return Bundle.ACTION_debug_fix();
            }
            if (command.equals("debug.test.single")) {
                return Bundle.ACTION_debug_test_single();
            }
            if (command.equals("profile")) {
                return Bundle.ACTION_profile();
            }
            if (command.equals("profile.single")) {
                return Bundle.ACTION_profile_single();
            }
            if (command.equals("profile.test.single")) {
                return Bundle.ACTION_profile_test_single();
            }
            if (command.equals("rebuild")) {
                return Bundle.ACTION_rebuild();
            }
            if (command.equals("build")) {
                return Bundle.ACTION_build();
            }
            if (command.equals("clean")) {
                return Bundle.ACTION_clean();
            }
            if (command.equals("compile.single")) {
                return Bundle.ACTION_compile_single();
            }
            if (command.equals("javadoc")) {
                return Bundle.ACTION_javadoc();
            }
            if (command.equals("test")) {
                return Bundle.ACTION_test();
            }
            if (command.equals("test.single")) {
                return Bundle.ACTION_test_single();
            }
            return command;
        }

        public static final class Result {
            private static final Result ABORT = new Result(null);
            private static final Result FOLLOW = new Result(null);
            private final ExecutorTask task;

            private Result(@NullAllowed ExecutorTask task) {
                this.task = task;
            }

            ExecutorTask getTask() {
                return this.task;
            }

            @NonNull
            public static Result success(@NonNull ExecutorTask task) {
                Parameters.notNull((CharSequence)"task", (Object)task);
                return new Result(task);
            }

            @NonNull
            public static Result abort() {
                return ABORT;
            }

            @NonNull
            public static Result follow() {
                return FOLLOW;
            }
        }
    }

    public static interface AntTargetInvocationListener
    extends EventListener {
        public void antTargetInvocationStarted(String var1, Lookup var2);

        public void antTargetInvocationFinished(String var1, Lookup var2, int var3);

        public void antTargetInvocationFailed(String var1, Lookup var2);
    }

    public static enum CompileOnSaveOperation {
        UPDATE,
        EXECUTE;

    }
}

