/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.libraries;

import javax.swing.event.ChangeListener;
import org.netbeans.spi.project.libraries.LibraryTypeProvider;
import org.openide.util.ChangeSupport;
import org.openide.util.Lookup;

public abstract class LibraryTypeRegistry {
    private static LibraryTypeRegistry instance;
    private final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    protected LibraryTypeRegistry() {
    }

    public abstract LibraryTypeProvider[] getLibraryTypeProviders();

    public final LibraryTypeProvider getLibraryTypeProvider(String libraryType) {
        LibraryTypeProvider[] providers;
        assert (libraryType != null);
        for (LibraryTypeProvider provider : providers = this.getLibraryTypeProviders()) {
            if (!libraryType.equals(provider.getLibraryType())) continue;
            return provider;
        }
        return null;
    }

    public final void addChangeListener(ChangeListener listener) {
        assert (listener != null);
        this.changeSupport.addChangeListener(listener);
    }

    public final void removeChangeListener(ChangeListener listener) {
        assert (listener != null);
        this.changeSupport.removeChangeListener(listener);
    }

    protected final void fireChange() {
        this.changeSupport.fireChange();
    }

    public static synchronized LibraryTypeRegistry getDefault() {
        if (instance == null && (instance = (LibraryTypeRegistry)Lookup.getDefault().lookup(LibraryTypeRegistry.class)) == null) {
            throw new IllegalStateException("No LibraryTypeRegistry in default Lookup");
        }
        return instance;
    }
}

