/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javafx2.editor;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenId;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.csl.api.CompletionProposal;

public final class JavaFXEditorUtils {
    public static final String FXML_FX_NAMESPACE = "http://javafx.com/fxml";
    public static final String FXML_FX_NAMESPACE_CURRENT = "http://javafx.com/fxml/1";
    public static final String FXML_FX_PREFIX = "fx";
    public static final String FXML_MIME_TYPE = "text/x-fxml+xml";
    public static final String FXML_FILE_EXTENSION = "fxml";
    public static final String JAVA_MIME_TYPE = "text/x-java";
    public static final String FXML_NODE_CLASS = "javafx.scene.Node";

    private JavaFXEditorUtils() {
    }

    public static List<CompletionProposal> filterCompletionProposals(List<CompletionProposal> proposals, CharSequence prefix, boolean ignoreCase) {
        ArrayList<CompletionProposal> filtered = new ArrayList<CompletionProposal>();
        for (CompletionProposal proposal : proposals) {
            if (!JavaFXEditorUtils.startsWith(proposal.getInsertPrefix(), prefix, ignoreCase, false)) continue;
            filtered.add(proposal);
        }
        return filtered;
    }

    public static boolean startsWith(CharSequence text1, CharSequence prefix, boolean ignoreCase, boolean optimized) {
        if (text1.length() < prefix.length()) {
            return false;
        }
        return JavaFXEditorUtils.equals(text1.subSequence(0, prefix.length()), prefix, ignoreCase, optimized);
    }

    public static boolean equals(CharSequence text1, CharSequence text2, boolean ignoreCase, boolean optimized) {
        if (text1.length() != text2.length()) {
            return false;
        }
        for (int i = 0; i < text1.length(); ++i) {
            char ch2;
            char ch1 = ignoreCase && !optimized ? Character.toLowerCase(text1.charAt(i)) : text1.charAt(i);
            char c = ch2 = ignoreCase ? Character.toLowerCase(text2.charAt(i)) : text2.charAt(i);
            if (ch1 == ch2) continue;
            return false;
        }
        return true;
    }

    public static Token followsToken(TokenSequence ts, Collection<? extends TokenId> searchedIds, boolean backwards, boolean repositionBack, TokenId ... skipIds) {
        List<TokenId> skip = Arrays.asList(skipIds);
        int index = ts.index();
        while (backwards ? ts.movePrevious() : ts.moveNext()) {
            Token token = ts.token();
            TokenId id = token.id();
            if (searchedIds.contains(id)) {
                if (repositionBack) {
                    int idx = ts.moveIndex(index);
                    boolean moved = ts.moveNext();
                    assert (idx == 0 && moved);
                }
                return token;
            }
            if (skip.contains(id)) continue;
            break;
        }
        return null;
    }
}

