/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.css.editor.csl;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.csl.api.ColoringAttributes;
import org.netbeans.modules.csl.api.OccurrencesFinder;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.css.editor.module.CssModuleSupport;
import org.netbeans.modules.css.editor.module.spi.EditorFeatureContext;
import org.netbeans.modules.css.editor.module.spi.FeatureCancel;
import org.netbeans.modules.css.lib.api.CssParserResult;
import org.netbeans.modules.parsing.spi.Parser;
import org.netbeans.modules.parsing.spi.Scheduler;
import org.netbeans.modules.parsing.spi.SchedulerEvent;

public class CssOccurrencesFinder
extends OccurrencesFinder {
    private int caretDocumentPosition;
    private Map<OffsetRange, ColoringAttributes> occurrencesMap = Collections.emptyMap();
    private FeatureCancel featureCancel = new FeatureCancel();

    public void setCaretPosition(int position) {
        this.caretDocumentPosition = position;
    }

    public Map<OffsetRange, ColoringAttributes> getOccurrences() {
        return this.occurrencesMap;
    }

    public void cancel() {
        if (this.featureCancel != null) {
            this.featureCancel.cancel();
        }
    }

    private void resume() {
        this.featureCancel = new FeatureCancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(Parser.Result result, SchedulerEvent event) {
        this.resume();
        try {
            CssParserResult parserResultWrapper = (CssParserResult)result;
            EditorFeatureContext context = new EditorFeatureContext(parserResultWrapper, this.caretDocumentPosition);
            Set<OffsetRange> occurrences = CssModuleSupport.getMarkOccurrences(context, this.featureCancel);
            if (this.featureCancel.isCancelled()) {
                return;
            }
            HashMap<OffsetRange, ColoringAttributes> occurrencesMapLocal = new HashMap<OffsetRange, ColoringAttributes>();
            for (OffsetRange range : occurrences) {
                occurrencesMapLocal.put(range, ColoringAttributes.MARK_OCCURRENCES);
            }
            this.occurrencesMap = occurrencesMapLocal;
        }
        finally {
            this.featureCancel = null;
        }
    }

    public int getPriority() {
        return 20;
    }

    public Class<? extends Scheduler> getSchedulerClass() {
        return null;
    }
}

