/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.objectstorage.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.objectstorage.model.SSECustomerKeyDetails;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class ReencryptObjectDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="sseCustomerKey")
    private final SSECustomerKeyDetails sseCustomerKey;
    @JsonProperty(value="sourceSseCustomerKey")
    private final SSECustomerKeyDetails sourceSseCustomerKey;

    @Deprecated
    @ConstructorProperties(value={"kmsKeyId", "sseCustomerKey", "sourceSseCustomerKey"})
    public ReencryptObjectDetails(String kmsKeyId, SSECustomerKeyDetails sseCustomerKey, SSECustomerKeyDetails sourceSseCustomerKey) {
        this.kmsKeyId = kmsKeyId;
        this.sseCustomerKey = sseCustomerKey;
        this.sourceSseCustomerKey = sourceSseCustomerKey;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public SSECustomerKeyDetails getSseCustomerKey() {
        return this.sseCustomerKey;
    }

    public SSECustomerKeyDetails getSourceSseCustomerKey() {
        return this.sourceSseCustomerKey;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("ReencryptObjectDetails(");
        sb.append("super=").append(super.toString());
        sb.append("kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", sseCustomerKey=").append(String.valueOf((Object)this.sseCustomerKey));
        sb.append(", sourceSseCustomerKey=").append(String.valueOf((Object)this.sourceSseCustomerKey));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ReencryptObjectDetails)) {
            return false;
        }
        ReencryptObjectDetails other = (ReencryptObjectDetails)((Object)o);
        return Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals((Object)this.sseCustomerKey, (Object)other.sseCustomerKey) && Objects.equals((Object)this.sourceSseCustomerKey, (Object)other.sourceSseCustomerKey) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.sseCustomerKey == null ? 43 : this.sseCustomerKey.hashCode());
        result = result * 59 + (this.sourceSseCustomerKey == null ? 43 : this.sourceSseCustomerKey.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="sseCustomerKey")
        private SSECustomerKeyDetails sseCustomerKey;
        @JsonProperty(value="sourceSseCustomerKey")
        private SSECustomerKeyDetails sourceSseCustomerKey;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder sseCustomerKey(SSECustomerKeyDetails sseCustomerKey) {
            this.sseCustomerKey = sseCustomerKey;
            this.__explicitlySet__.add("sseCustomerKey");
            return this;
        }

        public Builder sourceSseCustomerKey(SSECustomerKeyDetails sourceSseCustomerKey) {
            this.sourceSseCustomerKey = sourceSseCustomerKey;
            this.__explicitlySet__.add("sourceSseCustomerKey");
            return this;
        }

        public ReencryptObjectDetails build() {
            ReencryptObjectDetails model = new ReencryptObjectDetails(this.kmsKeyId, this.sseCustomerKey, this.sourceSseCustomerKey);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(ReencryptObjectDetails model) {
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("sseCustomerKey")) {
                this.sseCustomerKey(model.getSseCustomerKey());
            }
            if (model.wasPropertyExplicitlySet("sourceSseCustomerKey")) {
                this.sourceSseCustomerKey(model.getSourceSseCustomerKey());
            }
            return this;
        }
    }
}

