/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.xml.text.indent;

import java.util.regex.Pattern;
import javax.swing.text.BadLocationException;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Syntax;
import org.netbeans.editor.TokenItem;
import org.netbeans.editor.ext.AbstractFormatLayer;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.editor.ext.FormatLayer;
import org.netbeans.editor.ext.FormatSupport;
import org.netbeans.editor.ext.FormatTokenPosition;
import org.netbeans.editor.ext.FormatWriter;
import org.netbeans.modules.editor.structure.formatting.TagBasedFormatter;
import org.netbeans.modules.xml.text.indent.XMLFormatSupport;
import org.netbeans.modules.xml.text.syntax.XMLSyntaxSupport;
import org.netbeans.modules.xml.text.syntax.XMLTokenIDs;
import org.netbeans.modules.xml.text.syntax.javacc.lib.JJEditorSyntax;

public class XMLFormatter
extends TagBasedFormatter {
    private static final String TAG_OPENING_PREFIX = "<";
    private static final String TAG_CLOSING_PREFIX = "</";
    private static final String TAG_CLOSED_SUFFIX = "/>";
    private static final String TAG_CLOSING_SUFFIX = "/>";
    private static final Pattern VALID_TAG_NAME = Pattern.compile("[\\w+|-]*");
    private static final int WORKUNITS_MAX = 100;

    public XMLFormatter(Class kitClass) {
        super(kitClass);
    }

    public FormatSupport createFormatSupport(FormatWriter fw) {
        return new XMLFormatSupport(fw);
    }

    protected boolean acceptSyntax(Syntax syntax) {
        return syntax instanceof JJEditorSyntax;
    }

    protected void initFormatLayers() {
        this.addFormatLayer((FormatLayer)new StripEndWhitespaceLayer());
    }

    protected String extractTagName(TokenItem tknTag) {
        String tagImage = tknTag.getImage();
        int startIndex = -1;
        if (this.isOpeningTag(tknTag)) {
            startIndex = TAG_OPENING_PREFIX.length();
        } else if (this.isClosingTag(tknTag)) {
            startIndex = TAG_CLOSING_PREFIX.length();
        }
        if (startIndex >= 0) {
            String tagName = tagImage.substring(startIndex);
            return tagName;
        }
        return null;
    }

    protected boolean isOpeningTag(TokenItem token) {
        return token != null && token.getTokenID() == XMLTokenIDs.TAG && token.getImage().startsWith(TAG_OPENING_PREFIX) && !token.getImage().startsWith(TAG_CLOSING_PREFIX);
    }

    protected boolean isClosingTag(TokenItem token) {
        return token != null && token.getTokenID() == XMLTokenIDs.TAG && token.getImage().startsWith(TAG_CLOSING_PREFIX);
    }

    protected int getTagEndOffset(TokenItem token) {
        TokenItem t;
        for (t = token.getNext(); t != null && t.getTokenID() != XMLTokenIDs.TAG; t = t.getNext()) {
        }
        return t == null ? -1 : t.getOffset();
    }

    protected ExtSyntaxSupport getSyntaxSupport(BaseDocument doc) {
        return (XMLSyntaxSupport)doc.getSyntaxSupport().get(XMLSyntaxSupport.class);
    }

    protected boolean areTagNamesEqual(String tagName1, String tagName2) {
        return tagName1.equals(tagName2);
    }

    protected boolean isClosingTagRequired(BaseDocument doc, String tagName) {
        return true;
    }

    protected int getOpeningSymbolOffset(TokenItem tknTag) {
        return tknTag.getOffset();
    }

    protected TokenItem getTagTokenEndingAtPosition(BaseDocument doc, int position) throws BadLocationException {
        ExtSyntaxSupport sup;
        TokenItem token;
        if (position >= 0 && (token = (sup = this.getSyntaxSupport(doc)).getTokenChain(position, position + 1)).getTokenID() == XMLTokenIDs.TAG && token.getImage().equals(">")) {
            while ((token = token.getPrevious()) != null && !this.isOpeningTag(token) && !this.isClosingTag(token)) {
            }
            return token;
        }
        return null;
    }

    protected boolean isUnformattableToken(TokenItem token) {
        return token.getTokenID() == XMLTokenIDs.BLOCK_COMMENT || token.getTokenID() == XMLTokenIDs.CDATA_SECTION;
    }

    protected boolean isUnformattableTag(String tag) {
        return false;
    }

    public class StripEndWhitespaceLayer
    extends AbstractFormatLayer {
        public StripEndWhitespaceLayer() {
            super("xml-strip-whitespace-at-line-end-layer");
        }

        protected FormatSupport createFormatSupport(FormatWriter fw) {
            return new XMLFormatSupport(fw);
        }

        public void format(FormatWriter fw) {
            FormatTokenPosition pos;
            XMLFormatSupport xfs = (XMLFormatSupport)this.createFormatSupport(fw);
            if (xfs.isLineStart(pos = xfs.getFormatStartPosition()) && !xfs.isIndentOnly()) {
                while (pos.getToken() != null) {
                    if ((pos = xfs.removeLineEndWhitespace(pos)).getToken() == null) continue;
                    pos = xfs.getNextPosition(pos);
                }
            }
        }
    }
}

