/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.function;

import com.oracle.truffle.api.object.HiddenKey;
import com.oracle.truffle.js.runtime.array.ScriptArray;

public final class ClassElementDefinitionRecord {
    private static final Object[] EMPTY = new Object[0];
    private final Kind kind;
    private final Object key;
    private final boolean anonymousFunctionDefinition;
    private final boolean isPrivate;
    private Object value;
    private Object getter;
    private Object setter;
    private Object[] decorators;
    private Object[] initializers;
    private int initializersCount;
    private HiddenKey backingStorageKey;

    public static ClassElementDefinitionRecord createPublicField(Object key, Object value, boolean anonymousFunctionDefinition, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.Field, key, value, null, null, false, anonymousFunctionDefinition, decorators);
    }

    public static ClassElementDefinitionRecord createPrivateField(Object key, Object value, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.Field, key, value, null, null, true, false, decorators, (HiddenKey)key);
    }

    public static ClassElementDefinitionRecord createPublicMethod(Object key, Object value, boolean anonymousFunctionDefinition, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.Method, key, value, null, null, false, anonymousFunctionDefinition, decorators);
    }

    public static ClassElementDefinitionRecord createPrivateMethod(Object key, Object value, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.Method, key, value, null, null, true, false, decorators);
    }

    public static ClassElementDefinitionRecord createPublicGetter(Object key, Object getter, boolean anonymousFunctionDefinition, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.Getter, key, null, getter, null, false, anonymousFunctionDefinition, decorators);
    }

    public static ClassElementDefinitionRecord createPrivateGetter(Object key, Object getter, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.Getter, key, null, getter, null, true, false, decorators);
    }

    public static ClassElementDefinitionRecord createPublicSetter(Object key, Object setter, boolean anonymousFunctionDefinition, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.Setter, key, null, null, setter, false, anonymousFunctionDefinition, decorators);
    }

    public static ClassElementDefinitionRecord createPrivateSetter(Object key, Object setter, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.Setter, key, null, null, setter, true, false, decorators);
    }

    public static ClassElementDefinitionRecord createPublicAccessor(Object key, Object getter, Object setter, boolean anonymousFunctionDefinition, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.AccessorPair, key, null, getter, setter, false, anonymousFunctionDefinition, decorators);
    }

    public static ClassElementDefinitionRecord createPrivateAccessor(Object key, Object getter, Object setter, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.AccessorPair, key, null, getter, setter, true, false, decorators);
    }

    public static ClassElementDefinitionRecord createPublicAutoAccessor(Object key, HiddenKey backingStorageKey, Object value, Object getter, Object setter, boolean anonymousFunctionDefinition, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.AutoAccessor, key, value, getter, setter, false, anonymousFunctionDefinition, decorators, backingStorageKey);
    }

    public static ClassElementDefinitionRecord createPrivateAutoAccessor(Object key, HiddenKey backingStorageKey, Object value, Object getter, Object setter, Object[] decorators) {
        return new ClassElementDefinitionRecord(Kind.AutoAccessor, key, value, getter, setter, true, false, decorators, backingStorageKey);
    }

    public static ClassElementDefinitionRecord createStaticBlock(Object initializer) {
        return new ClassElementDefinitionRecord(Kind.StaticBlock, null, initializer, null, null, false, false, null);
    }

    protected ClassElementDefinitionRecord(Kind kind, Object key, Object value, Object getter, Object setter, boolean isPrivate, boolean anonymousFunctionDefinition, Object[] decorators) {
        this(kind, key, value, getter, setter, isPrivate, anonymousFunctionDefinition, decorators, null);
    }

    protected ClassElementDefinitionRecord(Kind kind, Object key, Object value, Object getter, Object setter, boolean isPrivate, boolean anonymousFunctionDefinition, Object[] decorators, HiddenKey backingStorageKey) {
        this.kind = kind;
        this.key = key;
        this.value = value;
        this.getter = getter;
        this.setter = setter;
        this.anonymousFunctionDefinition = anonymousFunctionDefinition;
        this.isPrivate = isPrivate;
        this.decorators = decorators;
        this.initializers = decorators == null || decorators.length == 0 ? ScriptArray.EMPTY_OBJECT_ARRAY : new Object[decorators.length];
        this.backingStorageKey = backingStorageKey;
        assert (kind != Kind.AutoAccessor ? value != null != (getter != null || setter != null) : value != null && getter != null && setter != null);
        assert (kind != Kind.AccessorPair || decorators == null || decorators.length == 0);
    }

    public boolean isMethod() {
        return this.kind == Kind.Method;
    }

    public boolean isGetter() {
        return this.kind == Kind.Getter;
    }

    public boolean isSetter() {
        return this.kind == Kind.Setter;
    }

    public boolean isAccessor() {
        return this.isGetter() || this.isSetter() || this.kind == Kind.AccessorPair;
    }

    public boolean isAutoAccessor() {
        return this.kind == Kind.AutoAccessor;
    }

    public boolean isField() {
        return this.kind == Kind.Field;
    }

    public boolean isStaticBlock() {
        return this.kind == Kind.StaticBlock;
    }

    public Kind getKind() {
        return this.kind;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public Object[] getDecorators() {
        return this.decorators;
    }

    public boolean hasDecorators() {
        return this.decorators != null;
    }

    public Object getKey() {
        return this.key;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object newValue) {
        this.value = newValue;
    }

    public Object[] getInitializers() {
        return this.initializers;
    }

    public int getInitializersCount() {
        return this.initializersCount;
    }

    public void addInitializer(Object initializer) {
        this.initializers[this.initializersCount++] = initializer;
    }

    public boolean hasInitializers() {
        return this.initializersCount != 0;
    }

    public void cleanDecorator() {
        this.decorators = EMPTY;
    }

    public boolean isAnonymousFunction() {
        return this.anonymousFunctionDefinition;
    }

    public void setGetter(Object newGetter) {
        this.getter = newGetter;
    }

    public void setSetter(Object newSetter) {
        this.setter = newSetter;
    }

    public Object getGetter() {
        return this.getter;
    }

    public Object getSetter() {
        return this.setter;
    }

    public HiddenKey getBackingStorageKey() {
        return this.backingStorageKey;
    }

    public String toString() {
        return "ClassElementDefinitionRecord [kind=" + String.valueOf((Object)this.kind) + ", key=" + String.valueOf(this.key) + ", value=" + String.valueOf(this.value) + ", getter=" + String.valueOf(this.getter) + ", setter=" + String.valueOf(this.setter) + "]";
    }

    public static enum Kind {
        Method,
        Field,
        Getter,
        Setter,
        AutoAccessor,
        AccessorPair,
        StaticBlock;

    }
}

