/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.api;

import java.util.Optional;
import java.util.function.Function;
import org.junit.platform.commons.logging.Logger;

class RandomOrdererUtils {
    static final String RANDOM_SEED_PROPERTY_NAME = "junit.jupiter.execution.order.random.seed";
    static final long DEFAULT_SEED = System.nanoTime();

    RandomOrdererUtils() {
    }

    static Long getSeed(Function<String, Optional<String>> configurationParameterLookup, Logger logger) {
        return RandomOrdererUtils.getCustomSeed(configurationParameterLookup, logger).orElse(DEFAULT_SEED);
    }

    private static Optional<Long> getCustomSeed(Function<String, Optional<String>> configurationParameterLookup, Logger logger) {
        return configurationParameterLookup.apply(RANDOM_SEED_PROPERTY_NAME).map(configurationParameter -> {
            try {
                logger.config(() -> String.format("Using custom seed for configuration parameter [%s] with value [%s].", RANDOM_SEED_PROPERTY_NAME, configurationParameter));
                return Long.valueOf(configurationParameter);
            }
            catch (NumberFormatException ex) {
                logger.warn((Throwable)ex, () -> String.format("Failed to convert configuration parameter [%s] with value [%s] to a long. Using default seed [%s] as fallback.", RANDOM_SEED_PROPERTY_NAME, configurationParameter, DEFAULT_SEED));
                return null;
            }
        });
    }
}

