/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.client.am;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import org.apache.derby.client.am.ClientClob;
import org.apache.derby.client.am.ClientConnection;
import org.apache.derby.client.am.ClobLocatorReader;
import org.apache.derby.client.am.SqlException;

class UpdateSensitiveClobLocatorReader
extends Reader {
    private BufferedReader r = null;
    private ClientConnection con = null;
    private ClientClob clob = null;
    private long updateCount;
    private long currentPos;
    private long length;

    protected UpdateSensitiveClobLocatorReader(ClientConnection con, ClientClob clob) throws SqlException {
        clob.checkForLocatorValidity();
        this.r = new BufferedReader(new ClobLocatorReader(con, clob));
        this.currentPos = 1L;
        this.con = con;
        this.clob = clob;
        this.updateCount = clob.getUpdateCount();
        this.length = -1L;
    }

    protected UpdateSensitiveClobLocatorReader(ClientConnection con, ClientClob clob, long pos, long len) throws SqlException {
        clob.checkForLocatorValidity();
        this.r = new BufferedReader(new ClobLocatorReader(con, clob, pos, len));
        this.con = con;
        this.clob = clob;
        this.currentPos = pos;
        this.length = len;
        this.updateCount = clob.getUpdateCount();
    }

    @Override
    public int read() throws IOException {
        this.identifyAndReplaceObseleteStream();
        int ret = this.r.read();
        if (ret == -1) {
            return ret;
        }
        ++this.currentPos;
        return ret;
    }

    @Override
    public int read(char[] c, int off, int len) throws IOException {
        this.identifyAndReplaceObseleteStream();
        int ret = this.r.read(c, off, len);
        if (ret == -1) {
            return ret;
        }
        this.currentPos += (long)ret;
        return ret;
    }

    @Override
    public void close() throws IOException {
        this.r.close();
    }

    private void identifyAndReplaceObseleteStream() throws IOException {
        long newUpdateCount = this.clob.getUpdateCount();
        if (this.updateCount != newUpdateCount) {
            try {
                this.r = new BufferedReader(this.reCreateStream());
            }
            catch (SqlException sqle) {
                IOException ioe = new IOException();
                ioe.initCause(sqle);
                throw ioe;
            }
        } else {
            return;
        }
        this.updateCount = newUpdateCount;
    }

    private Reader reCreateStream() throws SqlException {
        ClobLocatorReader r_ = null;
        r_ = this.length != -1L ? new ClobLocatorReader(this.con, this.clob, this.currentPos, this.length - this.currentPos + 1L) : new ClobLocatorReader(this.con, this.clob, this.currentPos, -1L);
        return r_;
    }
}

