/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.credentialbuilder;

import java.net.URI;
import java.util.Optional;
import java.util.UUID;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;

public class CredentialBuilderUtils {
    private static final String ISSUER_DID_REALM_ATTRIBUTE_KEY = "issuerDid";
    private static final String ID_TEMPLATE = "urn:uuid:%s";

    public static String createCredentialId(VerifiableCredential verifiableCredential) {
        return Optional.ofNullable(verifiableCredential.getId()).orElse(URI.create(String.format(ID_TEMPLATE, UUID.randomUUID()))).toString();
    }

    public static Optional<String> getIssuerDid(KeycloakSession keycloakSession) {
        RealmModel realm = keycloakSession.getContext().getRealm();
        return Optional.ofNullable(realm.getAttribute(ISSUER_DID_REALM_ATTRIBUTE_KEY));
    }
}

