/*
 * Decompiled with CFR 0.152.
 */
package jadx.core.dex.visitors;

import jadx.api.plugins.input.data.attributes.IJadxAttribute;
import jadx.core.dex.attributes.AFlag;
import jadx.core.dex.attributes.AType;
import jadx.core.dex.attributes.nodes.FieldReplaceAttr;
import jadx.core.dex.attributes.nodes.MethodReplaceAttr;
import jadx.core.dex.attributes.nodes.SkipMethodArgsAttr;
import jadx.core.dex.info.AccessInfo;
import jadx.core.dex.info.ClassInfo;
import jadx.core.dex.info.FieldInfo;
import jadx.core.dex.info.MethodInfo;
import jadx.core.dex.instructions.IndexInsnNode;
import jadx.core.dex.instructions.InsnType;
import jadx.core.dex.instructions.InvokeNode;
import jadx.core.dex.instructions.InvokeType;
import jadx.core.dex.instructions.args.ArgType;
import jadx.core.dex.instructions.args.InsnArg;
import jadx.core.dex.instructions.args.InsnWrapArg;
import jadx.core.dex.instructions.args.RegisterArg;
import jadx.core.dex.instructions.args.SSAVar;
import jadx.core.dex.instructions.mods.ConstructorInsn;
import jadx.core.dex.nodes.BlockNode;
import jadx.core.dex.nodes.ClassNode;
import jadx.core.dex.nodes.FieldNode;
import jadx.core.dex.nodes.InsnNode;
import jadx.core.dex.nodes.MethodNode;
import jadx.core.dex.visitors.AbstractVisitor;
import jadx.core.dex.visitors.FixAccessModifiers;
import jadx.core.dex.visitors.JadxVisitor;
import jadx.core.dex.visitors.ModVisitor;
import jadx.core.dex.visitors.ProcessAnonymous;
import jadx.core.dex.visitors.usage.UsageInfoVisitor;
import jadx.core.utils.BlockUtils;
import jadx.core.utils.InsnRemover;
import jadx.core.utils.exceptions.JadxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

@JadxVisitor(name="ClassModifier", desc="Remove synthetic classes, methods and fields", runAfter={ModVisitor.class, FixAccessModifiers.class, ProcessAnonymous.class})
public class ClassModifier
extends AbstractVisitor {
    @Override
    public boolean visit(ClassNode cls) throws JadxException {
        for (ClassNode inner : cls.getInnerClasses()) {
            this.visit(inner);
        }
        if (ClassModifier.isEmptySyntheticClass(cls)) {
            cls.add(AFlag.DONT_GENERATE);
            return false;
        }
        ClassModifier.removeSyntheticFields(cls);
        cls.getMethods().forEach(ClassModifier::removeSyntheticMethods);
        cls.getMethods().forEach(ClassModifier::removeEmptyMethods);
        cls.getMethods().forEach(ClassModifier::processAnonymousConstructor);
        return false;
    }

    private static boolean isEmptySyntheticClass(ClassNode cls) {
        return cls.getAccessFlags().isSynthetic() && cls.getFields().isEmpty() && cls.getMethods().isEmpty() && cls.getInnerClasses().isEmpty();
    }

    private static void removeSyntheticFields(ClassNode cls) {
        boolean inline = cls.isAnonymous();
        if (inline || cls.getClassInfo().isInner()) {
            for (FieldNode field : cls.getFields()) {
                if (!field.getAccessFlags().isSynthetic() || !field.getType().isObject()) continue;
                ClassInfo clsInfo = ClassInfo.fromType(cls.root(), field.getType());
                ClassNode fieldsCls = cls.root().resolveClass(clsInfo);
                ClassInfo parentClass = cls.getClassInfo().getParentClass();
                if (fieldsCls == null || !inline && !Objects.equals(parentClass, fieldsCls.getClassInfo())) continue;
                int found = 0;
                for (MethodNode mth : cls.getMethods()) {
                    if (!ClassModifier.removeFieldUsageFromConstructor(mth, field, fieldsCls)) continue;
                    ++found;
                }
                if (found == 0) continue;
                field.addAttr((IJadxAttribute)new FieldReplaceAttr(fieldsCls.getClassInfo()));
                field.add(AFlag.DONT_GENERATE);
            }
        }
    }

    private static boolean removeFieldUsageFromConstructor(MethodNode mth, FieldNode field, ClassNode fieldsCls) {
        if (mth.isNoCode() || !mth.getAccessFlags().isConstructor()) {
            return false;
        }
        List<RegisterArg> args = mth.getArgRegs();
        if (args.isEmpty() || mth.contains(AFlag.SKIP_FIRST_ARG)) {
            return false;
        }
        RegisterArg arg = args.get(0);
        if (!arg.getType().equals(fieldsCls.getClassInfo().getType())) {
            return false;
        }
        BlockNode block = mth.getEnterBlock().getCleanSuccessors().get(0);
        List<InsnNode> instructions = block.getInstructions();
        if (instructions.isEmpty()) {
            return false;
        }
        InsnNode insn = instructions.get(0);
        if (insn.getType() != InsnType.IPUT) {
            return false;
        }
        IndexInsnNode putInsn = (IndexInsnNode)insn;
        FieldInfo fieldInfo = (FieldInfo)putInsn.getIndex();
        if (!fieldInfo.equals(field.getFieldInfo()) || !putInsn.getArg(0).equals(arg)) {
            return false;
        }
        mth.skipFirstArgument();
        InsnRemover.remove(mth, block, insn);
        if (arg.getSVar().getUseCount() != 0) {
            IndexInsnNode iget = new IndexInsnNode(InsnType.IGET, fieldInfo, 1);
            iget.addArg(insn.getArg(1));
            for (InsnArg insnArg : new ArrayList<RegisterArg>(arg.getSVar().getUseList())) {
                insnArg.wrapInstruction(mth, iget);
            }
        }
        return true;
    }

    private static void removeSyntheticMethods(MethodNode mth) {
        List<RegisterArg> args;
        InsnNode insn;
        if (mth.isNoCode() || mth.contains(AFlag.DONT_GENERATE)) {
            return;
        }
        AccessInfo af = mth.getAccessFlags();
        if (!af.isSynthetic()) {
            return;
        }
        ClassNode cls = mth.getParentClass();
        if (ClassModifier.removeBridgeMethod(cls, mth)) {
            mth.add(AFlag.DONT_GENERATE);
            return;
        }
        if (mth.isConstructor() && mth.contains(AFlag.METHOD_CANDIDATE_FOR_INLINE) && (insn = BlockUtils.getOnlyOneInsnFromMth(mth)) != null && ClassModifier.isRemovedClassInArgs(cls, args = mth.getArgRegs())) {
            ClassModifier.modifySyntheticMethod(cls, mth, insn, args);
        }
    }

    private static boolean isRemovedClassInArgs(ClassNode cls, List<RegisterArg> mthArgs) {
        for (RegisterArg arg : mthArgs) {
            ClassInfo argClsInfo;
            ClassNode argCls;
            ArgType argType = arg.getType();
            if (!argType.isObject() || !((argCls = cls.root().resolveClass(argType)) == null ? (argClsInfo = ClassInfo.fromType(cls.root(), argType)).isInner() && cls.getFullName().startsWith(argClsInfo.getParentClass().getFullName()) : argCls.contains(AFlag.DONT_GENERATE) || ClassModifier.isEmptySyntheticClass(argCls))) continue;
            return true;
        }
        return false;
    }

    private static void modifySyntheticMethod(ClassNode cls, MethodNode mth, InsnNode insn, List<RegisterArg> args) {
        ConstructorInsn constr;
        if (insn.getType() == InsnType.CONSTRUCTOR && (constr = (ConstructorInsn)insn).isThis() && !args.isEmpty()) {
            RegisterArg firstArg = args.get(0);
            if (firstArg.getType().equals(cls.getParentClass().getClassInfo().getType())) {
                SkipMethodArgsAttr.skipArg(mth, 0);
            }
            int argsCount = args.size();
            for (int i = 0; i < argsCount; ++i) {
                RegisterArg arg = args.get(i);
                SSAVar sVar = arg.getSVar();
                if (sVar == null || sVar.getUseCount() != 0) continue;
                SkipMethodArgsAttr.skipArg(mth, i);
            }
            MethodInfo callMth = constr.getCallMth();
            MethodNode callMthNode = cls.root().resolveMethod(callMth);
            if (callMthNode != null) {
                mth.addAttr((IJadxAttribute)new MethodReplaceAttr(callMthNode));
                mth.add(AFlag.DONT_GENERATE);
                UsageInfoVisitor.replaceMethodUsage(callMthNode, mth);
            }
        }
    }

    private static boolean removeBridgeMethod(ClassNode cls, MethodNode mth) {
        List<InsnNode> allInsns;
        if (cls.root().getArgs().isInlineMethods() && (allInsns = BlockUtils.collectAllInsns(mth.getBasicBlocks())).size() == 1) {
            InsnArg arg;
            InsnNode wrappedInsn = allInsns.get(0);
            if (wrappedInsn.getType() == InsnType.RETURN && (arg = wrappedInsn.getArg(0)).isInsnWrap()) {
                wrappedInsn = ((InsnWrapArg)arg).getWrapInsn();
            }
            return ClassModifier.checkSyntheticWrapper(mth, wrappedInsn);
        }
        return false;
    }

    private static boolean checkSyntheticWrapper(MethodNode mth, InsnNode insn) {
        InsnType insnType = insn.getType();
        if (insnType != InsnType.INVOKE) {
            return false;
        }
        InvokeNode invokeInsn = (InvokeNode)insn;
        if (invokeInsn.getInvokeType() == InvokeType.SUPER) {
            return false;
        }
        MethodInfo callMth = invokeInsn.getCallMth();
        MethodNode wrappedMth = mth.root().resolveMethod(callMth);
        if (wrappedMth == null) {
            return false;
        }
        AccessInfo wrappedAccFlags = wrappedMth.getAccessFlags();
        if (wrappedAccFlags.isStatic()) {
            return false;
        }
        if (callMth.getArgsCount() != mth.getMethodInfo().getArgsCount()) {
            return false;
        }
        if (!mth.getParentClass().equals(wrappedMth.getParentClass())) {
            return false;
        }
        for (InsnArg arg : insn.getArguments()) {
            if (ClassModifier.registersAndCastsOnly(arg)) continue;
            return false;
        }
        if (!wrappedAccFlags.isPublic()) {
            FixAccessModifiers.changeVisibility(wrappedMth, 1);
        }
        String alias = mth.getAlias();
        if (!Objects.equals(wrappedMth.getAlias(), alias)) {
            wrappedMth.getMethodInfo().setAlias(alias);
        }
        wrappedMth.addAttr((IJadxAttribute)new MethodReplaceAttr(mth));
        wrappedMth.copyAttributeFrom(mth, AType.METHOD_OVERRIDE);
        wrappedMth.addDebugComment("Method merged with bridge method");
        return true;
    }

    private static boolean registersAndCastsOnly(InsnArg arg) {
        InsnNode wrapInsn;
        if (arg.isRegister()) {
            return true;
        }
        if (arg.isInsnWrap() && (wrapInsn = ((InsnWrapArg)arg).getWrapInsn()).getType() == InsnType.CHECK_CAST) {
            return ClassModifier.registersAndCastsOnly(wrapInsn.getArg(0));
        }
        return false;
    }

    private static void removeEmptyMethods(MethodNode mth) {
        List<BlockNode> bb;
        boolean clsInit;
        AccessInfo af = mth.getAccessFlags();
        boolean publicConstructor = af.isConstructor() && af.isPublic();
        boolean bl = clsInit = mth.getMethodInfo().isClassInit() && af.isStatic();
        if ((publicConstructor || clsInit) && mth.getArgRegs().isEmpty() && ((bb = mth.getBasicBlocks()) == null || bb.isEmpty() || BlockUtils.isAllBlocksEmpty(bb))) {
            if (clsInit) {
                mth.add(AFlag.DONT_GENERATE);
            } else if (mth.isDefaultConstructor() && !ClassModifier.isNonDefaultConstructorExists(mth)) {
                mth.add(AFlag.DONT_GENERATE);
            }
        }
    }

    private static void processAnonymousConstructor(MethodNode mth) {
        if (!mth.contains(AFlag.ANONYMOUS_CONSTRUCTOR)) {
            return;
        }
        ArrayList<InsnNode> usedInsns = new ArrayList<InsnNode>();
        Map<InsnArg, FieldNode> argsMap = ClassModifier.getArgsToFieldsMapping(mth, usedInsns);
        for (Map.Entry<InsnArg, FieldNode> entry : argsMap.entrySet()) {
            FieldNode field = entry.getValue();
            if (field == null) continue;
            InsnArg arg = entry.getKey();
            field.addAttr((IJadxAttribute)new FieldReplaceAttr(arg));
            field.add(AFlag.DONT_GENERATE);
            if (!arg.isRegister()) continue;
            arg.add(AFlag.SKIP_ARG);
            SkipMethodArgsAttr.skipArg(mth, (RegisterArg)arg);
        }
        for (InsnNode usedInsn : usedInsns) {
            usedInsn.add(AFlag.DONT_GENERATE);
        }
    }

    private static Map<InsnArg, FieldNode> getArgsToFieldsMapping(MethodNode mth, List<InsnNode> usedInsns) {
        MethodInfo callMth = mth.getMethodInfo();
        ClassNode cls = mth.getParentClass();
        List<RegisterArg> argList = mth.getArgRegs();
        ClassNode outerCls = mth.getUseIn().get(0).getParentClass();
        int startArg = 0;
        if (callMth.getArgsCount() != 0 && callMth.getArgumentsTypes().get(0).equals(outerCls.getClassInfo().getType())) {
            startArg = 1;
        }
        LinkedHashMap<InsnArg, FieldNode> map = new LinkedHashMap<InsnArg, FieldNode>();
        int argsCount = argList.size();
        block4: for (int i = startArg; i < argsCount; ++i) {
            RegisterArg arg = argList.get(i);
            InsnNode useInsn = ClassModifier.getParentInsnSkipMove(arg);
            if (useInsn == null) {
                return Collections.emptyMap();
            }
            switch (useInsn.getType()) {
                case IPUT: {
                    FieldNode fieldNode = cls.searchField((FieldInfo)((IndexInsnNode)useInsn).getIndex());
                    if (fieldNode == null || !fieldNode.getAccessFlags().isSynthetic()) {
                        return Collections.emptyMap();
                    }
                    map.put(arg, fieldNode);
                    usedInsns.add(useInsn);
                    continue block4;
                }
                case CONSTRUCTOR: {
                    ConstructorInsn superConstr = (ConstructorInsn)useInsn;
                    if (!superConstr.isSuper()) {
                        return Collections.emptyMap();
                    }
                    usedInsns.add(useInsn);
                    continue block4;
                }
                default: {
                    return Collections.emptyMap();
                }
            }
        }
        return map;
    }

    private static InsnNode getParentInsnSkipMove(RegisterArg arg) {
        SSAVar sVar = arg.getSVar();
        if (sVar.getUseCount() != 1) {
            return null;
        }
        RegisterArg useArg = sVar.getUseList().get(0);
        InsnNode parentInsn = useArg.getParentInsn();
        if (parentInsn == null) {
            return null;
        }
        if (parentInsn.getType() == InsnType.MOVE) {
            return ClassModifier.getParentInsnSkipMove(parentInsn.getResult());
        }
        return parentInsn;
    }

    private static boolean isNonDefaultConstructorExists(MethodNode defCtor) {
        ClassNode parentClass = defCtor.getParentClass();
        for (MethodNode mth : parentClass.getMethods()) {
            if (mth == defCtor || !mth.isConstructor() || mth.isDefaultConstructor()) continue;
            return true;
        }
        return false;
    }
}

