/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.xfire.plexus;

import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import org.codehaus.plexus.PlexusTestCase;
import org.codehaus.xfire.MessageContext;
import org.codehaus.xfire.XFire;
import org.codehaus.xfire.exchange.InMessage;
import org.codehaus.xfire.service.Service;
import org.codehaus.xfire.service.ServiceFactory;
import org.codehaus.xfire.service.ServiceRegistry;
import org.codehaus.xfire.service.binding.MessageBindingProvider;
import org.codehaus.xfire.service.binding.ObjectServiceFactory;
import org.codehaus.xfire.soap.Soap11;
import org.codehaus.xfire.soap.Soap12;
import org.codehaus.xfire.test.XPathAssert;
import org.codehaus.xfire.transport.Channel;
import org.codehaus.xfire.transport.Transport;
import org.codehaus.xfire.util.STAXUtils;
import org.codehaus.xfire.util.jdom.StaxBuilder;
import org.codehaus.xfire.wsdl.WSDLWriter;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.XMLOutputter;

public class PlexusXFireTest
extends PlexusTestCase {
    private ServiceFactory factory;
    private XMLInputFactory defaultInputFactory = XMLInputFactory.newInstance();
    private Map namespaces = new HashMap();

    protected void printNode(Document node) throws Exception {
        XMLOutputter writer = new XMLOutputter();
        writer.output(node, (OutputStream)System.out);
    }

    protected void printNode(Element node) throws Exception {
        XMLOutputter writer = new XMLOutputter();
        writer.output(node, (OutputStream)System.out);
    }

    protected Document invokeService(String service, String document) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        MessageContext context = new MessageContext();
        context.setXFire(this.getXFire());
        context.setProperty("urn:xfire:channel:backchannel", out);
        if (service != null) {
            context.setService(this.getServiceRegistry().getService(service));
        }
        InputStream stream = this.getResourceAsStream(document);
        InMessage msg = new InMessage(STAXUtils.createXMLStreamReader(stream, "UTF-8", null));
        Transport t = this.getXFire().getTransportManager().getTransport("urn:xfire:transport:local");
        Channel c = t.createChannel();
        c.receive(context, msg);
        String response = out.toString();
        if (response == null || response.length() == 0) {
            return null;
        }
        return this.readDocument(response);
    }

    protected Document readDocument(String text) throws XMLStreamException {
        return this.readDocument(text, this.defaultInputFactory);
    }

    protected Document readDocument(String text, XMLInputFactory ifactory) throws XMLStreamException {
        try {
            StaxBuilder builder = new StaxBuilder(ifactory);
            return builder.build(new StringReader(text));
        }
        catch (XMLStreamException e) {
            System.err.println("Could not read the document!");
            System.err.println(text);
            throw e;
        }
    }

    protected Document getWSDLDocument(String service) throws Exception {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.getXFire().generateWSDL(service, out);
        return this.readDocument(out.toString());
    }

    protected void setUp() throws Exception {
        super.setUp();
        this.addNamespace("s", Soap11.getInstance().getNamespace());
        this.addNamespace("soap12", Soap12.getInstance().getNamespace());
    }

    public List assertValid(String xpath, Object node) throws Exception {
        return XPathAssert.assertValid(xpath, node, this.namespaces);
    }

    public List assertInvalid(String xpath, Object node) throws Exception {
        return XPathAssert.assertInvalid(xpath, node, this.namespaces);
    }

    public void assertXPathEquals(String xpath, String value, Document node) throws Exception {
        XPathAssert.assertXPathEquals(xpath, value, node, this.namespaces);
    }

    public void assertNoFault(Document node) throws Exception {
        XPathAssert.assertNoFault(node);
    }

    public void addNamespace(String ns, String uri) {
        this.namespaces.put(ns, uri);
    }

    protected WSDLWriter getWSDL(String service) throws Exception {
        ServiceRegistry reg = this.getServiceRegistry();
        Service hello = reg.getService(service);
        return hello.getWSDLWriter();
    }

    public ServiceFactory getServiceFactory() throws Exception {
        if (this.factory == null) {
            ObjectServiceFactory ofactory = new ObjectServiceFactory(this.getXFire().getTransportManager(), new MessageBindingProvider());
            ofactory.setStyle("message");
            this.factory = ofactory;
        }
        return this.factory;
    }

    public void setServiceFactory(ServiceFactory factory) {
        this.factory = factory;
    }

    protected InputStream getResourceAsStream(String resource) {
        return ((Object)((Object)this)).getClass().getResourceAsStream(resource);
    }

    protected Reader getResourceAsReader(String resource) {
        return new InputStreamReader(this.getResourceAsStream(resource));
    }

    protected XFire getXFire() throws Exception {
        return (XFire)this.lookup(XFire.ROLE);
    }

    protected ServiceRegistry getServiceRegistry() throws Exception {
        return this.getXFire().getServiceRegistry();
    }
}

