/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.test.encryption;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESedeKeySpec;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.algorithms.JCEMapper;
import org.apache.xml.security.c14n.Canonicalizer;
import org.apache.xml.security.encryption.EncryptedData;
import org.apache.xml.security.encryption.EncryptedKey;
import org.apache.xml.security.encryption.EncryptionMethod;
import org.apache.xml.security.encryption.Transforms;
import org.apache.xml.security.encryption.XMLCipher;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.transforms.params.XPathContainer;
import org.apache.xml.security.utils.IdResolver;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLCipherTester
extends TestCase {
    static Log log = LogFactory.getLog((String)(class$org$apache$xml$security$test$encryption$XMLCipherTester == null ? (class$org$apache$xml$security$test$encryption$XMLCipherTester = XMLCipherTester.class$("org.apache.xml.security.test.encryption.XMLCipherTester")) : class$org$apache$xml$security$test$encryption$XMLCipherTester).getName());
    private String documentName;
    private String elementName;
    private String elementIndex;
    private XMLCipher cipher;
    private String basedir;
    private boolean haveISOPadding;
    private boolean haveKeyWraps;
    private String tstBase64EncodedString;
    static /* synthetic */ Class class$org$apache$xml$security$test$encryption$XMLCipherTester;

    public XMLCipherTester(String string) {
        super(string);
    }

    protected void setUp() {
        this.basedir = System.getProperty("basedir", ".");
        this.documentName = System.getProperty("org.apache.xml.enc.test.doc", this.basedir + "/build.xml");
        this.elementName = System.getProperty("org.apache.xml.enc.test.elem", "path");
        this.elementIndex = System.getProperty("org.apache.xml.enc.test.idx", "0");
        this.tstBase64EncodedString = new String("YmNkZWZnaGlqa2xtbm9wcRrPXjQ1hvhDFT+EdesMAPE4F6vlT+y0HPXe0+nAGLQ8");
        this.haveISOPadding = false;
        String string = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        if (string != null) {
            try {
                if (Cipher.getInstance(string) != null) {
                    this.haveISOPadding = true;
                }
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            }
            catch (NoSuchPaddingException noSuchPaddingException) {
                // empty catch block
            }
        }
        this.haveKeyWraps = JCEMapper.translateURItoJCEID((String)"http://www.w3.org/2001/04/xmlenc#kw-aes128") != null;
    }

    protected void tearDown() {
    }

    private Document document() {
        Document document = null;
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            File file = new File(this.documentName);
            document = documentBuilder.parse(file);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            System.exit(-1);
        }
        return document;
    }

    private String element() {
        return this.elementName;
    }

    private int index() {
        int n = -1;
        try {
            n = Integer.parseInt(this.elementIndex);
        }
        catch (NumberFormatException numberFormatException) {
            numberFormatException.printStackTrace();
            System.exit(-1);
        }
        return n;
    }

    public void testAES128ElementAES192KWCipherUsingKEK() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding && this.haveKeyWraps) {
            string = this.toString(document);
            byte[] byArray = "abcdefghijklmnopqrstuvwx".getBytes();
            SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(128);
            SecretKey secretKey = keyGenerator.generateKey();
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-aes192");
            this.cipher.init(3, (Key)secretKeySpec);
            EncryptedKey encryptedKey = this.cipher.encryptKey(document, (Key)secretKey);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(1, (Key)secretKey);
            EncryptedData encryptedData = this.cipher.getEncryptedData();
            KeyInfo keyInfo = encryptedData.getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new KeyInfo(document);
                encryptedData.setKeyInfo(keyInfo);
            }
            keyInfo.add(encryptedKey);
            document2 = this.cipher.doFinal(document, element);
            secretKey = null;
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(2, null);
            this.cipher.setKEK((Key)secretKeySpec);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            Assert.assertEquals((String)string, (String)string2);
        } else {
            log.warn((Object)"Test testAES128ElementAES192KWCipherUsingKEK skipped as necessary algorithms not available");
        }
    }

    public void testAES128ElementRSAKWCipherUsingKEK() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
            KeyPair keyPair = keyPairGenerator.generateKeyPair();
            PrivateKey privateKey = keyPair.getPrivate();
            PublicKey publicKey = keyPair.getPublic();
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(256);
            SecretKey secretKey = keyGenerator.generateKey();
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#rsa-1_5");
            this.cipher.init(3, (Key)publicKey);
            EncryptedKey encryptedKey = this.cipher.encryptKey(document, (Key)secretKey);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            this.cipher.init(1, (Key)secretKey);
            EncryptedData encryptedData = this.cipher.getEncryptedData();
            KeyInfo keyInfo = encryptedData.getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new KeyInfo(document);
                encryptedData.setKeyInfo(keyInfo);
            }
            keyInfo.add(encryptedKey);
            document2 = this.cipher.doFinal(document, element);
            log.debug((Object)"Encrypted document");
            log.debug((Object)this.toString(document2));
            secretKey = null;
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(2, null);
            this.cipher.setKEK((Key)privateKey);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            log.debug((Object)"Output document");
            log.debug((Object)string2);
            Assert.assertEquals((String)string, (String)string2);
        } else {
            log.warn((Object)"Test testAES128ElementRSAKWCipherUsingKEK skipped as necessary algorithms not available");
        }
    }

    public void testAES192ElementAES256KWCipher() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding && this.haveKeyWraps) {
            XMLCipher xMLCipher;
            string = this.toString(document);
            byte[] byArray = "abcdefghijklmnopqrstuvwx".getBytes();
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            KeyGenerator keyGenerator = KeyGenerator.getInstance("AES");
            keyGenerator.init(192);
            Key key = keyGenerator.generateKey();
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#kw-tripledes");
            this.cipher.init(3, (Key)secretKey);
            EncryptedKey encryptedKey = this.cipher.encryptKey(document, key);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            this.cipher.init(1, key);
            EncryptedData encryptedData = this.cipher.getEncryptedData();
            KeyInfo keyInfo = encryptedData.getKeyInfo();
            if (keyInfo == null) {
                keyInfo = new KeyInfo(document);
                encryptedData.setKeyInfo(keyInfo);
            }
            keyInfo.add(encryptedKey);
            document2 = this.cipher.doFinal(document, element);
            key = null;
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            this.cipher = XMLCipher.getInstance();
            this.cipher.init(2, null);
            EncryptedData encryptedData2 = this.cipher.loadEncryptedData(document2, element2);
            if (encryptedData2 == null) {
                System.out.println("ed is null");
            } else if (encryptedData2.getKeyInfo() == null) {
                System.out.println("ki is null");
            }
            EncryptedKey encryptedKey2 = encryptedData2.getKeyInfo().itemEncryptedKey(0);
            if (encryptedKey2 != null) {
                xMLCipher = XMLCipher.getInstance();
                xMLCipher.init(4, (Key)secretKey);
                key = xMLCipher.decryptKey(encryptedKey2, encryptedData2.getEncryptionMethod().getAlgorithm());
            }
            xMLCipher = XMLCipher.getInstance();
            xMLCipher.init(2, key);
            document3 = xMLCipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            Assert.assertEquals((String)string, (String)string2);
        } else {
            log.warn((Object)"Test testAES192ElementAES256KWCipher skipped as necessary algorithms not available");
        }
    }

    public void testTrippleDesElementCipher() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            byte[] byArray = "24 Bytes per DESede key!".getBytes();
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            this.cipher.init(1, (Key)secretKey);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            this.cipher.init(2, (Key)secretKey);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            EncryptedData encryptedData = this.cipher.loadEncryptedData(document2, element2);
            Assert.assertEquals((String)encryptedData.getEncryptionMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            Assert.assertEquals((String)string, (String)string2);
        } else {
            log.warn((Object)"Test testTrippleDesElementCipher skipped as necessary algorithms not available");
        }
    }

    public void testAes128ElementCipher() throws Exception {
        byte[] byArray = new byte[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(1, (Key)secretKeySpec);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            this.cipher.init(2, (Key)secretKeySpec);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            EncryptedData encryptedData = this.cipher.loadEncryptedData(document2, element2);
            Assert.assertEquals((String)encryptedData.getEncryptionMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            Assert.assertEquals((String)string, (String)string2);
        } else {
            log.warn((Object)"Test testAes128ElementCipher skipped as necessary algorithms not available");
        }
    }

    public void testAes192ElementCipher() throws Exception {
        byte[] byArray = new byte[]{8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            this.cipher.init(1, (Key)secretKeySpec);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            this.cipher.init(2, (Key)secretKeySpec);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            EncryptedData encryptedData = this.cipher.loadEncryptedData(document2, element2);
            Assert.assertEquals((String)encryptedData.getEncryptionMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            Assert.assertEquals((String)string, (String)string2);
        } else {
            log.warn((Object)"Test testAes192ElementCipher skipped as necessary algorithms not available");
        }
    }

    public void testAes265ElementCipher() throws Exception {
        byte[] byArray = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            this.cipher.init(1, (Key)secretKeySpec);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            this.cipher.init(2, (Key)secretKeySpec);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            EncryptedData encryptedData = this.cipher.loadEncryptedData(document2, element2);
            Assert.assertEquals((String)encryptedData.getEncryptionMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            Assert.assertEquals((String)string, (String)string2);
        } else {
            log.warn((Object)"Test testAes265ElementCipher skipped as necessary algorithms not available");
        }
    }

    public void testTrippleDesDocumentCipher() throws Exception {
        Document document = this.document();
        Document document2 = null;
        Document document3 = null;
        Element element = document.getDocumentElement();
        Element element2 = null;
        String string = null;
        String string2 = null;
        if (this.haveISOPadding) {
            string = this.toString(document);
            byte[] byArray = "24 Bytes per DESede key!".getBytes();
            DESedeKeySpec dESedeKeySpec = new DESedeKeySpec(byArray);
            SecretKeyFactory secretKeyFactory = SecretKeyFactory.getInstance("DESede");
            SecretKey secretKey = secretKeyFactory.generateSecret(dESedeKeySpec);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            this.cipher.init(1, (Key)secretKey);
            document2 = this.cipher.doFinal(document, element);
            this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
            this.cipher.init(2, (Key)secretKey);
            element2 = (Element)document2.getElementsByTagName("xenc:EncryptedData").item(0);
            document3 = this.cipher.doFinal(document2, element2);
            string2 = this.toString(document3);
            Assert.assertEquals((String)string, (String)string2);
        } else {
            log.warn((Object)"Test testTrippleDesDocumentCipher skipped as necessary algorithms not available");
        }
    }

    public void testSameDocumentCipherReference() throws Exception {
        if (this.haveISOPadding) {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            Element element = document.createElement("EncryptedDoc");
            document.appendChild(element);
            this.cipher = XMLCipher.getInstance();
            EncryptedData encryptedData = this.cipher.createEncryptedData(2, "#CipherTextId");
            EncryptionMethod encryptionMethod = this.cipher.createEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            encryptedData.setEncryptionMethod(encryptionMethod);
            Transforms transforms = this.cipher.createTransforms(document);
            encryptedData.getCipherData().getCipherReference().setTransforms(transforms);
            org.apache.xml.security.transforms.Transforms transforms2 = transforms.getDSTransforms();
            XPathContainer xPathContainer = new XPathContainer(document);
            xPathContainer.setXPath("self::text()[parent::CipherText[@Id=\"CipherTextId\"]]");
            transforms2.addTransform("http://www.w3.org/TR/1999/REC-xpath-19991116", xPathContainer.getElementPlusReturns());
            transforms2.addTransform("http://www.w3.org/2000/09/xmldsig#base64");
            Element element2 = this.cipher.martial(document, encryptedData);
            element.appendChild(element2);
            Element element3 = document.createElement("CipherText");
            element3.setAttributeNS(null, "Id", "CipherTextId");
            IdResolver.registerElementById((Element)element3, (String)"CipherTextId");
            element3.appendChild(document.createTextNode(this.tstBase64EncodedString));
            element.appendChild(element3);
            XMLCipher xMLCipher = XMLCipher.getInstance();
            SecretKeySpec secretKeySpec = new SecretKeySpec("abcdefghijklmnop".getBytes("ASCII"), "AES");
            xMLCipher.init(2, (Key)secretKeySpec);
            byte[] byArray = xMLCipher.decryptToByteArray(element2);
            Assert.assertEquals((String)new String(byArray, "ASCII"), (String)new String("A test encrypted secret"));
        } else {
            log.warn((Object)"Test testSameDocumentCipherReference skipped as necessary algorithms not available");
        }
    }

    public void testSerializedData() throws Exception {
        if (!this.haveISOPadding) {
            log.warn((Object)"Test testSerializedData skipped as necessary algorithms not available");
            return;
        }
        byte[] byArray = new byte[]{16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
        SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, "AES");
        Document document = this.document();
        Element element = (Element)document.getElementsByTagName(this.element()).item(this.index());
        this.cipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.cipher.init(1, (Key)secretKeySpec);
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        canonicalizer.setWriter((OutputStream)byteArrayOutputStream);
        canonicalizer.notReset();
        canonicalizer.canonicalizeSubtree((Node)element);
        byteArrayOutputStream.close();
        String string = byteArrayOutputStream.toString("UTF-8");
        byte[] byArray2 = byteArrayOutputStream.toByteArray();
        EncryptedData encryptedData = this.cipher.encryptData(document, "http://www.w3.org/2001/04/xmlenc#Element", (InputStream)new ByteArrayInputStream(byArray2));
        XMLCipher xMLCipher = XMLCipher.getInstance((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        xMLCipher.init(2, (Key)secretKeySpec);
        Assert.assertEquals((String)encryptedData.getEncryptionMethod().getAlgorithm(), (String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        byte[] byArray3 = xMLCipher.decryptToByteArray(xMLCipher.martial(encryptedData));
        String string2 = new String(byArray3, "UTF-8");
        Assert.assertEquals((String)string, (String)string2);
        encryptedData = this.cipher.encryptData(document, null, (InputStream)new ByteArrayInputStream(byArray2));
    }

    public void testEncryptedKeyWithRecipient() throws Exception {
        String string = "data/org/apache/xml/security/encryption/encryptedKey.xml";
        if (this.basedir != null && !"".equals(this.basedir)) {
            string = this.basedir + "/" + string;
        }
        File file = new File(string);
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.parse(file);
        XMLCipher xMLCipher = XMLCipher.getInstance();
        xMLCipher.init(4, null);
        NodeList nodeList = document.getElementsByTagNameNS("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            EncryptedKey encryptedKey = xMLCipher.loadEncryptedKey(document, (Element)nodeList.item(i));
            XMLCipherTester.assertNotNull((Object)encryptedKey.getRecipient());
        }
    }

    private String toString(Node node) throws Exception {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        byte[] byArray = canonicalizer.canonicalizeSubtree(node);
        byteArrayOutputStream.write(byArray);
        byteArrayOutputStream.close();
        return byteArrayOutputStream.toString("UTF-8");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        Init.init();
    }
}

