/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.httppost;

import java.util.List;
import java.util.Map;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Counter;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.shared.SharedObjectInterface;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.httppost.HTTPPOST;
import org.pentaho.di.trans.steps.httppost.HTTPPOSTData;
import org.pentaho.di.trans.steps.httppost.Messages;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPPOSTMeta
extends BaseStepMeta
implements StepMetaInterface {
    private String url;
    private String[] argumentField;
    private String[] queryField;
    private String[] argumentParameter;
    private String[] queryParameter;
    private String fieldName;
    private boolean urlInField;
    private String urlField;
    private String requestEntity;
    private String encoding;
    private boolean postafile;

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String[] getArgumentField() {
        return this.argumentField;
    }

    public void setArgumentField(String[] argument) {
        this.argumentField = argument;
    }

    public String[] getQueryField() {
        return this.queryField;
    }

    public void setQueryField(String[] queryfield) {
        this.queryField = queryfield;
    }

    public String[] getArgumentParameter() {
        return this.argumentParameter;
    }

    public void setArgumentParameter(String[] argumentDirection) {
        this.argumentParameter = argumentDirection;
    }

    public String[] getQueryParameter() {
        return this.queryParameter;
    }

    public void setQueryParameter(String[] queryParameter) {
        this.queryParameter = queryParameter;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String procedure) {
        this.url = procedure;
    }

    public boolean isUrlInField() {
        return this.urlInField;
    }

    public boolean isPostAFile() {
        return this.postafile;
    }

    public void setPostAFile(boolean postafile) {
        this.postafile = postafile;
    }

    public void setUrlInField(boolean urlInField) {
        this.urlInField = urlInField;
    }

    public String getUrlField() {
        return this.urlField;
    }

    public void setUrlField(String urlField) {
        this.urlField = urlField;
    }

    public void setRequestEntity(String requestEntity) {
        this.requestEntity = requestEntity;
    }

    public String getRequestEntity() {
        return this.requestEntity;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public void setFieldName(String resultName) {
        this.fieldName = resultName;
    }

    @Override
    public void loadXML(Node stepnode, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleXMLException {
        this.readData(stepnode, databases);
    }

    public void allocate(int nrargs) {
        this.argumentField = new String[nrargs];
        this.argumentParameter = new String[nrargs];
    }

    public void allocateQuery(int nrqueryparams) {
        this.queryField = new String[nrqueryparams];
        this.queryParameter = new String[nrqueryparams];
    }

    @Override
    public Object clone() {
        HTTPPOSTMeta retval = (HTTPPOSTMeta)super.clone();
        int nrargs = this.argumentField.length;
        retval.allocate(nrargs);
        for (int i = 0; i < nrargs; ++i) {
            retval.argumentField[i] = this.argumentField[i];
            retval.argumentParameter[i] = this.argumentParameter[i];
        }
        int nrqueryparams = this.queryField.length;
        retval.allocateQuery(nrqueryparams);
        for (int i = 0; i < nrqueryparams; ++i) {
            retval.queryField[i] = this.queryField[i];
            retval.queryParameter[i] = this.queryParameter[i];
        }
        return retval;
    }

    @Override
    public void setDefault() {
        int i;
        int nrargs = 0;
        this.allocate(nrargs);
        for (i = 0; i < nrargs; ++i) {
            this.argumentField[i] = "arg" + i;
            this.argumentParameter[i] = "arg";
        }
        int nrquery = 0;
        this.allocateQuery(nrquery);
        for (i = 0; i < nrquery; ++i) {
            this.queryField[i] = "query" + i;
            this.queryParameter[i] = "query";
        }
        this.fieldName = "result";
        this.postafile = false;
    }

    @Override
    public void getFields(RowMetaInterface inputRowMeta, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space) throws KettleStepException {
        if (!Const.isEmpty((String)this.fieldName)) {
            ValueMeta v = new ValueMeta(space.environmentSubstitute(this.fieldName), 2);
            inputRowMeta.addValueMeta((ValueMetaInterface)v);
        }
    }

    @Override
    public String getXML() {
        int i;
        StringBuffer retval = new StringBuffer();
        retval.append("    " + XMLHandler.addTagValue((String)"postafile", (boolean)this.postafile));
        retval.append("    " + XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    " + XMLHandler.addTagValue((String)"url", (String)this.url));
        retval.append("    " + XMLHandler.addTagValue((String)"urlInField", (boolean)this.urlInField));
        retval.append("    " + XMLHandler.addTagValue((String)"urlField", (String)this.urlField));
        retval.append("    " + XMLHandler.addTagValue((String)"requestEntity", (String)this.requestEntity));
        retval.append("    <lookup>" + Const.CR);
        for (i = 0; i < this.argumentField.length; ++i) {
            retval.append("      <arg>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.argumentField[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"parameter", (String)this.argumentParameter[i]));
            retval.append("        </arg>" + Const.CR);
        }
        for (i = 0; i < this.queryField.length; ++i) {
            retval.append("      <query>" + Const.CR);
            retval.append("        " + XMLHandler.addTagValue((String)"name", (String)this.queryField[i]));
            retval.append("        " + XMLHandler.addTagValue((String)"parameter", (String)this.queryParameter[i]));
            retval.append("        </query>" + Const.CR);
        }
        retval.append("      </lookup>" + Const.CR);
        retval.append("    <result>" + Const.CR);
        retval.append("      " + XMLHandler.addTagValue((String)"name", (String)this.fieldName));
        retval.append("      </result>" + Const.CR);
        return retval.toString();
    }

    private void readData(Node stepnode, List<? extends SharedObjectInterface> databases) throws KettleXMLException {
        try {
            this.postafile = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"postafile"));
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.url = XMLHandler.getTagValue((Node)stepnode, (String)"url");
            this.urlInField = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"urlInField"));
            this.urlField = XMLHandler.getTagValue((Node)stepnode, (String)"urlField");
            this.requestEntity = XMLHandler.getTagValue((Node)stepnode, (String)"requestEntity");
            Node lookup = XMLHandler.getSubNode((Node)stepnode, (String)"lookup");
            int nrargs = XMLHandler.countNodes((Node)lookup, (String)"arg");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                Node anode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"arg", (int)i);
                this.argumentField[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.argumentParameter[i] = XMLHandler.getTagValue((Node)anode, (String)"parameter");
            }
            int nrquery = XMLHandler.countNodes((Node)lookup, (String)"query");
            this.allocateQuery(nrquery);
            for (int i = 0; i < nrquery; ++i) {
                Node anode = XMLHandler.getSubNodeByNr((Node)lookup, (String)"query", (int)i);
                this.queryField[i] = XMLHandler.getTagValue((Node)anode, (String)"name");
                this.queryParameter[i] = XMLHandler.getTagValue((Node)anode, (String)"parameter");
            }
            this.fieldName = XMLHandler.getTagValue((Node)stepnode, (String)"result", (String)"name");
        }
        catch (Exception e) {
            throw new KettleXMLException(Messages.getString("HTTPPOSTMeta.Exception.UnableToReadStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void readRep(Repository rep, long id_step, List<DatabaseMeta> databases, Map<String, Counter> counters) throws KettleException {
        try {
            this.postafile = rep.getStepAttributeBoolean(id_step, "postafile");
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.url = rep.getStepAttributeString(id_step, "url");
            this.urlInField = rep.getStepAttributeBoolean(id_step, "urlInField");
            this.urlField = rep.getStepAttributeString(id_step, "urlField");
            this.requestEntity = rep.getStepAttributeString(id_step, "requestEntity");
            int nrargs = rep.countNrStepAttributes(id_step, "arg_name");
            this.allocate(nrargs);
            for (int i = 0; i < nrargs; ++i) {
                this.argumentField[i] = rep.getStepAttributeString(id_step, i, "arg_name");
                this.argumentParameter[i] = rep.getStepAttributeString(id_step, i, "arg_parameter");
            }
            int nrquery = rep.countNrStepAttributes(id_step, "query_name");
            this.allocateQuery(nrquery);
            for (int i = 0; i < nrquery; ++i) {
                this.queryField[i] = rep.getStepAttributeString(id_step, i, "query_name");
                this.queryParameter[i] = rep.getStepAttributeString(id_step, i, "query_parameter");
            }
            this.fieldName = rep.getStepAttributeString(id_step, "result_name");
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("HTTPPOSTMeta.Exception.UnexpectedErrorReadingStepInfo"), (Throwable)e);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_transformation, long id_step) throws KettleException {
        try {
            int i;
            rep.saveStepAttribute(id_transformation, id_step, "postafile", this.postafile);
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "url", this.url);
            rep.saveStepAttribute(id_transformation, id_step, "urlInField", this.urlInField);
            rep.saveStepAttribute(id_transformation, id_step, "urlField", this.urlField);
            rep.saveStepAttribute(id_transformation, id_step, "requestEntity", this.requestEntity);
            for (i = 0; i < this.argumentField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "arg_name", this.argumentField[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "arg_parameter", this.argumentParameter[i]);
            }
            for (i = 0; i < this.queryField.length; ++i) {
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "query_name", this.queryField[i]);
                rep.saveStepAttribute(id_transformation, id_step, (long)i, "query_parameter", this.queryParameter[i]);
            }
            rep.saveStepAttribute(id_transformation, id_step, "result_name", this.fieldName);
        }
        catch (Exception e) {
            throw new KettleException(Messages.getString("HTTPPOSTMeta.Exception.UnableToSaveStepInfo") + id_step, (Throwable)e);
        }
    }

    @Override
    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info) {
        CheckResult cr;
        if (input.length > 0) {
            cr = new CheckResult(1, Messages.getString("HTTPPOSTMeta.CheckResult.ReceivingInfoFromOtherSteps"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, Messages.getString("HTTPPOSTMeta.CheckResult.NoInpuReceived"), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = this.urlInField ? (Const.isEmpty((String)this.urlField) ? new CheckResult(4, Messages.getString("HTTPPOSTMeta.CheckResult.UrlfieldMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(4, Messages.getString("HTTPPOSTMeta.CheckResult.UrlfieldOk"), (CheckResultSourceInterface)stepMeta)) : (Const.isEmpty((String)this.url) ? new CheckResult(4, Messages.getString("HTTPPOSTMeta.CheckResult.UrlMissing"), (CheckResultSourceInterface)stepMeta) : new CheckResult(1, Messages.getString("HTTPPOSTMeta.CheckResult.UrlOk"), (CheckResultSourceInterface)stepMeta));
        remarks.add((CheckResultInterface)cr);
    }

    @Override
    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new HTTPPOST(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    @Override
    public StepDataInterface getStepData() {
        return new HTTPPOSTData();
    }

    @Override
    public boolean supportsErrorHandling() {
        return true;
    }
}

