/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.message.extension;

import de.rub.nds.modifiablevariable.ModifiableVariableFactory;
import de.rub.nds.modifiablevariable.ModifiableVariableProperty;
import de.rub.nds.modifiablevariable.bytearray.ModifiableByteArray;
import de.rub.nds.modifiablevariable.integer.ModifiableInteger;
import de.rub.nds.modifiablevariable.util.ByteArrayAdapter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class PSKKeyExchangeModesExtensionMessage
extends ExtensionMessage {
    @XmlJavaTypeAdapter(value=ByteArrayAdapter.class)
    private byte[] keyExchangeModesConfig;
    @ModifiableVariableProperty(type=ModifiableVariableProperty.Type.LENGTH)
    private ModifiableInteger keyExchangeModesListLength;
    @ModifiableVariableProperty
    private ModifiableByteArray keyExchangeModesListBytes;

    public PSKKeyExchangeModesExtensionMessage() {
        super(ExtensionType.PSK_KEY_EXCHANGE_MODES);
    }

    public PSKKeyExchangeModesExtensionMessage(Config tlsConfig) {
        super(ExtensionType.PSK_KEY_EXCHANGE_MODES);
        int length = tlsConfig.getPSKKeyExchangeModes().size();
        byte[] listBytes = new byte[length];
        for (int x = 0; x < length; ++x) {
            listBytes[x] = tlsConfig.getPSKKeyExchangeModes().get(x).getValue();
        }
        this.keyExchangeModesConfig = listBytes;
    }

    public ModifiableInteger getKeyExchangeModesListLength() {
        return this.keyExchangeModesListLength;
    }

    public void setKeyExchangeModesListLength(int length) {
        this.keyExchangeModesListLength = ModifiableVariableFactory.safelySetValue((ModifiableInteger)this.keyExchangeModesListLength, (Integer)length);
    }

    public ModifiableByteArray getKeyExchangeModesListBytes() {
        return this.keyExchangeModesListBytes;
    }

    public void setKeyExchangeModesListBytes(ModifiableByteArray keyExchangeModesListBytes) {
        this.keyExchangeModesListBytes = keyExchangeModesListBytes;
    }

    public void setKeyExchangeModesListBytes(byte[] bytes) {
        this.keyExchangeModesListBytes = ModifiableVariableFactory.safelySetValue((ModifiableByteArray)this.keyExchangeModesListBytes, (byte[])bytes);
    }

    public byte[] getKeyExchangeModesConfig() {
        return this.keyExchangeModesConfig;
    }

    public void setKeyExchangeModesConfig(byte[] keyExchangeModesConfig) {
        this.keyExchangeModesConfig = keyExchangeModesConfig;
    }
}

