/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.HandshakeMessageType;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.protocol.handler.HandshakeMessageHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.extension.ExtensionHandler;
import de.rub.nds.tlsattacker.core.protocol.handler.factory.HandlerFactory;
import de.rub.nds.tlsattacker.core.protocol.message.HelloRetryRequestMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.message.extension.KeyShareExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.HelloRetryRequestParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.HelloRetryRequestPreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.HelloRetryRequestSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class HelloRetryRequestHandler
extends HandshakeMessageHandler<HelloRetryRequestMessage> {
    private static final Logger LOGGER = LogManager.getLogger();

    public HelloRetryRequestHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public HelloRetryRequestParser getParser(byte[] message, int pointer) {
        return new HelloRetryRequestParser(pointer, message, this.tlsContext.getLastRecordVersion(), this.tlsContext.getConfig());
    }

    public HelloRetryRequestPreparator getPreparator(HelloRetryRequestMessage message) {
        return new HelloRetryRequestPreparator(this.tlsContext.getChooser(), message);
    }

    public HelloRetryRequestSerializer getSerializer(HelloRetryRequestMessage message) {
        return new HelloRetryRequestSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(HelloRetryRequestMessage message) {
        this.adjustProtocolVersion(message);
        this.adjustSelectedCiphersuite(message);
        if (message.getExtensions() != null) {
            for (ExtensionMessage extension : message.getExtensions()) {
                HandshakeMessageType handshakeMessageType = HandshakeMessageType.HELLO_RETRY_REQUEST;
                if (extension instanceof KeyShareExtensionMessage) {
                    handshakeMessageType = HandshakeMessageType.CLIENT_HELLO;
                }
                ExtensionHandler handler = HandlerFactory.getExtensionHandler(this.tlsContext, extension.getExtensionTypeConstant(), handshakeMessageType);
                handler.adjustTLSContext(extension);
            }
        }
    }

    private void adjustProtocolVersion(HelloRetryRequestMessage message) {
        ProtocolVersion version = ProtocolVersion.getProtocolVersion((byte[])message.getProtocolVersion().getValue());
        if (version != null) {
            this.tlsContext.setSelectedProtocolVersion(version);
            LOGGER.debug("Set SelectedProtocolVersion in Context to " + version.name());
        } else {
            LOGGER.warn("Did not Adjust ProtocolVersion since version is undefined " + ArrayConverter.bytesToHexString((byte[])((byte[])message.getProtocolVersion().getValue())));
        }
    }

    private void adjustSelectedCiphersuite(HelloRetryRequestMessage message) {
        CipherSuite suite = CipherSuite.getCipherSuite((byte[])message.getSelectedCipherSuite().getValue());
        this.tlsContext.setSelectedCipherSuite(suite);
        if (suite != null) {
            LOGGER.debug("Set SelectedCipherSuite in Context to " + suite.name());
        } else {
            LOGGER.warn("Could not determine selected CipherSuite. Not Adjusting Context");
        }
    }
}

