/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.extbrowser;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.logging.Level;
import org.netbeans.modules.extbrowser.ExtBrowserImpl;
import org.netbeans.modules.extbrowser.ExtWebBrowser;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;

class NbDefaultUnixBrowserImpl
extends ExtBrowserImpl {
    private static final String XDG_COMMAND = "xdg-open";
    private static final String XBROWSER_COMMAND = "x-www-browser";
    private static final boolean XDG_AVAILABLE = new File("/usr/bin/xdg-open").exists();
    private static final boolean XBROWSER_AVAILABLE = new File("/usr/bin/x-www-browser").exists();

    static boolean isAvailable() {
        return XDG_AVAILABLE || XBROWSER_AVAILABLE;
    }

    NbDefaultUnixBrowserImpl(ExtWebBrowser extWebBrowser) {
        this.extBrowserFactory = extWebBrowser;
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "" + System.currentTimeMillis() + "NbDefaultUnixBrowserImpl created with factory: " + this.extBrowserFactory);
        }
    }

    public void setURL(URL uRL) {
        if (ExtWebBrowser.getEM().isLoggable(Level.FINE)) {
            ExtWebBrowser.getEM().log(Level.FINE, "" + System.currentTimeMillis() + "NbDeaultUnixBrowserImpl.setUrl: " + uRL);
        }
        String string = uRL.toExternalForm();
        String string2 = XBROWSER_AVAILABLE ? XBROWSER_COMMAND : XDG_COMMAND;
        ProcessBuilder processBuilder = new ProcessBuilder(string2, string);
        try {
            Process process = processBuilder.start();
            RequestProcessor.getDefault().post((Runnable)new ProcessWatcher(process));
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    private static final class ProcessWatcher
    implements Runnable {
        private final Process p;

        ProcessWatcher(Process process) {
            this.p = process;
        }

        public void run() {
            block5: {
                try {
                    int n = this.p.waitFor();
                    if (n == 0) break block5;
                    StringBuilder stringBuilder = new StringBuilder();
                    InputStream inputStream = this.p.getErrorStream();
                    try {
                        int n2 = 0;
                        while ((n2 = inputStream.read()) != -1) {
                            stringBuilder.append((char)n2);
                        }
                    }
                    catch (IOException iOException) {
                        Exceptions.printStackTrace((Throwable)iOException);
                    }
                    ExtWebBrowser.getEM().log(Level.WARNING, stringBuilder.toString());
                }
                catch (InterruptedException interruptedException) {
                    Exceptions.printStackTrace((Throwable)interruptedException);
                }
            }
        }
    }
}

