/*
 * Decompiled with CFR 0.152.
 */
package io.github.skylot.raung.disasm.impl.visitors;

import io.github.skylot.raung.common.Directive;
import io.github.skylot.raung.common.RaungAccessFlags;
import io.github.skylot.raung.disasm.impl.RaungDisasmBuilder;
import io.github.skylot.raung.disasm.impl.utils.JavaVersion;
import io.github.skylot.raung.disasm.impl.utils.RaungTypes;
import io.github.skylot.raung.disasm.impl.utils.RaungWriter;
import io.github.skylot.raung.disasm.impl.visitors.RaungAnnotationVisitor;
import io.github.skylot.raung.disasm.impl.visitors.RaungFieldVisitor;
import io.github.skylot.raung.disasm.impl.visitors.RaungMethodVisitor;
import org.jetbrains.annotations.Nullable;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.ModuleVisitor;
import org.objectweb.asm.RecordComponentVisitor;
import org.objectweb.asm.TypePath;

public class RaungClassVisitor
extends ClassVisitor {
    private final RaungWriter writer = new RaungWriter();
    private final RaungDisasmBuilder args;
    private String clsFullName;

    public RaungClassVisitor(RaungDisasmBuilder args) {
        super(589824);
        this.args = args;
    }

    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        this.writer.add(Directive.VERSION.token()).space().add(version).add("  # ").add(JavaVersion.getNameStr(version));
        this.writer.startLine(Directive.CLASS).add(RaungAccessFlags.format((int)access, (RaungAccessFlags.Scope)RaungAccessFlags.Scope.CLASS)).add(name);
        if (!superName.equals("java/lang/Object")) {
            this.writer.startLine(Directive.SUPER).add(superName);
        }
        for (String iface : interfaces) {
            this.writer.startLine(Directive.IMPLEMENTS).add(iface);
        }
        if (signature != null) {
            this.writer.startLine(Directive.SIGNATURE).add(signature);
        }
        this.clsFullName = name;
        if (this.args.isAutoFrames()) {
            this.writer.startLine(".auto frames");
        } else if (this.args.isAutoMax()) {
            this.writer.startLine(".auto maxs");
        }
    }

    public void visitSource(String source, String debug) {
        this.writer.startLine(Directive.SOURCE).add('\"').add(source).add('\"');
    }

    public ModuleVisitor visitModule(String name, int access, String version) {
        this.writer.startLine("# TODO: module");
        return null;
    }

    public void visitNestHost(String nestHost) {
        this.writer.newLine().startLine(Directive.NEST).add("host").space().add(nestHost);
    }

    public void visitNestMember(String nestMember) {
        this.writer.newLine().startLine(Directive.NEST).add("member").space().add(nestMember);
    }

    public void visitOuterClass(String owner, String name, String descriptor) {
        this.writer.newLine().startLine(Directive.OUTERCLASS).add(owner).space().add(name).space().add(descriptor);
    }

    public void visitInnerClass(String name, String outerName, String innerName, int access) {
        this.writer.startLine().startLine(Directive.INNERCLASS).add(RaungAccessFlags.format((int)access, (RaungAccessFlags.Scope)RaungAccessFlags.Scope.CLASS)).add(innerName).space().add(outerName);
        if (!name.equals(this.clsFullName)) {
            this.writer.space().add(name);
        }
    }

    public AnnotationVisitor visitAnnotation(String descriptor, boolean visible) {
        return RaungAnnotationVisitor.buildAnnotation(this, descriptor, visible);
    }

    public AnnotationVisitor visitTypeAnnotation(int typeRef, TypePath typePath, String descriptor, boolean visible) {
        return RaungAnnotationVisitor.buildTypeAnnotation(this, typeRef, typePath, descriptor, visible);
    }

    public void visitAttribute(Attribute attribute) {
        this.writer.startLine("# TODO: class attribute: " + attribute);
    }

    public void visitPermittedSubclass(String permittedSubclass) {
        this.writer.startLine("# TODO: class permitted subclass: " + permittedSubclass);
    }

    public RecordComponentVisitor visitRecordComponent(String name, String descriptor, String signature) {
        this.writer.startLine("# TODO: record component: " + name + " " + descriptor + " " + signature);
        return null;
    }

    public FieldVisitor visitField(int access, String name, String descriptor, @Nullable String signature, Object value) {
        this.writer.startLine().startLine(Directive.FIELD).add(RaungAccessFlags.format((int)access, (RaungAccessFlags.Scope)RaungAccessFlags.Scope.FIELD)).add(name).space().add(descriptor);
        if (value != null) {
            this.writer.add(" = ").add(RaungTypes.format(value));
        }
        boolean closeField = false;
        this.writer.increaseIndent();
        if (signature != null) {
            this.writer.startLine(Directive.SIGNATURE).add(signature);
            closeField = true;
        }
        return new RaungFieldVisitor(this, closeField);
    }

    public MethodVisitor visitMethod(int access, String name, String descriptor, @Nullable String signature, @Nullable String[] exceptions) {
        this.writer.newLine().startLine(Directive.METHOD).add(RaungAccessFlags.format((int)access, (RaungAccessFlags.Scope)RaungAccessFlags.Scope.METHOD)).add(name).add(descriptor).setIndent(2);
        if (exceptions != null) {
            for (String exc : exceptions) {
                this.writer.startLine(Directive.THROW).add(exc);
            }
        }
        if (signature != null) {
            this.writer.startLine(Directive.SIGNATURE).add(signature);
        }
        return new RaungMethodVisitor(this);
    }

    public void visitEnd() {
        this.writer.newLine();
    }

    public int getApi() {
        return this.api;
    }

    public RaungWriter getWriter() {
        return this.writer;
    }

    public RaungDisasmBuilder getArgs() {
        return this.args;
    }

    public String getClsFullName() {
        return this.clsFullName;
    }

    public String getResult() {
        return this.writer.getCode();
    }
}

